/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.templates.impl;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplateConfig;
import org.exoplatform.services.cms.templates.impl.TemplatePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.security.SecurityService;
import org.exoplatform.services.templates.velocity.impl.JCRResourceLoaderImpl;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateServiceImpl
implements TemplateService,
Startable {
    private RepositoryService repositoryService_;
    private ConfigurationManager configManager_;
    private CmsConfigurationService cmsConfigService_;
    private SecurityService securityService_;
    private CacheService cacheService_;
    private PortalContainerInfo containerInfo_;
    private String cmsTemplatesBasePath_;
    private List<TemplatePlugin> plugins_;

    public TemplateServiceImpl(RepositoryService jcrService, ConfigurationManager configManager, CmsConfigurationService cmsConfigService, SecurityService securityService, PortalContainerInfo containerInfo, CacheService cacheService) throws Exception {
        this.containerInfo_ = containerInfo;
        this.cacheService_ = cacheService;
        this.cmsConfigService_ = cmsConfigService;
        this.securityService_ = securityService;
        this.repositoryService_ = jcrService;
        this.configManager_ = configManager;
        this.plugins_ = new ArrayList<TemplatePlugin>();
        this.cmsTemplatesBasePath_ = this.cmsConfigService_.getJcrPath("templatesPath");
    }

    public void start() {
        try {
            this.initRepository();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    public void addTemplates(ComponentPlugin plugin) {
        if (plugin instanceof TemplatePlugin) {
            this.plugins_.add((TemplatePlugin)plugin);
        }
    }

    private void initRepository() throws Exception {
        Session session = this.repositoryService_.getRepository().getSystemSession(this.cmsConfigService_.getWorkspace());
        Node root = session.getRootNode();
        List nodetypes = null;
        for (int j = 0; j < this.plugins_.size(); ++j) {
            nodetypes = this.plugins_.get(j).getNodeTypes();
            String location = this.plugins_.get(j).getLocation();
            if (nodetypes.isEmpty()) {
                return;
            }
            TemplateConfig.NodeType nodeType2 = (TemplateConfig.NodeType)nodetypes.iterator().next();
            String nodeTypeName = nodeType2.getNodetypeName();
            try {
                session.getItem(this.cmsTemplatesBasePath_ + "/" + nodeTypeName);
                return;
            }
            catch (PathNotFoundException e) {
                Node templatesHome = Utils.makePath(root, this.cmsTemplatesBasePath_, NT_UNSTRUCTURED);
                String sourcePath = this.cmsConfigService_.getContentLocation() + "/system" + this.cmsTemplatesBasePath_.substring(this.cmsTemplatesBasePath_.lastIndexOf("/"));
                if (location.equals("jar")) {
                    sourcePath = "jar:/conf/system" + this.cmsTemplatesBasePath_.substring(this.cmsTemplatesBasePath_.lastIndexOf("/"));
                }
                for (TemplateConfig.NodeType nodeType2 : nodetypes) {
                    nodeTypeName = nodeType2.getNodetypeName();
                    Node nodeTypeHome = null;
                    if (!templatesHome.hasNode(nodeTypeName)) {
                        nodeTypeHome = Utils.makePath(templatesHome, nodeTypeName, NT_UNSTRUCTURED);
                        if (nodeType2.getDocumentTemplate()) {
                            nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, true);
                        } else {
                            nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, false);
                        }
                    } else {
                        nodeTypeHome = templatesHome.getNode(nodeTypeName);
                    }
                    nodeTypeHome.setProperty(TEMPLATE_LABEL, nodeType2.getLabel());
                    List dialogs = nodeType2.getReferencedDialog();
                    Node dialogsHome = Utils.makePath(nodeTypeHome, DIALOGS, NT_UNSTRUCTURED);
                    this.addNode(sourcePath, dialogsHome, dialogs);
                    List views = nodeType2.getReferencedView();
                    Node viewsHome = Utils.makePath(nodeTypeHome, VIEWS, NT_UNSTRUCTURED);
                    this.addNode(sourcePath, viewsHome, views);
                }
                continue;
            }
        }
        root.save();
    }

    private void addNode(String basePath, Node nodeTypeHome, List templates) throws Exception {
        for (TemplateConfig.Template template : templates) {
            String templateFileName = template.getTemplateFile();
            String path = basePath + templateFileName;
            InputStream in = this.configManager_.getInputStream(path);
            String nodeName = templateFileName.substring(templateFileName.lastIndexOf("/") + 1, templateFileName.indexOf("."));
            Node contentNode = nodeTypeHome.addNode(nodeName, EXO_TEMPLATE);
            contentNode.setProperty(EXO_ROLES_PROP, template.getParsedRoles());
            contentNode.setProperty(EXO_TEMPLATE_FILE_PROP, in);
        }
    }

    public Node getTemplatesHome() throws Exception {
        Session session;
        try {
            session = this.repositoryService_.getRepository().login(this.cmsConfigService_.getWorkspace());
        }
        catch (Exception e) {
            session = this.repositoryService_.getRepository().getSystemSession(this.cmsConfigService_.getWorkspace());
        }
        return (Node)session.getItem(this.cmsTemplatesBasePath_);
    }

    public boolean isManagedNodeType(String nodeTypeName) throws Exception {
        Node systemTemplatesHome = this.getSystemTemplatesHome();
        NodeIterator iter = systemTemplatesHome.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (!node.getName().equals(nodeTypeName)) continue;
            return true;
        }
        return false;
    }

    public NodeIterator getAllTemplatesOfNodeType(boolean isDialog, String nodeTypeName) throws Exception {
        Node templateHome = this.getTemplatesHome();
        Node nodeTypeHome = templateHome.getNode(nodeTypeName);
        if (isDialog) {
            return nodeTypeHome.getNode(DIALOGS).getNodes();
        }
        return nodeTypeHome.getNode(VIEWS).getNodes();
    }

    public String getDefaultTemplatePath(boolean isDialog, String nodeTypeName) {
        if (isDialog) {
            return this.cmsTemplatesBasePath_ + "/" + nodeTypeName + DEFAULT_DIALOGS_PATH;
        }
        return this.cmsTemplatesBasePath_ + "/" + nodeTypeName + DEFAULT_VIEWS_PATH;
    }

    public Node getTemplateNode(boolean isDialog, String nodeTypeName, String templateName) throws Exception {
        String type = DIALOGS;
        if (!isDialog) {
            type = VIEWS;
        }
        Node nodeTypeNode = this.getSystemTemplatesHome().getNode(nodeTypeName);
        return nodeTypeNode.getNode(type).getNode(templateName);
    }

    private Node getTemplateNode(boolean isDialog, String nodeTypeName) throws Exception {
        String type = DIALOGS;
        if (!isDialog) {
            type = VIEWS;
        }
        String userId = null;
        try {
            userId = SessionContainer.getInstance().getRemoteUser();
        }
        catch (Exception e) {
            // empty catch block
        }
        Node nodeTypeNode = this.getSystemTemplatesHome().getNode(nodeTypeName);
        NodeIterator templateIter = nodeTypeNode.getNode(type).getNodes();
        Node selectedTemplateNode = null;
        while (templateIter.hasNext()) {
            Node node = templateIter.nextNode();
            Value[] roles = node.getProperty(EXO_ROLES_PROP).getValues();
            for (int i = 0; i < roles.length; ++i) {
                String templateRole = roles[i].getString();
                if ("*".equals(templateRole)) {
                    selectedTemplateNode = node;
                    continue;
                }
                if (userId != null && userId.equals(templateRole)) {
                    return node;
                }
                if (userId == null || !this.securityService_.hasMembershipInGroup(userId, templateRole)) continue;
                return node;
            }
        }
        return selectedTemplateNode;
    }

    public String getTemplatePath(boolean isDialog, String nodeTypeName) throws Exception {
        Node templateNode = this.getTemplateNode(isDialog, nodeTypeName);
        return templateNode.getPath();
    }

    public String getTemplatePath(boolean isDialog, String nodeTypeName, String templateName) throws Exception {
        Node templateNode = this.getTemplateNode(isDialog, nodeTypeName, templateName);
        return templateNode.getPath();
    }

    public String getTemplate(boolean isDialog, String nodeTypeName) throws Exception {
        Node templateNode = this.getTemplateNode(isDialog, nodeTypeName);
        return templateNode.getProperty(EXO_TEMPLATE_FILE_PROP).getString();
    }

    public String getTemplateLabel(String nodeTypeName) throws Exception {
        Session session = this.repositoryService_.getRepository().getSystemSession(this.cmsConfigService_.getWorkspace());
        Node templateHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        Node nodeType = templateHome.getNode(nodeTypeName);
        if (nodeType.hasProperty("label")) {
            return nodeType.getProperty("label").getString();
        }
        return "";
    }

    public String getTemplate(boolean isDialog, String nodeTypeName, String templateName) throws Exception {
        Node templateNode = this.getTemplateNode(isDialog, nodeTypeName, templateName);
        return templateNode.getProperty(EXO_TEMPLATE_FILE_PROP).getString();
    }

    public String getTemplateRoles(boolean isDialog, String nodeTypeName, String templateName) throws Exception {
        Node templateNode = this.getTemplateNode(isDialog, nodeTypeName, templateName);
        Value[] values = templateNode.getProperty(EXO_ROLES_PROP).getValues();
        StringBuffer roles = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (roles.length() > 0) {
                roles.append("; ");
            }
            roles.append(values[i].getString());
        }
        return roles.toString();
    }

    public void removeTemplate(boolean isDialog, String nodeTypeName, String templateName) throws Exception {
        Node templatesHome = this.getTemplatesHome();
        Node nodeTypeHome = templatesHome.getNode(nodeTypeName);
        Node specifiedTemplatesHome = null;
        specifiedTemplatesHome = isDialog ? nodeTypeHome.getNode(DIALOGS) : nodeTypeHome.getNode(VIEWS);
        Node contentNode = specifiedTemplatesHome.getNode(templateName);
        String path = contentNode.getPath();
        contentNode.remove();
        nodeTypeHome.save();
        this.removeFromCache(path);
    }

    public void removeManagedNodeType(String nodeTypeName) throws Exception {
        Node templatesHome = this.getTemplatesHome();
        Node managedNodeType = templatesHome.getNode(nodeTypeName);
        managedNodeType.remove();
        templatesHome.save();
    }

    public void addTemplate(boolean isDialog, String nodeTypeName, String label, boolean isDocumentTemplate, String templateName, String[] roles, String templateFile) throws Exception {
        Node templatesHome = this.getTemplatesHome();
        Node nodeTypeHome = null;
        if (!templatesHome.hasNode(nodeTypeName)) {
            nodeTypeHome = Utils.makePath(templatesHome, nodeTypeName, NT_UNSTRUCTURED);
            if (isDocumentTemplate) {
                nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, true);
            } else {
                nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, false);
            }
            nodeTypeHome.setProperty(TEMPLATE_LABEL, label);
        } else {
            nodeTypeHome = templatesHome.getNode(nodeTypeName);
        }
        Node specifiedTemplatesHome = null;
        specifiedTemplatesHome = isDialog ? (!nodeTypeHome.hasNode(DIALOGS) ? Utils.makePath(nodeTypeHome, DIALOGS, NT_UNSTRUCTURED) : nodeTypeHome.getNode(DIALOGS)) : (!nodeTypeHome.hasNode(VIEWS) ? Utils.makePath(nodeTypeHome, VIEWS, NT_UNSTRUCTURED) : nodeTypeHome.getNode(VIEWS));
        Node contentNode = null;
        contentNode = specifiedTemplatesHome.hasNode(templateName) ? specifiedTemplatesHome.getNode(templateName) : specifiedTemplatesHome.addNode(templateName, EXO_TEMPLATE);
        contentNode.setProperty(EXO_ROLES_PROP, roles);
        contentNode.setProperty(EXO_TEMPLATE_FILE_PROP, templateFile);
        templatesHome.save();
        this.removeFromCache(contentNode.getPath());
    }

    public List<String> getDocumentTemplates() throws Exception {
        ArrayList<String> templates = new ArrayList<String>();
        Node templatesHome = this.getSystemTemplatesHome();
        NodeIterator templateIter = templatesHome.getNodes();
        while (templateIter.hasNext()) {
            Node template = templateIter.nextNode();
            if (!template.getProperty(DOCUMENT_TEMPLATE_PROP).getBoolean()) continue;
            templates.add(template.getName());
        }
        return templates;
    }

    public List<Node> getNodeDocumentTemplates() throws Exception {
        ArrayList<Node> templates = new ArrayList<Node>();
        Node templatesHome = this.getSystemTemplatesHome();
        NodeIterator templateIter = templatesHome.getNodes();
        while (templateIter.hasNext()) {
            Node template = templateIter.nextNode();
            if (!template.getProperty(DOCUMENT_TEMPLATE_PROP).getBoolean()) continue;
            templates.add(template);
        }
        return templates;
    }

    private Node getSystemTemplatesHome() throws Exception {
        Session session = this.repositoryService_.getRepository().getSystemSession(this.cmsConfigService_.getWorkspace());
        Node templatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        return templatesHome;
    }

    protected void removeFromCache(String templateName) {
        try {
            ExoCache jcrcache_ = this.cacheService_.getCacheInstance(JCRResourceLoaderImpl.class.getName());
            String portalName = this.containerInfo_.getContainerName();
            String key = portalName + "jcr:" + templateName;
            Object cachedobject = jcrcache_.get((Serializable)((Object)key));
            if (cachedobject != null) {
                jcrcache_.remove((Serializable)((Object)key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

