/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.transform.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.transform.impl.BaseDocumentTransformer;
import org.exoplatform.services.cms.transform.impl.MimeTypesConfig;
import org.w3c.dom.Document;
import org.w3c.tidy.Tidy;
import org.xhtmlrenderer.pdf.ITextRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExoDocumentTransformer
extends BaseDocumentTransformer {
    private static Tidy tidy;
    private MimeTypesConfig mimeTypeConfig_;

    public ExoDocumentTransformer(InitParams initParams) {
        Properties props = new Properties();
        props.setProperty("quiet", "true");
        props.setProperty("quoteAmpersand", "true");
        props.setProperty("xHtml", "true");
        props.setProperty("showWarnings", "false");
        props.setProperty("tidyMark", "false");
        props.setProperty("clean", "true");
        tidy = new Tidy();
        tidy.setConfigurationFromProps(props);
        this.mimeTypeConfig_ = (MimeTypesConfig)initParams.getObjectParamValues(MimeTypesConfig.class).get(0);
    }

    public boolean transform(InputStream html, String sourceMimeType, OutputStream out, String destinationMimeType) throws Exception {
        if (!this.canTransform(sourceMimeType, destinationMimeType)) {
            return false;
        }
        Document document = this.convertHtmlToXhtml(html);
        ExternalContext ext = FacesContext.getCurrentInstance().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)ext.getRequest();
        String baseUrl = request.getScheme() + "://" + request.getServerName() + ":" + String.format("%s", request.getServerPort());
        ITextRenderer renderer = new ITextRenderer();
        renderer.setDocument(document, baseUrl);
        renderer.layout();
        try {
            renderer.createPDF(out);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean canTransform(String sourceMimeType, String destinationMimeType) throws Exception {
        return this.getSourceMimeTypes().contains(sourceMimeType) && this.getDestinationMimeType().equalsIgnoreCase(destinationMimeType);
    }

    public String getDestinationMimeType() throws Exception {
        return this.mimeTypeConfig_.getDestinationMimeType();
    }

    public List<String> getSourceMimeTypes() throws Exception {
        return this.mimeTypeConfig_.getSourceMimeTypes();
    }

    private Document convertHtmlToXhtml(InputStream html) {
        return tidy.parseDOM(html, null);
    }
}

