/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.transform.impl;

import com.artofsolving.jodconverter.DocumentFormat;
import com.artofsolving.jodconverter.DocumentFormatRegistry;
import com.artofsolving.jodconverter.XmlDocumentFormatRegistry;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.cms.transform.impl.BaseDocumentTransformer;
import org.exoplatform.services.cms.transform.impl.MimeTypesConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenOfficeTransformer
extends BaseDocumentTransformer {
    private static DocumentFormatRegistry formatRegistry;
    private String ooConnectionHost_ = "localhost";
    private int ooConnectionPort_ = 8100;
    private String ooConnectionType_;
    private MimeTypesConfig mimeTypeConfig_;
    private OpenOfficeConnection connection_ = null;

    public OpenOfficeTransformer(InitParams initParams) {
        this.mimeTypeConfig_ = (MimeTypesConfig)initParams.getObjectParamValues(MimeTypesConfig.class).get(0);
        PropertiesParam OOConnectionPropperties = initParams.getPropertiesParam("openoffice.connection.properties");
        this.ooConnectionHost_ = OOConnectionPropperties.getProperty("openoffice.connection.host");
        this.ooConnectionPort_ = Integer.parseInt(OOConnectionPropperties.getProperty("openoffice.connection.port"));
        this.ooConnectionType_ = OOConnectionPropperties.getProperty("openoffice.connection.type");
        this.loadDocumentFomatConfiguaration();
    }

    public boolean transform(InputStream input, String soureMimeType, OutputStream output, String destinationMimeType) throws Exception {
        if (!this.canTransform(soureMimeType, destinationMimeType)) {
            return false;
        }
        DocumentFormat sourceFormat = formatRegistry.getFormatByMimeType(soureMimeType);
        DocumentFormat destinationFormat = formatRegistry.getFormatByMimeType(destinationMimeType);
        try {
            if (this.connection_ == null) {
                this.connection_ = new SocketOpenOfficeConnection(this.ooConnectionHost_, this.ooConnectionPort_);
            }
            if (!this.connection_.isConnected()) {
                this.connection_.connect();
            }
            OpenOfficeDocumentConverter converter = new OpenOfficeDocumentConverter(this.connection_);
            converter.convert(input, sourceFormat, output, destinationFormat);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean canTransform(String sourceMimeType, String destinationMimeType) throws Exception {
        DocumentFormat sourceFormat = formatRegistry.getFormatByMimeType(sourceMimeType);
        DocumentFormat destinationFormat = formatRegistry.getFormatByMimeType(destinationMimeType);
        if (sourceFormat == null || destinationFormat == null) {
            return false;
        }
        return destinationFormat.isExportableFrom(sourceFormat.getFamily());
    }

    public String getDestinationMimeType() throws Exception {
        return this.mimeTypeConfig_.getDestinationMimeType();
    }

    public List<String> getSourceMimeTypes() throws Exception {
        return this.mimeTypeConfig_.getSourceMimeTypes();
    }

    private void loadDocumentFomatConfiguaration() {
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("document-formats.xml");
            formatRegistry = new XmlDocumentFormatRegistry(inputStream);
        }
        catch (Exception e) {
            formatRegistry = new XmlDocumentFormatRegistry();
        }
    }
}

