/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.templates.velocity.impl;

import java.io.InputStream;
import java.io.Serializable;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceFactory;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.CmsConfigurationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.templates.velocity.ResourceLoaderPlugin;
import org.exoplatform.services.templates.velocity.impl.VelocityServiceImpl;

public class JCRResourceLoaderImpl
extends ResourceLoaderPlugin {
    protected ExoCache jcrcache_;
    private RepositoryService repositoryService_;
    private PortalContainerInfo containerInfo_;
    private CmsConfigurationService cmsConfig_;

    public JCRResourceLoaderImpl(RepositoryService service, CacheService cacheService, CmsConfigurationService cmsConfig, PortalContainerInfo containerInfo) throws Exception {
        this.jcrcache_ = cacheService.getCacheInstance(JCRResourceLoaderImpl.class.getName());
        this.repositoryService_ = service;
        this.containerInfo_ = containerInfo;
        this.cmsConfig_ = cmsConfig;
    }

    public void init(ExtendedProperties configuration) {
    }

    public synchronized InputStream getResourceStream(String templateName) throws ResourceNotFoundException {
        try {
            ManageableRepository repository = this.repositoryService_.getRepository();
            Session session = repository.getSystemSession(this.cmsConfig_.getWorkspace());
            Node node = (Node)session.getItem(templateName);
            NodeType type = node.getPrimaryNodeType();
            if ("exo:template".equals(type.getName())) {
                return node.getProperty("exo:templateFile").getStream();
            }
        }
        catch (Exception ex) {
            throw new ResourceNotFoundException("Error: " + ex.getMessage());
        }
        throw new ResourceNotFoundException("Cannot retrieve data for node " + templateName + "Make sure you have a valid path and node type is exo:template");
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }

    public Resource getResource(String resourceName, int resourceType, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        String portalName = this.containerInfo_.getContainerName();
        String key = portalName + resourceName;
        Resource resource = (Resource)this.jcrcache_.get((Serializable)((Object)key));
        if (resource != null) {
            return resource;
        }
        String path = resourceName.substring(4, resourceName.length());
        resource = ResourceFactory.getResource((String)path, (int)resourceType);
        if (this.rsvc != null) {
            resource.setRuntimeServices(this.rsvc);
        } else {
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            VelocityServiceImpl vcservice = (VelocityServiceImpl)exoContainer.getComponentInstancesOfType(VelocityServiceImpl.class).get(0);
            resource.setRuntimeServices((RuntimeServices)vcservice);
        }
        resource.setName(path);
        resource.setEncoding(encoding);
        resource.setResourceLoader((ResourceLoader)this);
        resource.process();
        this.jcrcache_.put((Serializable)((Object)key), (Object)resource);
        return resource;
    }

    public void removeFromCache(String resourceName) {
        try {
            String portalName = this.containerInfo_.getContainerName();
            String key = portalName + resourceName;
            Object cachedObject = this.jcrcache_.get((Serializable)((Object)key));
            if (cachedObject != null) {
                this.jcrcache_.remove((Serializable)((Object)key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean cachedResource(String resourceName) {
        try {
            String portalName = this.containerInfo_.getContainerName();
            String key = portalName + resourceName;
            Object cachedObject = this.jcrcache_.get((Serializable)((Object)key));
            return cachedObject != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean canLoadResource(String s) {
        return s.startsWith("jcr:");
    }
}

