/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XFrame;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import org.exoplatform.applications.ooplugin.BrowseDialog;
import org.exoplatform.applications.ooplugin.Log;
import org.exoplatform.applications.ooplugin.ViewVersions;
import org.exoplatform.applications.ooplugin.WebDavConfig;
import org.exoplatform.applications.ooplugin.events.ActionListener;
import org.exoplatform.applications.ooplugin.events.ItemListener;
import org.exoplatform.frameworks.webdavclient.TextUtils;
import org.exoplatform.frameworks.webdavclient.documents.ResponseDoc;
import org.exoplatform.frameworks.webdavclient.properties.VersionNameProp;

public class OpenDialog
extends BrowseDialog {
    private static final String DIALOGNAME = "_OpenDialog";
    public static final String BTN_VERSIONS = "btnVersions";
    public static final String BTN_OPEN = "btnOpen";
    private Thread launchThread;
    private Thread viewVersionEnableThread;

    public OpenDialog(WebDavConfig config, XComponentContext xComponentContext, XFrame xFrame, XToolkit xToolkit) {
        super(config, xComponentContext, xFrame, xToolkit);
        this.dialogName = DIALOGNAME;
        this.addHandler(BTN_OPEN, 1, new OpenClick());
        this.addHandler("comboPath", 2, new PathChanged());
        this.addHandler(BTN_VERSIONS, 1, new VersionsClick());
        this.launchThread = new LaunchThread();
        this.launchThread.start();
    }

    protected void enableVersionView(boolean isEnabled) {
        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.xControlContainer.getControl(BTN_VERSIONS))).setEnable(isEnabled);
    }

    protected void disableAll() {
        super.disableAll();
    }

    protected void enableAll() {
        super.enableAll();
    }

    private class VersionsClick
    extends ActionListener {
        private VersionsClick() {
        }

        public void actionPerformed(ActionEvent arg0) {
            try {
                int selectedPos = OpenDialog.this.getSelectedItemPos();
                if (selectedPos < 0) {
                    return;
                }
                ResponseDoc response = (ResponseDoc)OpenDialog.this.responses.get(selectedPos);
                String href = TextUtils.UnEscape(response.getHref(), '%');
                if (!href.startsWith(OpenDialog.this.config.getContext().getServerPrefix())) {
                    OpenDialog.this.showMessageBox("Can't load version list.");
                    return;
                }
                String remoteHref = href.substring(OpenDialog.this.config.getContext().getServerPrefix().length());
                OpenDialog.this.prepareTmpPath(OpenDialog.this.currentPath);
                ViewVersions opVersions = new ViewVersions(OpenDialog.this.config, OpenDialog.this.xComponentContext, OpenDialog.this.xFrame, OpenDialog.this.xToolkit, remoteHref);
                boolean needClose = opVersions.createDialogEx();
                if (needClose) {
                    OpenDialog.this.xDialog.endExecute();
                }
            }
            catch (Exception exc) {
                Log.info("Unhandled exception. " + exc.getMessage(), exc);
            }
        }
    }

    private class OpenClick
    extends ActionListener {
        private OpenClick() {
        }

        public void actionPerformed(ActionEvent arg0) {
            OpenDialog.this.doSelectItem();
        }
    }

    private class PathChanged
    extends ItemListener {
        private PathChanged() {
        }

        public void itemStateChanged(ItemEvent arg0) {
            String serverPrefix;
            XTextComponent xComboText = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)OpenDialog.this.xControlContainer.getControl("comboPath"));
            String path = xComboText.getText();
            if (!path.startsWith(serverPrefix = OpenDialog.this.config.getContext().getServerPrefix())) {
                Log.info("Can't connect remote WebDav server!!!");
                return;
            }
            if ("".equals(path = path.substring(serverPrefix.length()))) {
                path = "/";
            }
            OpenDialog.this.currentPath = path;
            OpenDialog.this.doPropFind();
        }
    }

    private class ViewVersionsButtonEnableThread
    extends Thread {
        private ViewVersionsButtonEnableThread() {
        }

        public void run() {
            while (true) {
                block5: {
                    try {
                        while (true) {
                            Thread.sleep(100L);
                            int selectedPos = OpenDialog.this.getSelectedItemPos();
                            if (selectedPos < 0) break;
                            ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)OpenDialog.this.xControlContainer.getControl(OpenDialog.BTN_OPEN))).setEnable(true);
                            ResponseDoc response = (ResponseDoc)OpenDialog.this.responses.get(selectedPos);
                            VersionNameProp versionNameProperty = (VersionNameProp)response.getProperty("version-name");
                            if (versionNameProperty != null && versionNameProperty.getStatus() == 200) {
                                OpenDialog.this.enableVersionView(true);
                                continue;
                            }
                            break block5;
                            break;
                        }
                        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)OpenDialog.this.xControlContainer.getControl(OpenDialog.BTN_OPEN))).setEnable(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                OpenDialog.this.enableVersionView(false);
            }
        }
    }

    private class LaunchThread
    extends Thread {
        private LaunchThread() {
        }

        public void run() {
            try {
                while (!OpenDialog.this.enabled) {
                    Thread.sleep(100L);
                }
                Thread.sleep(100L);
                OpenDialog.this.viewVersionEnableThread = new ViewVersionsButtonEnableThread();
                OpenDialog.this.viewVersionEnableThread.start();
                OpenDialog.this.doPropFind();
            }
            catch (Exception exc) {
                Log.info("Unhandled exception. " + exc.getMessage());
            }
        }
    }
}

