/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.webdavclient.commands;

import java.util.ArrayList;
import java.util.HashMap;
import org.exoplatform.frameworks.webdavclient.WebDavContext;
import org.exoplatform.frameworks.webdavclient.commands.MultistatusCommand;
import org.exoplatform.frameworks.webdavclient.request.NameSpaceRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DavPropPatch
extends MultistatusCommand {
    protected HashMap<String, ArrayList<String>> propSet = new HashMap();
    protected ArrayList<String> propRemove = new ArrayList();
    protected NameSpaceRegistry nsRegistry = new NameSpaceRegistry();

    public DavPropPatch(WebDavContext context) throws Exception {
        super(context);
        this.commandName = "PROPPATCH";
    }

    public void setProperty(String propertyName, String propertyValue) {
        if (this.propSet.containsKey(propertyName)) {
            ArrayList<String> values = this.propSet.get(propertyName);
            values.add(propertyValue);
        } else {
            ArrayList<String> value = new ArrayList<String>();
            value.add(propertyValue);
            if (this.nsRegistry.registerNameSpace(propertyName)) {
                this.propSet.put(propertyName, value);
            } else {
                this.propSet.put("A:" + propertyName, value);
            }
        }
    }

    public void removeProperty(String propertyName) {
        if (this.nsRegistry.registerNameSpace(propertyName)) {
            this.propRemove.add(propertyName);
        } else {
            this.propRemove.add("A:" + propertyName);
        }
    }

    public void finalExecute() {
    }

    public Element toXml(Document xmlDocument) {
        Element propUpdateEl = xmlDocument.createElementNS("DAV:", "A:propertyupdate");
        xmlDocument.appendChild(propUpdateEl);
        this.nsRegistry.fillNameSpaces(propUpdateEl);
        Element removeEl = xmlDocument.createElement("A:remove");
        propUpdateEl.appendChild(removeEl);
        Element propRemoveEl = xmlDocument.createElement("A:prop");
        removeEl.appendChild(propRemoveEl);
        for (int i = 0; i < this.propRemove.size(); ++i) {
            String propName = this.propRemove.get(i);
            Element curPropEl = xmlDocument.createElement(propName);
            propRemoveEl.appendChild(curPropEl);
        }
        Element setEl = xmlDocument.createElement("A:set");
        propUpdateEl.appendChild(setEl);
        Element propSetEl = xmlDocument.createElement("A:prop");
        setEl.appendChild(propSetEl);
        for (String propName : this.propSet.keySet()) {
            ArrayList<String> values = this.propSet.get(propName);
            for (int i = 0; i < values.size(); ++i) {
                Element curPropEl = xmlDocument.createElement(propName);
                propSetEl.appendChild(curPropEl);
                curPropEl.setTextContent(values.get(i));
            }
        }
        return propUpdateEl;
    }
}

