/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.XComboBox;
import com.sun.star.awt.XFixedText;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XFrame;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.exoplatform.applications.ooplugin.Log;
import org.exoplatform.applications.ooplugin.PlugInDialog;
import org.exoplatform.applications.ooplugin.WebDavConfig;
import org.exoplatform.applications.ooplugin.events.ActionListener;
import org.exoplatform.frameworks.webdavclient.TextUtils;
import org.exoplatform.frameworks.webdavclient.commands.DavPropFind;
import org.exoplatform.frameworks.webdavclient.documents.Multistatus;
import org.exoplatform.frameworks.webdavclient.documents.ResponseDoc;
import org.exoplatform.frameworks.webdavclient.properties.CommonProp;
import org.exoplatform.frameworks.webdavclient.properties.ContentLengthProp;
import org.exoplatform.frameworks.webdavclient.properties.DisplayNameProp;
import org.exoplatform.frameworks.webdavclient.properties.LastModifiedProp;
import org.exoplatform.frameworks.webdavclient.properties.ResourceTypeProp;
import org.exoplatform.frameworks.webdavclient.properties.VersionNameProp;

public abstract class BrowseDialog
extends PlugInDialog {
    public static final int VNAME_LEN = 3;
    public static final int NAME_LEN = 26;
    public static final int SIZE_LEN = 38;
    public static final int LASTMODOFIED_SIZE = 68;
    public static final String BTN_PREV = "btnPrev";
    public static final String LST_ITEMS = "lstItems";
    public static final String COMBO_PATH = "comboPath";
    public static final String BTN_CANCEL = "btnCancel";
    public static final String LBL_TABLEHEAD = "lblTableHead";
    protected String currentPath = "/";
    protected Thread openThread;
    protected ArrayList<ResponseDoc> responses = new ArrayList();
    protected boolean isNeedAddHandlers = true;

    public BrowseDialog(WebDavConfig config, XComponentContext xComponentContext, XFrame xFrame, XToolkit xToolkit) {
        super(config, xComponentContext, xFrame, xToolkit);
    }

    public void createDialog() throws com.sun.star.uno.Exception {
        if (this.isNeedAddHandlers) {
            this.addHandler(LST_ITEMS, 3, new ListItemsClick());
            this.addHandler(BTN_PREV, 1, new PrevClick());
        }
        super.createDialog();
    }

    public boolean launchBeforeOpen() {
        try {
            XFixedText xLabelHead = (XFixedText)UnoRuntime.queryInterface(XFixedText.class, (Object)this.xControlContainer.getControl(LBL_TABLEHEAD));
            String headerValue = "*";
            while (headerValue.length() < 3) {
                headerValue = headerValue + " ";
            }
            headerValue = headerValue + "Name";
            while (headerValue.length() < 26) {
                headerValue = headerValue + " ";
            }
            headerValue = headerValue + "Size";
            while (headerValue.length() < 38) {
                headerValue = headerValue + " ";
            }
            headerValue = headerValue + "Last Modified";
            while (headerValue.length() < 68) {
                headerValue = headerValue + " ";
            }
            headerValue = headerValue + "Comments";
            xLabelHead.setText(headerValue);
        }
        catch (Exception exc) {
            Log.info("Unhandled exception", exc);
        }
        return true;
    }

    protected void disableAll() {
        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.xControlContainer.getControl(LST_ITEMS))).setEnable(false);
        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.xControlContainer.getControl(BTN_CANCEL))).setEnable(false);
        if (this.xControlContainer.getControl(BTN_PREV) != null) {
            ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.xControlContainer.getControl(BTN_PREV))).setEnable(false);
        }
        if (this.xControlContainer.getControl(COMBO_PATH) != null) {
            ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.xControlContainer.getControl(COMBO_PATH))).setEnable(false);
        }
    }

    protected void enableAll() {
        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.xControlContainer.getControl(LST_ITEMS))).setEnable(true);
        if (this.xControlContainer.getControl(COMBO_PATH) != null) {
            ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.xControlContainer.getControl(COMBO_PATH))).setEnable(true);
        }
        if (this.xControlContainer.getControl(BTN_PREV) != null && !"/".equals(this.currentPath)) {
            ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.xControlContainer.getControl(BTN_PREV))).setEnable(true);
        }
        ((XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.xControlContainer.getControl(BTN_CANCEL))).setEnable(true);
    }

    protected boolean isCollection(ResponseDoc response) {
        ResourceTypeProp resourceTypeProperty = (ResourceTypeProp)response.getProperty("resourcetype");
        if (resourceTypeProperty == null) {
            return false;
        }
        return resourceTypeProperty.isCollection();
    }

    protected String formatResponseLine(ResponseDoc response) {
        String fileItem = "";
        VersionNameProp versionNameProperty = (VersionNameProp)response.getProperty("version-name");
        if (versionNameProperty != null && versionNameProperty.getStatus() == 200) {
            fileItem = fileItem + "*";
        }
        while (fileItem.length() < 3) {
            fileItem = fileItem + " ";
        }
        DisplayNameProp displayNameProperty = (DisplayNameProp)response.getProperty("displayname");
        ResourceTypeProp resourceTypeProperty = (ResourceTypeProp)response.getProperty("resourcetype");
        if (resourceTypeProperty != null && resourceTypeProperty.isCollection()) {
            fileItem = fileItem + "> ";
        }
        fileItem = fileItem + displayNameProperty.getDisplayName();
        while (fileItem.length() < 26) {
            fileItem = fileItem + " ";
        }
        ContentLengthProp contentLengthProperty = (ContentLengthProp)response.getProperty("getcontentlength");
        if (contentLengthProperty != null) {
            fileItem = fileItem + contentLengthProperty.getContentLength();
        }
        while (fileItem.length() < 38) {
            fileItem = fileItem + " ";
        }
        LastModifiedProp lastModifiedProperty = (LastModifiedProp)response.getProperty("getlastmodified");
        if (lastModifiedProperty != null) {
            fileItem = fileItem + lastModifiedProperty.getLastModified();
        }
        while (fileItem.length() < 68) {
            fileItem = fileItem + " ";
        }
        CommonProp commentProperty = (CommonProp)response.getProperty("comment");
        if (commentProperty != null) {
            fileItem = fileItem + commentProperty.getValue();
        }
        return fileItem;
    }

    protected void fillItemsList() {
        XListBox xListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)this.xControlContainer.getControl(LST_ITEMS));
        xListBox.removeItems((short)0, xListBox.getItemCount());
        for (int i = this.responses.size() - 1; i >= 0; --i) {
            ResponseDoc response = this.responses.get(i);
            xListBox.addItem(this.formatResponseLine(response), (short)0);
        }
    }

    protected void doPropFind() {
        this.disableAll();
        this.openThread = new OpenThread();
        this.openThread.start();
    }

    protected int getSelectedItemPos() {
        XListBox xListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)this.xControlContainer.getControl(LST_ITEMS));
        return xListBox.getSelectedItemPos();
    }

    protected void doSelectItem() {
        int selectedPos = this.getSelectedItemPos();
        if (selectedPos < 0) {
            return;
        }
        ResponseDoc response = this.responses.get(selectedPos);
        if (!this.isCollection(response)) {
            try {
                this.doOpenRemoteFile(TextUtils.UnEscape((String)response.getHref(), (char)'%'));
                this.xDialog.endExecute();
            }
            catch (Exception exc) {
                Log.info("Can't open remote file... " + exc.getMessage(), exc);
            }
            return;
        }
        this.doPropFindResponse(response);
    }

    protected void doPropFindResponse(ResponseDoc response) {
        String serverPrefix;
        String href = TextUtils.UnEscape((String)response.getHref(), (char)'%');
        if (!href.startsWith(serverPrefix = this.config.getContext().getServerPrefix())) {
            return;
        }
        this.currentPath = href.substring(serverPrefix.length());
        this.doPropFind();
    }

    private class PrevClick
    extends ActionListener {
        private PrevClick() {
        }

        public void actionPerformed(ActionEvent arg0) {
            String serverPrefix;
            XTextComponent xComboText = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)BrowseDialog.this.xControlContainer.getControl(BrowseDialog.COMBO_PATH));
            String currentHref = xComboText.getText();
            if (!currentHref.startsWith(serverPrefix = BrowseDialog.this.config.getContext().getServerPrefix())) {
                return;
            }
            String curPath = currentHref.substring(serverPrefix.length());
            String cuttedPath = curPath.substring(0, curPath.lastIndexOf("/"));
            if (!cuttedPath.startsWith("/")) {
                cuttedPath = "/" + cuttedPath;
            }
            BrowseDialog.this.currentPath = cuttedPath;
            BrowseDialog.this.doPropFind();
        }
    }

    private class ListItemsClick
    extends ActionListener {
        private ListItemsClick() {
        }

        public void actionPerformed(ActionEvent arg0) {
            BrowseDialog.this.doSelectItem();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Comparer
    implements Comparator<ResponseDoc> {
        Comparer() {
        }

        @Override
        public int compare(ResponseDoc resp1, ResponseDoc resp2) {
            ResourceTypeProp rt1 = (ResourceTypeProp)resp1.getProperty("resourcetype");
            ResourceTypeProp rt2 = (ResourceTypeProp)resp2.getProperty("resourcetype");
            if (rt1.isCollection() && !rt2.isCollection()) {
                return 0;
            }
            if (!rt1.isCollection() && rt2.isCollection()) {
                return 1;
            }
            DisplayNameProp dn1 = (DisplayNameProp)resp1.getProperty("displayname");
            DisplayNameProp dn2 = (DisplayNameProp)resp2.getProperty("displayname");
            return dn1.getDisplayName().compareToIgnoreCase(dn2.getDisplayName());
        }
    }

    protected class OpenThread
    extends Thread {
        protected OpenThread() {
        }

        public void run() {
            try {
                DavPropFind davPropFind = new DavPropFind(BrowseDialog.this.config.getContext());
                davPropFind.setResourcePath(BrowseDialog.this.currentPath);
                davPropFind.setRequiredProperty("displayname");
                davPropFind.setRequiredProperty("resourcetype");
                davPropFind.setRequiredProperty("getlastmodified");
                davPropFind.setRequiredProperty("getcontentlength");
                davPropFind.setRequiredProperty("version-name");
                davPropFind.setRequiredProperty("comment");
                int status = davPropFind.execute();
                String serverPrefix = BrowseDialog.this.config.getContext().getServerPrefix();
                String currentHref = serverPrefix + BrowseDialog.this.currentPath;
                if (currentHref.endsWith("/")) {
                    currentHref = currentHref.substring(0, currentHref.length() - 1);
                }
                if (status != 207) {
                    BrowseDialog.this.showMessageBox("Can't open remote directory. ErrorCode: " + status);
                    return;
                }
                Multistatus multistatus = davPropFind.getMultistatus();
                BrowseDialog.this.responses.clear();
                ArrayList tmpResponses = multistatus.getResponses();
                for (int i = 0; i < tmpResponses.size(); ++i) {
                    ResponseDoc response = (ResponseDoc)tmpResponses.get(i);
                    String responseHref = TextUtils.UnEscape((String)response.getHref(), (char)'%');
                    if (i == 0 && responseHref.equals(currentHref)) continue;
                    BrowseDialog.this.responses.add(response);
                }
                Collections.sort(BrowseDialog.this.responses, new Comparer());
                BrowseDialog.this.fillItemsList();
                XComboBox xComboBox = (XComboBox)UnoRuntime.queryInterface(XComboBox.class, (Object)BrowseDialog.this.xControlContainer.getControl(BrowseDialog.COMBO_PATH));
                xComboBox.addItem(currentHref, (short)0);
                XTextComponent xComboText = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)BrowseDialog.this.xControlContainer.getControl(BrowseDialog.COMBO_PATH));
                xComboText.setText(currentHref);
                BrowseDialog.this.enableAll();
            }
            catch (Throwable exc) {
                Log.info("Unhandled exception. " + exc.getMessage(), exc);
            }
        }
    }
}

