/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.davclient.documents;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.exoplatform.frameworks.davclient.documents.DocumentApi;
import org.exoplatform.frameworks.davclient.documents.Multistatus;
import org.exoplatform.frameworks.davclient.documents.PropDoc;
import org.exoplatform.frameworks.davclient.documents.PropFindDoc;
import org.exoplatform.services.log.ExoLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentManager {
    private static Log log = ExoLogger.getLogger((String)"jcr.DocumentManager");
    protected static String[][] availableDocuments = new String[][]{{"propfind", PropFindDoc.class.getCanonicalName()}, {"multistatus", Multistatus.class.getCanonicalName()}, {"prop", PropDoc.class.getCanonicalName()}};

    public static DocumentApi getResponseDocument(InputStream inStream) {
        if (inStream == null) {
            return null;
        }
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(inStream);
            NodeList nodeList = document.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node curDocumentNode = nodeList.item(i);
                String localName = curDocumentNode.getLocalName();
                String nameSpace = curDocumentNode.getNamespaceURI();
                if (localName == null || !"DAV:".equals(nameSpace)) continue;
                for (int docI = 0; docI < availableDocuments.length; ++docI) {
                    if (!localName.equals(availableDocuments[docI][0])) continue;
                    DocumentApi responseDoc = (DocumentApi)Class.forName(availableDocuments[docI][1]).newInstance();
                    responseDoc.initFromDocument(document);
                    return responseDoc;
                }
            }
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()));
            exc.printStackTrace();
        }
        return null;
    }
}

