/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.davclient.documents;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.exoplatform.frameworks.davclient.XmlUtil;
import org.exoplatform.frameworks.davclient.properties.PropApi;
import org.exoplatform.frameworks.davclient.properties.PropManager;
import org.exoplatform.services.log.ExoLogger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseDoc {
    private static Log log = ExoLogger.getLogger((String)"jcr.ResponseDoc");
    protected String href;
    protected ArrayList<PropApi> properties = new ArrayList();

    public ResponseDoc(Node node) {
        Node hrefNode = XmlUtil.getChildNode(node, "href");
        this.href = hrefNode.getTextContent();
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node curNode = nodes.item(i);
            String localName = curNode.getLocalName();
            String nameSpace = curNode.getNamespaceURI();
            if (localName == null || !"propstat".equals(localName) || !"DAV:".equals(nameSpace)) continue;
            ArrayList<PropApi> props = this.getPropertiesForStatus(curNode);
            this.properties.addAll(props);
        }
    }

    protected ArrayList<PropApi> getPropertiesForStatus(Node propStatNode) {
        ArrayList<PropApi> properties = new ArrayList<PropApi>();
        Node propsNode = XmlUtil.getChildNode(propStatNode, "prop");
        NodeList propsNodes = propsNode.getChildNodes();
        Node statusNode = XmlUtil.getChildNode(propStatNode, "status");
        String status = statusNode.getTextContent();
        for (int i = 0; i < propsNodes.getLength(); ++i) {
            Node propertyNode = propsNodes.item(i);
            String localName = propertyNode.getLocalName();
            String nameSpace = propertyNode.getNamespaceURI();
            if (localName == null || !"DAV:".equals(nameSpace)) continue;
            PropApi curProp = PropManager.getPropertyByNode(propertyNode, status);
            properties.add(curProp);
        }
        return properties;
    }

    public String getHref() {
        return this.href;
    }

    public PropApi getProperty(String propertyName) {
        for (int i = 0; i < this.properties.size(); ++i) {
            PropApi curProperty = this.properties.get(i);
            if (!propertyName.equals(curProperty.getName())) continue;
            return curProperty;
        }
        return null;
    }

    public ArrayList<PropApi> getProperties() {
        return this.properties;
    }
}

