/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.davclient.properties;

import org.apache.commons.logging.Log;
import org.exoplatform.frameworks.davclient.properties.CheckedInProp;
import org.exoplatform.frameworks.davclient.properties.CheckedOutProp;
import org.exoplatform.frameworks.davclient.properties.CommonProp;
import org.exoplatform.frameworks.davclient.properties.ContentLengthProp;
import org.exoplatform.frameworks.davclient.properties.ContentTypeProp;
import org.exoplatform.frameworks.davclient.properties.CreatorDisplayNameProp;
import org.exoplatform.frameworks.davclient.properties.DisplayNameProp;
import org.exoplatform.frameworks.davclient.properties.LastModifiedProp;
import org.exoplatform.frameworks.davclient.properties.LockDiscoveryProp;
import org.exoplatform.frameworks.davclient.properties.PropApi;
import org.exoplatform.frameworks.davclient.properties.ResourceTypeProp;
import org.exoplatform.frameworks.davclient.properties.SupportedLockProp;
import org.exoplatform.frameworks.davclient.properties.SupportedMethodSetProp;
import org.exoplatform.frameworks.davclient.properties.SupportedQueryGrammarSetProp;
import org.exoplatform.frameworks.davclient.properties.VersionNameProp;
import org.exoplatform.services.log.ExoLogger;
import org.w3c.dom.Node;

public class PropManager {
    private static Log log = ExoLogger.getLogger((String)"jcr.PropManager");
    protected static String[][] availableProperties = new String[][]{{"displayname", DisplayNameProp.class.getCanonicalName()}, {"lockdiscovery", LockDiscoveryProp.class.getCanonicalName()}, {"resourcetype", ResourceTypeProp.class.getCanonicalName()}, {"getcontenttype", ContentTypeProp.class.getCanonicalName()}, {"getcontentlength", ContentLengthProp.class.getCanonicalName()}, {"getlastmodified", LastModifiedProp.class.getCanonicalName()}, {"checked-in", CheckedInProp.class.getCanonicalName()}, {"checked-out", CheckedOutProp.class.getCanonicalName()}, {"version-name", VersionNameProp.class.getCanonicalName()}, {"creator-displayname", CreatorDisplayNameProp.class.getCanonicalName()}, {"supportedlock", SupportedLockProp.class.getCanonicalName()}, {"supported-query-grammar-set", SupportedQueryGrammarSetProp.class.getCanonicalName()}, {"supported-method-set", SupportedMethodSetProp.class.getCanonicalName()}};

    public static PropApi getPropertyByNode(Node propertyNode, String httpStatus) {
        try {
            String localName = propertyNode.getLocalName();
            PropApi curProp = null;
            for (int i = 0; i < availableProperties.length; ++i) {
                if (!localName.equals(availableProperties[i][0])) continue;
                curProp = (PropApi)Class.forName(availableProperties[i][1]).newInstance();
                break;
            }
            if (curProp == null) {
                curProp = new CommonProp(localName);
            }
            curProp.setStatus(httpStatus);
            curProp.init(propertyNode);
            return curProp;
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()));
            exc.printStackTrace();
            return null;
        }
    }
}

