/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.webdav;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.WebDavCommandContext;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.WebDavServiceImpl;
import org.exoplatform.services.webdav.commands.WebDavCommand;

public class ExoJCRWebdavServlet
extends HttpServlet {
    private static Log log = ExoLogger.getLogger((String)"jcr.ExoJCRWebdavServlet");
    protected ExoContainer container = null;
    protected WebDavServiceImpl davService = null;

    public void init() throws ServletException {
        try {
            this.container = ExoContainerContext.getCurrentContainer();
            this.davService = (WebDavServiceImpl)this.container.getComponentInstanceOfType(WebDavServiceImpl.class);
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()));
            exc.printStackTrace();
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebDavCommand command;
        String commandName = request.getMethod();
        log.info((Object)("DAVCOMMAND - " + commandName));
        if (this.davService == null) {
            String portalName = request.getContextPath().substring(1);
            PortalContainer pcontainer = RootContainer.getInstance().getPortalContainer(portalName);
            this.davService = (WebDavServiceImpl)pcontainer.getComponentInstanceOfType(WebDavServiceImpl.class);
        }
        if ((command = this.davService.getCommand(commandName)) == null) {
            response.setStatus(405);
            log.info((Object)("Command " + commandName + " not supplied."));
            return;
        }
        long timeStart = System.currentTimeMillis();
        try {
            WebDavCommandContext context = new WebDavCommandContext(this.getServletContext(), request, response, (WebDavService)this.davService);
            command.execute((Context)context);
        }
        catch (Exception exc) {
            log.info((Object)("EXECUTE COMMAND EXCEPTION. " + exc.getMessage()));
            exc.printStackTrace();
        }
        try {
            long timeEnd = System.currentTimeMillis();
            long allTime = timeEnd - timeStart;
            long msec = allTime % 1000L;
            long sec = allTime / 1000L;
            long min = sec / 60L;
            log.info((Object)String.format("Command %s completed at MM:SS:MS %d:%d:%d", commandName, min, sec, msec));
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()));
            exc.printStackTrace();
        }
    }
}

