/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.audit;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.Uuid;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.ext.audit.AuditHistory;
import org.exoplatform.services.jcr.ext.audit.AuditRecord;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.log.ExoLogger;

public class AuditServiceImpl
implements AuditService {
    private static Log log = ExoLogger.getLogger((String)"jcr.AuditService");
    private final ManageableRepository repository;
    private final String workspaceName;

    public AuditServiceImpl(InitParams params, RepositoryService repService) throws RepositoryException, RepositoryConfigurationException {
        ValueParam valParam = null;
        if (params != null) {
            valParam = params.getValueParam("repository");
        }
        this.repository = valParam != null ? repService.getRepository(valParam.getValue()) : repService.getRepository();
        this.workspaceName = this.repository.getConfiguration().getSystemWorkspaceName();
    }

    public void addRecord(Item item, int eventType) throws RepositoryException {
        this.checkIfAuditable(item);
        AuditSession auditSession = new AuditSession(item);
        NodeImpl storage = auditSession.getAuditStorage();
        SessionDataManager dm = auditSession.getDataManager();
        SessionImpl session = (SessionImpl)item.getSession();
        NodeData auditHistory = auditSession.getAuditHistoryNodeData();
        InternalQPath path = InternalQPath.makeChildPath((InternalQPath)auditHistory.getQPath(), (InternalQName)AuditService.EXO_AUDITHISTORY_LASTRECORD);
        PropertyData pData = (PropertyData)dm.getItemData(path);
        String auditRecordName = "";
        try {
            auditRecordName = String.valueOf(new Integer(new String(((ValueData)pData.getValues().get(0)).getAsByteArray(), "UTF-8")) + 1);
        }
        catch (Exception e) {
            throw new RepositoryException("Error on add audit record. Problem in calculating new record name. " + e.getLocalizedMessage());
        }
        TransientNodeData arNode = TransientNodeData.createNodeData((NodeData)auditHistory, (InternalQName)new InternalQName(null, auditRecordName), (InternalQName)AuditService.EXO_AUDITRECORD);
        session.getTransientNodesManager().update(new ItemState((ItemData)arNode, 1, true, ((ItemImpl)item).getInternalPath()), true);
        TransientPropertyData arPrType = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)Constants.JCR_PRIMARYTYPE, (int)7, (boolean)false);
        arPrType.setValue((ValueData)new TransientValueData(arNode.getPrimaryTypeName()));
        TransientPropertyData arUser = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)AuditService.EXO_AUDITRECORD_USER, (int)1, (boolean)false);
        arUser.setValue((ValueData)new TransientValueData(session.getUserID()));
        TransientPropertyData arCreated = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)AuditService.EXO_AUDITRECORD_CREATED, (int)5, (boolean)false);
        arCreated.setValue((ValueData)new TransientValueData(dm.getTransactManager().getStorageDataManager().getCurrentTime()));
        TransientPropertyData arEventType = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)AuditService.EXO_AUDITRECORD_EVENTTYPE, (int)3, (boolean)false);
        arEventType.setValue((ValueData)new TransientValueData((long)eventType));
        session.getTransientNodesManager().update(new ItemState((ItemData)arPrType, 1, true, ((ItemImpl)item).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)arUser, 1, true, ((ItemImpl)item).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)arCreated, 1, true, ((ItemImpl)item).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)arEventType, 1, true, ((ItemImpl)item).getInternalPath()), true);
        if (!item.isNode()) {
            TransientPropertyData propertyNameData = TransientPropertyData.createPropertyData((NodeData)arNode, (InternalQName)EXO_AUDITRECORD_PROPERTYNAME, (int)1, (boolean)false);
            propertyNameData.setValue((ValueData)new TransientValueData(((ItemImpl)item).getInternalName()));
            session.getTransientNodesManager().update(new ItemState((ItemData)propertyNameData, 1, true, ((ItemImpl)item).getInternalPath()), true);
        }
        TransientPropertyData pLastRecord = (TransientPropertyData)auditSession.getDataManager().getItemData(InternalQPath.makeChildPath((InternalQPath)auditHistory.getQPath(), (InternalQName)EXO_AUDITHISTORY_LASTRECORD));
        pLastRecord.setValue((ValueData)new TransientValueData(String.valueOf(auditRecordName)));
        session.getTransientNodesManager().update(new ItemState((ItemData)pLastRecord, 2, true, ((ItemImpl)item).getInternalPath()), true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add audit record:  Item path=" + ((ItemImpl)item).getLocation().getInternalPath().getAsString() + " User=" + session.getUserID() + " EventType=" + eventType));
        }
    }

    public void createHistory(Node node) throws RepositoryException {
        this.checkIfAuditable((Item)node);
        AuditSession auditSession = new AuditSession((Item)node);
        NodeImpl storage = auditSession.getAuditStorage();
        SessionImpl session = (SessionImpl)node.getSession();
        InternalQName aiName = new InternalQName(null, ((ItemImpl)node).getData().getUUID());
        TransientNodeData ahNode = TransientNodeData.createNodeData((NodeData)((NodeData)storage.getData()), (InternalQName)aiName, (InternalQName)AuditService.EXO_AUDITHISTORY);
        TransientPropertyData aPrType = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)Constants.JCR_PRIMARYTYPE, (int)7, (boolean)false);
        aPrType.setValue((ValueData)new TransientValueData(ahNode.getPrimaryTypeName()));
        TransientPropertyData ahUuid = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)Constants.JCR_UUID, (int)1, (boolean)false);
        ahUuid.setValue((ValueData)new TransientValueData(ahNode.getUUID()));
        TransientPropertyData ahMixinTypes = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)Constants.JCR_MIXINTYPES, (int)7, (boolean)false);
        ahMixinTypes.setValue((ValueData)new TransientValueData(Constants.MIX_REFERENCEABLE));
        TransientPropertyData ahTargetNode = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)AuditService.EXO_AUDITHISTORY_TARGETNODE, (int)9, (boolean)false);
        ahTargetNode.setValue((ValueData)new TransientValueData(((ItemImpl)node).getData().getUUID()));
        TransientPropertyData ahLastRecord = TransientPropertyData.createPropertyData((NodeData)ahNode, (InternalQName)AuditService.EXO_AUDITHISTORY_LASTRECORD, (int)1, (boolean)false);
        ahLastRecord.setValue((ValueData)new TransientValueData("0"));
        TransientPropertyData pAuditHistory = TransientPropertyData.createPropertyData((NodeData)((NodeData)((ItemImpl)node).getData()), (InternalQName)AuditService.EXO_AUDITHISTORY, (int)1, (boolean)false);
        pAuditHistory.setValue((ValueData)new TransientValueData(new Uuid(ahNode.getUUID())));
        session.getTransientNodesManager().update(new ItemState((ItemData)ahNode, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)aPrType, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)ahUuid, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)ahMixinTypes, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)ahTargetNode, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)ahLastRecord, 1, true, ((ItemImpl)node).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState((ItemData)pAuditHistory, 1, true, ((ItemImpl)node).getInternalPath()), true);
    }

    public AuditHistory getHistory(Node node) throws RepositoryException, UnsupportedOperationException {
        AuditSession auditSession = new AuditSession((Item)node);
        SessionDataManager dm = auditSession.getDataManager();
        NodeData storage = auditSession.getAuditHistoryNodeData();
        ArrayList<AuditRecord> auditRecords = new ArrayList<AuditRecord>();
        ValueFactoryImpl vf = (ValueFactoryImpl)node.getSession().getValueFactory();
        List auditRecordsNodeData = dm.getChildNodesData(storage);
        for (NodeData nodeData : auditRecordsNodeData) {
            List auditRecordNodeData = dm.getChildPropertiesData(nodeData);
            String user = null;
            InternalQName propertyName = null;
            int eventType = -1;
            Calendar date = null;
            for (PropertyData propertyData : auditRecordNodeData) {
                if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_USER)) {
                    user = vf.loadValue((TransientValueData)propertyData.getValues().get(0), 1).getString();
                    continue;
                }
                if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_EVENTTYPE)) {
                    eventType = (int)vf.loadValue((TransientValueData)propertyData.getValues().get(0), 3).getLong();
                    continue;
                }
                if (propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_CREATED)) {
                    date = vf.loadValue((TransientValueData)propertyData.getValues().get(0), 5).getDate();
                    continue;
                }
                if (!propertyData.getQPath().getName().equals((Object)AuditService.EXO_AUDITRECORD_PROPERTYNAME)) continue;
                try {
                    propertyName = InternalQName.parse((String)new String(((ValueData)propertyData.getValues().get(0)).getAsByteArray()));
                }
                catch (Exception e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            auditRecords.add(new AuditRecord(user, eventType, date, propertyName));
        }
        return new AuditHistory(node, auditRecords);
    }

    public void removeHistory(Node node) throws RepositoryException {
        AuditSession auditSession = new AuditSession((Item)node);
        NodeData storage = auditSession.getAuditHistoryNodeData();
        SessionImpl session = (SessionImpl)node.getSession();
        session.getTransientNodesManager().delete((ItemData)storage);
    }

    public boolean hasHistory(Node node) {
        NodeData data;
        try {
            AuditSession auditSession = new AuditSession((Item)node);
            data = auditSession.getAuditHistoryNodeData();
        }
        catch (RepositoryException e) {
            return false;
        }
        return data != null;
    }

    private void checkIfAuditable(Item item) throws RepositoryException, UnsupportedOperationException {
        NodeImpl node;
        NodeImpl nodeImpl = node = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
        if (!node.isNodeType("exo:auditable")) {
            throw new ConstraintViolationException("exo:auditable node expected at: " + node.getPath());
        }
    }

    private class AuditSession {
        private SessionImpl session;
        private SessionDataManager dm;
        private ExtendedNode node;

        private AuditSession(Item item) throws RepositoryException {
            this.session = (SessionImpl)item.getSession();
            this.node = item.isNode() ? (ExtendedNode)item : (ExtendedNode)item.getParent();
            if (!this.node.isNodeType(AuditService.EXO_AUDITABLE)) {
                throw new RepositoryException("Node is not exo:auditable " + this.node.getPath());
            }
            this.dm = this.session.getTransientNodesManager();
        }

        private NodeImpl getAuditStorage() throws RepositoryException {
            NodeImpl storage;
            try {
                storage = (NodeImpl)this.session.getNodeByUUID("00exo0jcr0audit0storage0id000000");
            }
            catch (ItemNotFoundException e) {
                SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
                TransientNodeData exoAuditNode = TransientNodeData.createNodeData((NodeData)((NodeData)((NodeImpl)this.session.getRootNode()).getData()), (InternalQName)AuditService.EXO_AUDIT, (InternalQName)AuditService.EXO_AUDITSTORAGE, (String)"00exo0jcr0audit0storage0id000000");
                TransientPropertyData exoAuditPrType = TransientPropertyData.createPropertyData((NodeData)exoAuditNode, (InternalQName)Constants.JCR_PRIMARYTYPE, (int)7, (boolean)false);
                exoAuditPrType.setValue((ValueData)new TransientValueData(exoAuditNode.getPrimaryTypeName()));
                TransientPropertyData exoAuditUuid = TransientPropertyData.createPropertyData((NodeData)exoAuditNode, (InternalQName)Constants.JCR_UUID, (int)1, (boolean)false);
                exoAuditUuid.setValue((ValueData)new TransientValueData(exoAuditNode.getUUID()));
                TransientPropertyData exoAuditMixinTypes = TransientPropertyData.createPropertyData((NodeData)exoAuditNode, (InternalQName)Constants.JCR_MIXINTYPES, (int)7, (boolean)true);
                exoAuditMixinTypes.setValue((ValueData)new TransientValueData(Constants.MIX_REFERENCEABLE));
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditNode));
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditPrType));
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditUuid));
                changesLog.add(ItemState.createAddedState((ItemData)exoAuditMixinTypes));
                this.session.getTransientNodesManager().getTransactManager().save((ItemDataChangesLog)changesLog);
                storage = (NodeImpl)this.session.getNodeByUUID("00exo0jcr0audit0storage0id000000");
            }
            return storage;
        }

        private SessionDataManager getDataManager() {
            return this.dm;
        }

        private NodeData getAuditHistoryNodeData() throws RepositoryException {
            String ahUuid;
            InternalQPath path = null;
            path = InternalQPath.makeChildPath((InternalQPath)((NodeImpl)this.node).getData().getQPath(), (InternalQName)AuditService.EXO_AUDITHISTORY);
            PropertyData pData = (PropertyData)this.dm.getItemData(path);
            try {
                ahUuid = new String(((ValueData)pData.getValues().get(0)).getAsByteArray(), "UTF-8");
            }
            catch (Exception e) {
                throw new RepositoryException("Error getAuditHistory converting to string");
            }
            return (NodeData)this.dm.getItemData(ahUuid);
        }
    }
}

