/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDataChangesLog
implements Externalizable {
    protected List<ItemState> items;
    protected String sessionId;
    protected String systemId;

    public ItemDataChangesLog(List<ItemState> items, String sessionId) {
        this.items = items;
        this.sessionId = sessionId;
    }

    public ItemDataChangesLog(ItemState change, String sessionId) {
        this(new ArrayList<ItemState>(), sessionId);
        this.items.add(change);
    }

    public List<ItemState> getAllStates() {
        return this.items;
    }

    public int getSize() {
        return this.items.size();
    }

    public ItemState getItemState(String itemUuid) {
        List<ItemState> allStates = this.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState state = allStates.get(i);
            if (state.isOrderable() || !state.getData().getUUID().equals(itemUuid)) continue;
            return state;
        }
        return null;
    }

    public ItemState getItemState(InternalQPath itemPath) {
        List<ItemState> allStates = this.getAllStates();
        for (int i = allStates.size() - 1; i >= 0; --i) {
            ItemState state = allStates.get(i);
            if (state.isOrderable() || !state.getData().getQPath().equals(itemPath)) continue;
            return state;
        }
        return null;
    }

    public List<ItemState> getItemStates(String itemUuid) {
        ArrayList<ItemState> states = new ArrayList<ItemState>();
        for (ItemState state : this.getAllStates()) {
            if (!state.getData().getUUID().equals(itemUuid)) continue;
            states.add(state);
        }
        return states;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String dump() {
        String str = "ChangesLog: \n";
        for (int i = 0; i < this.items.size(); ++i) {
            str = str + " " + this.items.get(i).getData().getQPath().getAsString() + " " + this.items.get(i).getData().getUUID() + " " + ItemState.nameFromValue(this.items.get(i).getState()) + " \n";
        }
        return str;
    }

    public ItemDataChangesLog() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.systemId.getBytes().length);
        out.write(this.systemId.getBytes());
        out.writeInt(this.sessionId.getBytes().length);
        out.write(this.sessionId.getBytes());
        int listSize = this.items.size();
        out.writeInt(listSize);
        for (int i = 0; i < listSize; ++i) {
            out.writeObject(this.items.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String DEFAULT_ENCODING = "UTF-8";
        byte[] buf = new byte[in.readInt()];
        in.read(buf);
        this.systemId = new String(buf, DEFAULT_ENCODING);
        buf = new byte[in.readInt()];
        in.read(buf);
        this.sessionId = new String(buf, DEFAULT_ENCODING);
        this.items = new ArrayList<ItemState>();
        int listSize = in.readInt();
        for (int i = 0; i < listSize; ++i) {
            this.items.add((ItemState)in.readObject());
        }
    }
}

