/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.datamodel;

import java.util.ArrayList;
import javax.jcr.PathNotFoundException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.log.ExoLogger;

public class InternalQPath
implements Comparable {
    protected static Log log = ExoLogger.getLogger((String)"jcr.SessionDataManager");
    public static final String PREFIX_DELIMITER = ":";
    private final Entry[] names;
    private final int hashCode;
    private String stringName;

    public InternalQPath(Entry[] names) {
        this.names = names;
        int prime = 31;
        int hash = 1;
        for (Entry entry : names) {
            hash = 31 * hash + entry.hashCode();
            hash = 31 * hash + entry.getIndex();
        }
        this.hashCode = hash;
    }

    public InternalQPath makeParentPath() throws IllegalPathException {
        return this.makeAncestorPath(1);
    }

    public InternalQPath makeAncestorPath(int relativeDegree) throws IllegalPathException {
        if (relativeDegree > this.getLength() || this.getLength() <= 1) {
            throw new IllegalPathException("Relative degree " + relativeDegree + " is more than depth for " + this.getAsString());
        }
        int entryCount = this.getLength() - relativeDegree;
        Entry[] ancestorEntries = new Entry[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            ancestorEntries[i] = new Entry(this.names[i].getNamespace(), this.names[i].getName(), this.names[i].getIndex());
        }
        return new InternalQPath(ancestorEntries);
    }

    public Entry[] getRelPath(int relativeDegree) throws IllegalPathException {
        if (relativeDegree > this.getLength() || this.getLength() <= 1) {
            throw new IllegalPathException("Relative degree " + relativeDegree + " is more than depth for " + this.getAsString());
        }
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (int i = this.names.length - relativeDegree; i < this.names.length; ++i) {
            entries.add(this.names[i]);
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    public Entry[] getEntries() {
        return this.names;
    }

    public int getDepth() {
        return this.getLength() - 1;
    }

    public boolean isDescendantOf(InternalQPath anotherPath, boolean childOnly) {
        int depthDiff = this.getDepth() - anotherPath.getDepth();
        if (depthDiff <= 0 || childOnly && depthDiff != 1) {
            return false;
        }
        Entry[] anotherNames = anotherPath.getEntries();
        for (int i = 0; i < anotherNames.length; ++i) {
            boolean result = anotherNames[i].equals((Object)this.names[i]);
            if (result) continue;
            return false;
        }
        return true;
    }

    public static InternalQPath getPrimogenitorPath(InternalQPath firstPath, InternalQPath secondPath) throws PathNotFoundException {
        if (!firstPath.getEntries()[0].equals((Object)secondPath.getEntries()[0])) {
            throw new PathNotFoundException("For the given ways there is no general primogenitor.");
        }
        ArrayList<Entry> primoEntries = new ArrayList<Entry>();
        for (int i = 0; i < firstPath.getEntries().length && firstPath.getEntries()[i].equals((Object)secondPath.getEntries()[i]); ++i) {
            primoEntries.add(firstPath.getEntries()[i]);
        }
        return new InternalQPath(primoEntries.toArray(new Entry[primoEntries.size()]));
    }

    public InternalQName getName() {
        return this.names[this.getLength() - 1];
    }

    public int getIndex() {
        return this.names[this.getLength() - 1].getIndex();
    }

    public int getLength() {
        return this.names.length;
    }

    public String getAsString() {
        if (this.stringName == null) {
            String str = "";
            for (int i = 0; i < this.getLength(); ++i) {
                str = str + this.names[i].getAsString() + PREFIX_DELIMITER + this.names[i].getIndex();
            }
            this.stringName = str.intern();
        }
        return this.stringName;
    }

    public String toString() {
        return super.toString() + " (" + this.getAsString() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InternalQPath)) {
            return false;
        }
        return this.hashCode == o.hashCode();
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof InternalQPath) {
            String anotherString;
            InternalQPath anotherPath = (InternalQPath)o;
            String myString = this.getAsString();
            if (myString == (anotherString = anotherPath.getAsString())) {
                return 0;
            }
            return myString.compareTo(anotherString);
        }
        return 0;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static InternalQPath parse(String qPath) throws IllegalPathException {
        if (qPath == null) {
            throw new IllegalPathException("Bad internal path '" + qPath + "'");
        }
        if (qPath.length() < 2 || !qPath.startsWith("[]")) {
            throw new IllegalPathException("Bad internal path '" + qPath + "'");
        }
        int uriStart = 0;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        while (uriStart >= 0) {
            uriStart = qPath.indexOf("[", uriStart);
            int uriFinish = qPath.indexOf("]", uriStart);
            String uri = qPath.substring(uriStart + 1, uriFinish);
            int tmp = qPath.indexOf("[", uriFinish);
            if (tmp == -1) {
                tmp = qPath.length();
                uriStart = -1;
            } else {
                uriStart = tmp;
            }
            String localName = qPath.substring(uriFinish + 1, tmp);
            int index = 0;
            int ind = localName.indexOf(PREFIX_DELIMITER);
            if (ind != -1) {
                index = Integer.parseInt(localName.substring(ind + 1));
                localName = localName.substring(0, ind);
            } else if (uriStart > -1) {
                throw new IllegalPathException("Bad internal path '" + qPath + "' each intermediate name should have index");
            }
            entries.add(new Entry(uri, localName, index));
        }
        return new InternalQPath(entries.toArray(new Entry[entries.size()]));
    }

    @Deprecated
    public static InternalQPath makeChildPath(InternalQPath parent, String name) throws IllegalPathException {
        Entry[] parentEntries = parent.getEntries();
        Entry[] names = new Entry[parentEntries.length + 1];
        int index = 0;
        for (Entry pname : parentEntries) {
            names[index++] = pname;
        }
        names[index] = InternalQPath.parseEntry(name);
        InternalQPath path = new InternalQPath(names);
        return path;
    }

    public static InternalQPath makeChildPath(InternalQPath parent, InternalQName name) {
        return InternalQPath.makeChildPath(parent, name, 1);
    }

    public static InternalQPath makeChildPath(InternalQPath parent, InternalQName name, int itemIndex) {
        Entry[] parentEntries = parent.getEntries();
        Entry[] names = new Entry[parentEntries.length + 1];
        int index = 0;
        for (Entry pname : parentEntries) {
            names[index++] = pname;
        }
        names[index] = new Entry(name.getNamespace(), name.getName(), itemIndex);
        InternalQPath path = new InternalQPath(names);
        return path;
    }

    public static InternalQPath makeChildPath(InternalQPath parent, Entry[] relEntries) {
        Entry[] parentEntries = parent.getEntries();
        Entry[] names = new Entry[parentEntries.length + relEntries.length];
        int index = 0;
        for (Entry name : parentEntries) {
            names[index++] = name;
        }
        for (Entry name : relEntries) {
            names[index++] = name;
        }
        InternalQPath path = new InternalQPath(names);
        return path;
    }

    private static Entry parseEntry(String entry) throws IllegalPathException {
        if (!entry.startsWith("[")) {
            throw new IllegalPathException("Invalid QPath Entry '" + entry + "' Should start of '['");
        }
        boolean uriStart = false;
        int uriFinish = entry.indexOf("]", 0);
        if (uriFinish == -1) {
            throw new IllegalPathException("Invalid QPath Entry '" + entry + "' No closed ']'");
        }
        String uri = entry.substring(1, uriFinish);
        String localName = entry.substring(uriFinish + 1, entry.length());
        int ind = localName.indexOf(PREFIX_DELIMITER);
        if (ind > 1) {
            return new Entry(uri, localName.substring(0, ind), Integer.parseInt(localName.substring(ind + 1)));
        }
        return new Entry(uri, localName, 1);
    }

    public static class Entry
    extends InternalQName {
        private final int index;

        public Entry(String namespace, String name, int index) {
            super(namespace, name);
            this.index = index > 0 ? index : 1;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

