/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.storage.swap;

import java.io.File;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.config.BinarySwapEntry;
import org.exoplatform.services.jcr.util.StringNumberParser;
import org.exoplatform.services.jcr.util.UUIDGenerator;
import org.exoplatform.services.log.ExoLogger;

public class BinaryValueSwapStorage {
    private static Log log = ExoLogger.getLogger((String)"jcr.BinaryValueSwapStorage");
    private File rootDir = null;
    private int minFileSize = -1;
    private boolean copyLocalFiles = false;

    public BinaryValueSwapStorage(String rootDirPath, String minFileSizeText, String copyLocalFilesText) {
        if (rootDirPath == null || minFileSizeText == null) {
            throw new IllegalArgumentException("BinaryValueSwapStorage configuration error - null parameters can't be used. rootDirPath: " + rootDirPath + ", minFileSizeText: " + minFileSizeText);
        }
        this.rootDir = new File(rootDirPath);
        if (this.rootDir.exists()) {
            File[] files = this.rootDir.listFiles();
            if (files != null) {
                for (File f : files) {
                    try {
                        f.delete();
                    }
                    catch (Throwable th) {
                        log.warn((Object)("Can't delete swap file: " + (f != null ? f.getAbsolutePath() : "[null]")), th);
                    }
                }
            }
            this.rootDir.delete();
        }
        this.rootDir.mkdirs();
        try {
            this.minFileSize = StringNumberParser.parseNumber(minFileSizeText).intValue();
        }
        catch (Throwable th) {
            log.warn((Object)("Can't parse minimal swap file size: " + minFileSizeText + ". Will use " + 0x200000 + " bytes threshold."), th);
            this.minFileSize = 0x200000;
        }
        this.copyLocalFiles = Boolean.parseBoolean(copyLocalFilesText);
    }

    public BinaryValueSwapStorage(BinarySwapEntry bsConfig) {
        this(bsConfig.getDirectoryPath(), bsConfig.getMinFileSize(), bsConfig.getCopyLocalFiles());
    }

    public String generatePath() {
        if (!this.rootDir.exists()) {
            this.rootDir.mkdirs();
        }
        return this.rootDir.getAbsoluteFile() + File.separator + UUIDGenerator.generate();
    }

    public int getMinFileSize() {
        return this.minFileSize;
    }

    public boolean isCopyLocalFiles() {
        return this.copyLocalFiles;
    }
}

