/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.util.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.exoplatform.services.jcr.util.io.BytesArray;
import org.exoplatform.services.jcr.util.io.CloneableInputStream;

public class LazyByteArrayInputStream
extends CloneableInputStream
implements BytesArray {
    protected final byte[] buff;
    protected ByteArrayInputStream dataStream;

    public LazyByteArrayInputStream(byte[] buff) {
        this.buff = buff;
    }

    public LazyByteArrayInputStream clone() {
        return new LazyByteArrayInputStream(this.buff);
    }

    public void close() throws IOException {
        if (this.dataStream != null) {
            super.close();
        }
    }

    protected InputStream stream() throws IllegalStateException, IOException {
        if (this.dataStream == null) {
            this.dataStream = new ByteArrayInputStream(this.buff);
        }
        return this.dataStream;
    }

    public byte[] getBytes() {
        return this.buff;
    }

    public long size() {
        return this.buff.length;
    }
}

