/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.RepositoryServiceConfiguration;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.impl.AddNamespacesPlugin;
import org.exoplatform.services.jcr.impl.AddNodeTypePlugin;
import org.exoplatform.services.jcr.impl.RepositoryContainer;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;

public class RepositoryServiceImpl
implements RepositoryService,
Startable {
    protected static Log log = ExoLogger.getLogger((String)"jcr.RepositoryService");
    private RepositoryServiceConfiguration config;
    private HashMap repositoryContainers = new HashMap();
    private List addNodeTypePlugins;
    private List addNamespacesPlugins;
    private ExoContainerContext containerContext;

    public RepositoryServiceImpl(RepositoryServiceConfiguration configuration) throws RepositoryConfigurationException, RepositoryException {
        this.config = configuration;
        this.addNodeTypePlugins = new ArrayList();
    }

    public RepositoryServiceImpl(RepositoryServiceConfiguration configuration, ExoContainerContext context) throws RepositoryConfigurationException, RepositoryException {
        this.config = configuration;
        this.addNodeTypePlugins = new ArrayList();
        this.addNamespacesPlugins = new ArrayList();
        this.containerContext = context;
    }

    public ManageableRepository getRepository() throws RepositoryException {
        return this.getRepository(this.config.getDefaultRepositoryName());
    }

    public ManageableRepository getRepository(String name) throws RepositoryException {
        RepositoryContainer repositoryContainer = (RepositoryContainer)((Object)this.repositoryContainers.get(name));
        log.debug((Object)("RepositoryServiceimpl() getRepository " + name));
        if (repositoryContainer == null) {
            throw new RepositoryException("Repository '" + name + "' not found.");
        }
        return (ManageableRepository)repositoryContainer.getComponentInstanceOfType(Repository.class);
    }

    public RepositoryServiceConfiguration getConfig() {
        return this.config;
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof AddNodeTypePlugin) {
            this.addNodeTypePlugins.add(plugin);
        } else if (plugin instanceof AddNamespacesPlugin) {
            this.addNamespacesPlugins.add(plugin);
        }
    }

    public ComponentPlugin removePlugin(String name) {
        return null;
    }

    public Collection getPlugins() {
        return null;
    }

    public void start() {
        try {
            Object container = null;
            container = this.containerContext == null ? PortalContainer.getInstance() : this.containerContext.getContainer();
            this.init((ExoContainer)container);
            this.addNamespaces((ExoContainer)container);
            this.addNodeTypes((ExoContainer)container);
        }
        catch (Exception e) {
            log.error((Object)"Error start repository service", (Throwable)e);
        }
    }

    public void stop() {
    }

    private void init(ExoContainer parentContainer) throws RepositoryConfigurationException, RepositoryException {
        List rEntries = this.config.getRepositoryConfigurations();
        for (int i = 0; i < rEntries.size(); ++i) {
            RepositoryEntry rEntry = (RepositoryEntry)rEntries.get(i);
            RepositoryContainer repositoryContainer = new RepositoryContainer(parentContainer, rEntry);
            this.repositoryContainers.put(rEntry.getName(), repositoryContainer);
            repositoryContainer.start();
        }
    }

    private void addNodeTypes(ExoContainer container) throws Exception {
        ConfigurationManager configService = (ConfigurationManager)container.getComponentInstanceOfType(ConfigurationManager.class);
        ManageableRepository repository = this.getRepository();
        ExtendedNodeTypeManager ntManager = repository.getNodeTypeManager();
        for (int j = 0; j < this.addNodeTypePlugins.size(); ++j) {
            AddNodeTypePlugin plugin = (AddNodeTypePlugin)((Object)this.addNodeTypePlugins.get(j));
            List nodeTypesFiles = plugin.getNodeTypesFiles();
            String nodeTypeFilesName2 = null;
            try {
                if (nodeTypesFiles != null && nodeTypesFiles.size() > 0) {
                    for (String nodeTypeFilesName2 : nodeTypesFiles) {
                        InputStream inXml = configService.getInputStream(nodeTypeFilesName2);
                        ntManager.registerNodeTypes(inXml, 0);
                    }
                    continue;
                }
                log.warn((Object)"Empty nodeTypesFiles param found, trying node types from list stored in plugin config");
            }
            catch (Exception e) {
                log.error((Object)("Error load node types from resource: " + nodeTypeFilesName2 + ", trying node types from list stored in plugin config"), (Throwable)e);
            }
            List nodeTypes = plugin.getNodeTypes();
            if (nodeTypes == null || nodeTypes.size() <= 0) continue;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            for (String nodeTypeClassName : nodeTypes) {
                Class<?> nodeTypeClass = Class.forName(nodeTypeClassName, true, cl);
                ntManager.registerNodeType(nodeTypeClass, 0);
                log.info((Object)("Node is registered from class " + nodeTypeClassName));
            }
        }
    }

    private void addNamespaces(ExoContainer container) throws Exception {
        ManageableRepository repository = this.getRepository();
        NamespaceRegistry nsRegistry = repository.getNamespaceRegistry();
        for (int j = 0; j < this.addNamespacesPlugins.size(); ++j) {
            AddNamespacesPlugin plugin = (AddNamespacesPlugin)((Object)this.addNamespacesPlugins.get(j));
            Map namespaces = plugin.getNamespaces();
            try {
                for (Map.Entry namespace : namespaces.entrySet()) {
                    String prefix = (String)namespace.getKey();
                    String uri = (String)namespace.getValue();
                    try {
                        nsRegistry.getURI(prefix);
                    }
                    catch (NamespaceException e) {
                        nsRegistry.registerNamespace(prefix, uri);
                    }
                    log.info((Object)("Namespace is registered " + prefix + " = " + uri));
                }
                continue;
            }
            catch (Exception e) {
                log.error((Object)"Error load namespaces ", (Throwable)e);
            }
        }
    }
}

