/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.core.value.ExtendedValue;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.Uuid;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.core.value.PathValue;
import org.exoplatform.services.jcr.impl.core.value.PermissionValue;
import org.exoplatform.services.jcr.impl.core.value.ValueConstraintsMatcher;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.util.UUIDGenerator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemImpl
implements Item {
    private static Log log = ExoLogger.getLogger((String)"jcr.ItemImpl");
    protected final SessionImpl session;
    protected ItemData data;
    protected JCRPath location;
    protected SessionDataManager dataManager;
    protected LocationFactory locationFactory;
    protected ValueFactoryImpl valueFactory;
    protected int itemHashCode = 0;

    ItemImpl(ItemData data, SessionImpl session) throws RepositoryException {
        this.session = session;
        this.data = data;
        this.location = session.getLocationFactory().createJCRPath(data.getQPath());
        this.dataManager = session.getTransientNodesManager();
        this.locationFactory = session.getLocationFactory();
        this.valueFactory = session.getValueFactory();
        this.itemHashCode = (session.getWorkspace().getName() + data.getUUID()).hashCode();
    }

    protected void invalidate() {
        this.data = null;
    }

    public boolean isValid() {
        return this.data != null;
    }

    protected boolean checkValid() throws InvalidItemStateException {
        if (this.data == null) {
            throw new InvalidItemStateException("Invalid item state. Item was removed.");
        }
        return true;
    }

    public String getPath() {
        return this.getLocation().getAsString(false);
    }

    public String getName() {
        return this.getLocation().getName().getAsString();
    }

    public Item getAncestor(int degree) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        try {
            if (degree < 0) {
                throw new ItemNotFoundException("Can't get ancestor with ancestor's degree < 0.");
            }
            InternalQPath myPath = this.getData().getQPath();
            int n = myPath.getDepth() - degree;
            if (n == 0) {
                return this;
            }
            if (n < 0) {
                throw new ItemNotFoundException("Can't get ancestor with ancestor's degree > depth of this item.");
            }
            InternalQPath ancestorPath = myPath.makeAncestorPath(n);
            return this.item(ancestorPath);
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException(e.getMessage(), (Throwable)e);
        }
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        this.checkValid();
        if (this.isRoot()) {
            throw new ItemNotFoundException("Root node does not have a parent");
        }
        return this.parent();
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public int getDepth() {
        return this.getLocation().getDepth();
    }

    public boolean isSame(Item otherItem) {
        if (this.isValid()) {
            if (otherItem == null) {
                return false;
            }
            if (!this.getClass().equals(otherItem.getClass())) {
                return false;
            }
            try {
                return this.getInternalUUID().equals(((ItemImpl)otherItem).getInternalUUID());
            }
            catch (Exception e) {
                log.debug((Object)("Item.isSame() failed " + e));
                return false;
            }
        }
        return false;
    }

    public boolean isNew() {
        if (this.isValid()) {
            return this.dataManager.isNew(this.getInternalUUID());
        }
        return false;
    }

    public boolean isModified() {
        if (this.isValid()) {
            return this.dataManager.isModified(this.getData());
        }
        return true;
    }

    public void remove() throws RepositoryException, ConstraintViolationException, VersionException, LockException {
        this.checkValid();
        if (this.isRoot()) {
            throw new RepositoryException("Can't remove ROOT node.");
        }
        Object def = this.isNode() ? ((NodeImpl)this).getDefinition() : ((PropertyImpl)this).getDefinition();
        if (def.isMandatory() || def.isProtected()) {
            throw new ConstraintViolationException("Can't remove mandatory or protected item " + this.getPath());
        }
        NodeImpl parentNode = this.parent();
        if (!parentNode.isCheckedOut()) {
            throw new VersionException("Node " + this.parent().getPath() + " or its nearest ancestor is checked-in");
        }
        if (!parentNode.checkLocking()) {
            throw new LockException("Node " + this.parent().getPath() + " is locked ");
        }
        this.session.getActionHandler().preRemoveItem(parentNode, this);
        this.dataManager.delete(this.data);
    }

    protected PropertyImpl doUpdateProperty(NodeImpl parentNode, InternalQName propertyName, Value propertyValue, boolean multiValue, int expectedType) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] val = null;
        if (propertyValue != null) {
            val = new Value[]{propertyValue};
        }
        return this.doUpdateProperty(parentNode, propertyName, val, multiValue, expectedType);
    }

    protected PropertyImpl doUpdateProperty(NodeImpl parentNode, InternalQName propertyName, Value[] propertyValues, boolean multiValue, int expectedType) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        int requiredType;
        int state;
        int version;
        String uuid;
        InternalQPath qpath = InternalQPath.makeChildPath((InternalQPath)parentNode.getInternalPath(), (InternalQName)propertyName);
        PropertyImpl oldProp = null;
        ItemImpl oldItem = this.dataManager.getItem(qpath, true);
        PropertyDefinition def = null;
        NodeTypeManagerImpl ntm = this.session.getWorkspace().getNodeTypeManager();
        NodeData parentData = (NodeData)parentNode.getData();
        if (oldItem == null || oldItem.isNode()) {
            uuid = UUIDGenerator.generate();
            version = -1;
            if (propertyValues == null) {
                TransientPropertyData nullData = new TransientPropertyData(qpath, uuid, version, 0, parentNode.getInternalUUID(), multiValue);
                PropertyImpl nullProperty = new PropertyImpl((ItemData)nullData, this.session);
                nullProperty.invalidate();
                return nullProperty;
            }
            def = ntm.findPropertyDefinitions(propertyName, parentData.getPrimaryTypeName(), parentData.getMixinTypeNames()).getDefinition(multiValue);
            state = 1;
        } else {
            oldProp = (PropertyImpl)oldItem;
            def = ntm.findPropertyDefinitions(propertyName, parentData.getPrimaryTypeName(), parentData.getMixinTypeNames()).getDefinition(oldProp.isMultiValued());
            uuid = oldProp.getInternalUUID();
            version = oldProp.getData().getPersistedVersion();
            state = propertyValues == null ? 3 : 2;
        }
        if (def != null && def.isProtected()) {
            throw new ConstraintViolationException("Can not set protected property " + this.getPath());
        }
        if (multiValue && (def == null || oldProp != null && !oldProp.isMultiValued())) {
            throw new ValueFormatException("Can not assign multiple-values Value to a single-valued property " + this.getPath());
        }
        if (!multiValue && (def == null || oldProp != null && oldProp.isMultiValued())) {
            throw new ValueFormatException("Can not assign single-value Value to a multiple-valued property " + this.getPath());
        }
        if (!parentNode.isCheckedOut()) {
            throw new VersionException("Node " + parentNode.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!parentNode.checkLocking()) {
            throw new LockException("Node " + parentNode.getPath() + " is locked ");
        }
        ArrayList<ValueData> valueDataList = new ArrayList<ValueData>();
        int propType = requiredType = def.getRequiredType();
        if (propertyValues != null) {
            if (propertyValues.length > 1 && propertyValues[0] != null) {
                int vType = propertyValues[0].getType();
                for (Value val : propertyValues) {
                    if (val == null || vType == val.getType()) continue;
                    throw new ValueFormatException("All Value objects in the array must be of the same type");
                }
            }
            if (propertyValues.length > 0 && requiredType == 0) {
                if (expectedType == 0) {
                    Value[] arr$ = propertyValues;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        Value val = arr$[i$];
                        if (val == null) continue;
                        expectedType = val.getType();
                        break;
                    }
                }
                propType = expectedType;
            }
            for (Value value : propertyValues) {
                if (value != null) {
                    valueDataList.add(this.valueData(value, propType));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Set null value (" + this.getPath() + ", multivalued: " + multiValue + ")"));
            }
        }
        this.checkValueConstraints(def, valueDataList, propType);
        TransientPropertyData newData = new TransientPropertyData(qpath, uuid, version, propType, parentNode.getInternalUUID(), multiValue);
        if (requiredType != 0 && expectedType != 0 && requiredType != expectedType) {
            throw new ConstraintViolationException(" the type parameter " + ExtendedPropertyType.nameFromValue((int)expectedType) + " and the " + "type of the property do not match required type" + ExtendedPropertyType.nameFromValue((int)requiredType));
        }
        PropertyImpl prop = null;
        if (state != 3) {
            newData.setValues(valueDataList);
            ItemState itemState = new ItemState((ItemData)newData, state, true, qpath, false);
            prop = (PropertyImpl)this.dataManager.update(itemState, true);
            this.session.getActionHandler().postSetProperty(parentNode, prop, state);
        } else {
            if (def.isMandatory()) {
                throw new ConstraintViolationException("Can not remove (by setting null value) mandatory property " + this.getPath());
            }
            this.session.getActionHandler().preRemoveItem(parentNode, oldProp);
            this.dataManager.delete((ItemData)newData);
            prop = oldProp;
        }
        return prop;
    }

    public void save() throws ReferentialIntegrityException, AccessDeniedException, LockException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, RepositoryException {
        this.checkValid();
        if (this.isNew()) {
            throw new RepositoryException("It is impossible to call save() on the newly added item " + this.getPath());
        }
        NodeTypeManagerImpl ntManager = this.session.getWorkspace().getNodeTypeManager();
        if (this.isNode()) {
            InternalQPath path = this.getInternalPath();
            List<ItemState> changes = this.dataManager.getChangesLog().getDescendantsChanges(path);
            ArrayList<NodeData> refNodes = new ArrayList<NodeData>();
            for (ItemState changedItem : changes) {
                NodeData refNode;
                if (!changedItem.isNode() || !ntManager.isNodeType(Constants.MIX_REFERENCEABLE, (refNode = (NodeData)changedItem.getData()).getPrimaryTypeName(), refNode.getMixinTypeNames())) continue;
                if (changedItem.isDeleted()) {
                    refNodes.add(refNode);
                    continue;
                }
                if (!changedItem.isAdded()) continue;
                refNodes.remove(refNode);
            }
            for (NodeData refNode : refNodes) {
                List<PropertyData> nodeRefs = this.dataManager.getReferencesData(refNode.getUUID());
                for (PropertyData refProp : nodeRefs) {
                    ItemState refState = this.dataManager.getChangesLog().getItemState(refProp.getUUID());
                    if (refState != null && refState.isDeleted()) continue;
                    NodeData refParent = (NodeData)this.dataManager.getItemData(refProp.getParentUUID());
                    AccessControlList acl = refParent.getACL();
                    AccessManager am = this.session.getAccessManager();
                    if (!am.hasPermission(acl, "read", this.session.getUserID())) {
                        throw new AccessDeniedException("Can not delete node " + refNode.getQPath() + " (" + refNode.getUUID() + ")" + ". It is currently the target of a REFERENCE property and " + path.getAsString());
                    }
                    throw new ReferentialIntegrityException("Can not delete node " + refNode.getQPath() + " (" + refNode.getUUID() + ")" + ". It is currently the target of a REFERENCE property " + path.getAsString());
                }
            }
        }
        this.dataManager.commit(this.getInternalPath());
    }

    public void refresh(boolean keepChanges) throws InvalidItemStateException, RepositoryException {
        this.checkValid();
        if (keepChanges) {
            this.dataManager.refresh(this.getData());
        } else {
            this.dataManager.rollback(this.getData());
        }
    }

    public ItemData getData() {
        return this.data;
    }

    public String getParentUUID() {
        return this.getData().getParentUUID();
    }

    public InternalQPath getInternalPath() {
        return this.getData().getQPath();
    }

    public InternalQName getInternalName() {
        return this.getData().getQPath().getName();
    }

    protected ItemImpl item(JCRPath path) throws RepositoryException {
        return this.dataManager.getItem(path.getInternalPath(), true);
    }

    protected ItemImpl item(InternalQPath path) throws RepositoryException {
        return this.dataManager.getItem(path, true);
    }

    protected ItemImpl item(String uuid) throws RepositoryException {
        return this.dataManager.getItemByUUID(uuid, true);
    }

    protected NodeImpl parent() throws RepositoryException {
        NodeImpl parent = (NodeImpl)this.item(this.getParentUUID());
        if (parent == null) {
            throw new ItemNotFoundException("FATAL: Parent is null for " + this.getInternalPath().getAsString() + " parent UUID: " + this.getParentUUID());
        }
        return parent;
    }

    public String getInternalUUID() {
        return this.data.getUUID();
    }

    public JCRPath getLocation() {
        return this.location;
    }

    public boolean isRoot() {
        return this.getDepth() == 0;
    }

    abstract void loadData(ItemData var1) throws RepositoryException;

    public boolean hasPermission(String action) throws RepositoryException {
        NodeImpl testNode;
        if (this.isNode()) {
            testNode = (NodeImpl)this;
        } else {
            testNode = this.parent();
            if (testNode == null) {
                testNode = (NodeImpl)this.getParent();
            }
            if (testNode == null) {
                throw new RepositoryException("FATAL: parent not found for " + this.getPath());
            }
        }
        return this.session.getAccessManager().hasPermission(testNode.getACL(), action, this.session.getUserID());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ItemImpl) {
            ItemImpl otherItem = (ItemImpl)obj;
            if (!otherItem.isValid() || !this.isValid()) {
                return false;
            }
            try {
                return this.getInternalUUID().equals(otherItem.getInternalUUID());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.itemHashCode;
    }

    private ValueData valueData(Value value, int type) throws RepositoryException, ValueFormatException {
        if (value == null) {
            return null;
        }
        switch (type) {
            case 1: {
                return new TransientValueData(value.getString());
            }
            case 2: {
                TransientValueData vd = null;
                vd = value instanceof BaseValue ? ((BaseValue)value).getInternalData().createTransientCopy() : (value instanceof ExtendedValue ? ((BaseValue)this.getSession().getValueFactory().createValue(value.getStream())).getInternalData() : ((BaseValue)this.getSession().getValueFactory().createValue(value.getString(), 2)).getInternalData());
                return vd;
            }
            case 6: {
                return new TransientValueData(value.getBoolean());
            }
            case 3: {
                return new TransientValueData(value.getLong());
            }
            case 4: {
                return new TransientValueData(value.getDouble());
            }
            case 5: {
                return new TransientValueData(value.getDate());
            }
            case 8: {
                TransientValueData tvd = null;
                if (value instanceof PathValue) {
                    tvd = ((PathValue)value).getInternalData().createTransientCopy();
                } else {
                    InternalQPath pathValue = this.locationFactory.parseJCRPath(value.getString()).getInternalPath();
                    tvd = new TransientValueData(pathValue);
                }
                return tvd;
            }
            case 7: {
                InternalQName nameValue = this.locationFactory.parseJCRName(value.getString()).getInternalName();
                return new TransientValueData(nameValue);
            }
            case 9: {
                Uuid uuid = new Uuid(value.getString());
                return new TransientValueData(uuid);
            }
            case 100: {
                PermissionValue permValue = (PermissionValue)value;
                AccessControlEntry ace = new AccessControlEntry(permValue.getIdentity(), permValue.getPermission());
                return new TransientValueData(ace);
            }
        }
        throw new ValueFormatException("ValueFactory.convert() unknown or unconvertable type " + type);
    }

    private void checkValueConstraints(PropertyDefinition def, List<ValueData> newValues, int type) throws ConstraintViolationException, RepositoryException {
        ValueConstraintsMatcher constraints = new ValueConstraintsMatcher(def.getValueConstraints(), this.session);
        for (ValueData value : newValues) {
            if (constraints.match(value, type)) continue;
            String strVal = null;
            try {
                strVal = ((TransientValueData)value).getString();
            }
            catch (Throwable e) {
                log.error((Object)("Error of value read: " + e.getMessage()), e);
            }
            throw new ConstraintViolationException("Can not set value '" + strVal + "' to " + this.getPath() + " due to value constraints ");
        }
    }
}

