/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.log.ExoLogger;

public class JCRPath {
    public static final String ROOT_PATH = "/";
    public static final String THIS_RELPATH = ".";
    public static final String PARENT_RELPATH = "..";
    protected static Log log = ExoLogger.getLogger((String)"jcr.JCRPath");
    protected PathElement[] names = new PathElement[0];

    JCRPath() {
    }

    public boolean isAbsolute() {
        PathElement first;
        return this.names.length > 0 && (first = this.names[0]).getName().equals(ROOT_PATH);
    }

    JCRPath addEntry(String namespace, String name, String prefix, int index) {
        if (name.equals(THIS_RELPATH)) {
            return this;
        }
        if (name.equals(PARENT_RELPATH)) {
            return this.addEntry(new MoveUpElement());
        }
        return this.addEntry(new PathElement(namespace, name, prefix, index));
    }

    JCRPath addEntry(PathElement entry) {
        if (this.names.length > 0 && entry instanceof MoveUpElement && !(this.names[this.names.length - 1] instanceof MoveUpElement)) {
            return this.removeLastEntry();
        }
        PathElement[] newNames = new PathElement[this.names.length + 1];
        for (int i = 0; i < this.names.length; ++i) {
            newNames[i] = this.names[i];
        }
        newNames[this.names.length] = entry;
        this.names = newNames;
        return this;
    }

    JCRPath removeLastEntry() {
        if (this.names.length <= 0) {
            log.warn((Object)("Wrong relative path. Can't move up in path hierarhy. " + this.getAsString(true)));
            return this;
        }
        PathElement[] newNames = new PathElement[this.names.length - 1];
        for (int i = 0; i < newNames.length; ++i) {
            newNames[i] = this.names[i];
        }
        this.names = newNames;
        return this;
    }

    public JCRPath makeParentPath() {
        return this.makeAncestorPath(1);
    }

    public JCRPath makeAncestorPath(int relativeDegree) {
        JCRPath path = new JCRPath();
        for (int i = 0; i < this.names.length - relativeDegree; ++i) {
            path.addEntry(this.names[i]);
        }
        return path;
    }

    public PathElement[] getRelPath(int relativeDegree) {
        ArrayList<PathElement> entries = new ArrayList<PathElement>();
        for (int i = this.names.length - relativeDegree; i < this.names.length; ++i) {
            entries.add(this.names[i]);
        }
        PathElement[] relPath = new PathElement[entries.size()];
        for (int i = 0; i < relPath.length; ++i) {
            relPath[i] = (PathElement)entries.get(i);
        }
        return relPath;
    }

    public InternalQPath getInternalPath() {
        InternalQPath.Entry[] entries = new InternalQPath.Entry[this.names.length];
        for (int i = 0; i < this.names.length; ++i) {
            entries[i] = new InternalQPath.Entry(this.names[i].getNamespace(), this.names[i].getName(), this.names[i].getIndex());
        }
        InternalQPath qpath = new InternalQPath(entries);
        return qpath;
    }

    public String getAsString(boolean showIndex) {
        if (this.size() == 1) {
            return ROOT_PATH;
        }
        String path = "";
        for (int i = 1; i < this.names.length; ++i) {
            path = path + ROOT_PATH + this.names[i].getAsString(showIndex);
        }
        return path;
    }

    public int getDepth() {
        return this.size() - 1;
    }

    public boolean isDescendantOf(JCRPath ancestorLocation, boolean childOnly) {
        int depthDiff = this.getDepth() - ancestorLocation.getDepth();
        if (depthDiff <= 0 || childOnly && depthDiff != 1) {
            return false;
        }
        PathElement[] anotherNames = ancestorLocation.getEntries();
        for (int i = 0; i < anotherNames.length; ++i) {
            boolean result = anotherNames[i].equals(this.names[i]);
            if (result) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestorOf(JCRPath descendantLocation, boolean childOnly) {
        return descendantLocation.isDescendantOf(this, childOnly);
    }

    private int size() {
        return this.names.length;
    }

    public JCRName getName() {
        if (this.size() > 0) {
            return this.names[this.size() - 1];
        }
        return new ThisElement();
    }

    public int getIndex() {
        return this.names[this.size() - 1].getIndex();
    }

    public boolean isIndexSetExplicitly() {
        return this.names[this.size() - 1].isIndexSetExplicitly();
    }

    public boolean isSameNameSibling(JCRPath anotherPath) {
        PathElement[] anotherNames = anotherPath.getEntries();
        for (int i = 0; i < anotherNames.length - 1; ++i) {
            boolean result = ((JCRName)anotherNames[i]).equals(this.names[i]);
            if (result) continue;
            return false;
        }
        return this.getName().getName().equals(anotherPath.getName().getName()) && this.getName().getPrefix().equals(anotherPath.getName().getPrefix());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof JCRPath) {
            JCRPath other = (JCRPath)obj;
            return this.getInternalPath().equals((Object)other.getInternalPath());
        }
        return false;
    }

    PathElement[] getEntries() {
        return this.names;
    }

    public class PathElement
    extends JCRName {
        private final int index;
        private final boolean indexSetExplicitly;

        public PathElement(String namespace, String name, String prefix, int index) {
            super(namespace, name, prefix);
            if (index == -1) {
                this.index = 1;
                this.indexSetExplicitly = false;
            } else {
                this.index = index;
                this.indexSetExplicitly = true;
            }
        }

        public PathElement clone(int newIndex) {
            return new PathElement(this.namespace, this.name, this.prefix, newIndex);
        }

        public int getIndex() {
            return this.index;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PathElement)) {
                return false;
            }
            return super.equals(obj) && this.index == ((PathElement)obj).getIndex();
        }

        public String getAsString(boolean showIndex) {
            String indexStr = showIndex || this.getIndex() > 1 ? "[" + this.getIndex() + "]" : "";
            return (super.getAsString() + indexStr).intern();
        }

        public boolean isIndexSetExplicitly() {
            return this.indexSetExplicitly;
        }
    }

    public class MoveUpElement
    extends PathElement {
        MoveUpElement() {
            super("", JCRPath.PARENT_RELPATH, "", -1);
        }
    }

    public class ThisElement
    extends PathElement {
        ThisElement() {
            super("", JCRPath.THIS_RELPATH, "", -1);
        }
    }
}

