/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.NamespaceAccessor;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.JCRPath;

public class LocationFactory {
    private NamespaceAccessor namespaces;

    public LocationFactory(NamespaceAccessor namespaces) {
        this.namespaces = namespaces;
    }

    public JCRPath createRootLocation() throws RepositoryException {
        return this.parseNames("/", true);
    }

    public JCRPath createJCRPath(JCRPath parentLoc, String relPath) throws RepositoryException {
        JCRPath path = new JCRPath();
        for (int i = 0; i < parentLoc.getEntries().length; ++i) {
            path.addEntry(parentLoc.getEntries()[i]);
        }
        JCRPath addPath = this.parseNames(relPath, false);
        for (int i = 0; i < addPath.getEntries().length; ++i) {
            path.addEntry(addPath.getEntries()[i]);
        }
        return path;
    }

    public JCRPath parseAbsPath(String absPath) throws RepositoryException {
        return this.parseNames(absPath, true);
    }

    public JCRPath parseRelPath(String relPath) throws RepositoryException {
        return this.parseNames(relPath, false);
    }

    public JCRPath parseJCRPath(String path) throws RepositoryException {
        if (LocationFactory.isAbsPathParseable(path)) {
            return this.parseAbsPath(path);
        }
        return this.parseRelPath(path);
    }

    public JCRPath createJCRPath(InternalQPath qPath) throws RepositoryException {
        JCRPath path = new JCRPath();
        for (int i = 0; i < qPath.getEntries().length; ++i) {
            InternalQPath.Entry entry = qPath.getEntries()[i];
            String prefix = this.namespaces.getNamespacePrefixByURI(entry.getNamespace());
            path.addEntry(entry.getNamespace(), entry.getName(), prefix, entry.getIndex());
        }
        return path;
    }

    public JCRName createJCRName(InternalQName qname) throws RepositoryException {
        String prefix = this.namespaces.getNamespacePrefixByURI(qname.getNamespace());
        return new JCRName(qname.getNamespace(), qname.getName(), prefix);
    }

    public JCRName parseJCRName(String name) throws PathNotFoundException, RepositoryException {
        JCRPath.PathElement entry = this.parsePathEntry(new JCRPath(), name);
        return new JCRName(entry.getNamespace(), entry.getName(), entry.getPrefix());
    }

    public JCRPath.PathElement[] createRelPath(InternalQPath.Entry[] relPath) throws RepositoryException {
        JCRPath path = new JCRPath();
        JCRPath.PathElement[] entries = new JCRPath.PathElement[relPath.length];
        for (int i = 0; i < relPath.length; ++i) {
            String uri = this.namespaces.getNamespaceURIByPrefix(relPath[i].getNamespace());
            String prefix = this.namespaces.getNamespacePrefixByURI(uri);
            path.addEntry(uri, relPath[i].getName(), prefix, relPath[i].getIndex());
        }
        return path.getEntries();
    }

    private JCRPath.PathElement parsePathEntry(JCRPath path, String name) throws PathNotFoundException, RepositoryException {
        int index = -1;
        if (name == null) {
            throw new RepositoryException("Name can not be null");
        }
        int delim = name.indexOf(":");
        int endOfName = name.length();
        int indexStart = name.indexOf("[");
        if (indexStart > 0) {
            int indexEnd = name.indexOf("]");
            if (indexEnd <= indexStart) {
                throw new RepositoryException("Invalid path entry " + name);
            }
            index = Integer.parseInt(name.substring(indexStart + 1, indexEnd));
            endOfName = indexStart;
        }
        try {
            String prefix = delim <= 0 ? "" : name.substring(0, delim);
            path.addEntry(this.namespaces.getNamespaceURIByPrefix(prefix), name.substring(delim + 1, endOfName), prefix, index);
            return (JCRPath.PathElement)path.getName();
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    private JCRPath parseNames(String path, boolean absolute) throws PathNotFoundException, RepositoryException {
        if (path == null) {
            throw new RepositoryException("Illegal relPath " + path);
        }
        JCRPath jcrPath = new JCRPath();
        int start = 0;
        if (!absolute) {
            start = -1;
        }
        if (LocationFactory.isAbsPathParseable(path)) {
            if (!absolute) {
                throw new RepositoryException("Illegal relPath " + path);
            }
            this.parsePathEntry(jcrPath, "");
        } else if (absolute) {
            throw new RepositoryException("Illegal absPath " + path);
        }
        int end = 0;
        while (end >= 0) {
            end = path.indexOf(47, start + 1);
            String qname = path.substring(start + 1, end == -1 ? path.length() : end);
            if (qname.length() == 0) {
                return jcrPath;
            }
            this.parsePathEntry(jcrPath, qname);
            start = end;
        }
        return jcrPath;
    }

    private static boolean isAbsPathParseable(String str) {
        return str.startsWith("/");
    }
}

