/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.InvalidItemStateException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.MutableItemDataChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.NodeDataReader;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceDataPersister {
    public static Log log = ExoLogger.getLogger((String)"jcr.NamespaceDataPersister");
    private DataManager dataManager;
    private MutableItemDataChangesLog changesLog;
    private NodeData nsRoot;

    public NamespaceDataPersister(DataManager dataManager) {
        this.dataManager = dataManager;
        this.changesLog = new MutableItemDataChangesLog();
        try {
            this.nsRoot = (NodeData)dataManager.getItemData(Constants.EXO_NAMESPACES_PATH);
        }
        catch (RepositoryException e) {
            log.warn((Object)"Namespace storage (/jcr:system/exo:namespaces node) is not initialized");
        }
    }

    public void initStorage(NodeData nsSystem, boolean addACL, Map<String, String> namespaces) throws IllegalNameException, RepositoryException {
        TransientNodeData root = TransientNodeData.createNodeData(nsSystem, Constants.EXO_NAMESPACES, Constants.NT_UNSTRUCTURED);
        TransientPropertyData primaryType = TransientPropertyData.createPropertyData((NodeData)root, Constants.JCR_PRIMARYTYPE, 7, false);
        primaryType.setValue(new TransientValueData(root.getPrimaryTypeName()));
        this.changesLog.add(ItemState.createAddedState((ItemData)root)).add(ItemState.createAddedState((ItemData)primaryType));
        if (addACL) {
            AccessControlList acl = new AccessControlList();
            root.setMixinTypeNames(new InternalQName[]{Constants.EXO_ACCESS_CONTROLLABLE});
            TransientPropertyData rootMixinTypes = TransientPropertyData.createPropertyData((NodeData)root, Constants.JCR_MIXINTYPES, 7, false);
            rootMixinTypes.setValue(new TransientValueData(Constants.EXO_ACCESS_CONTROLLABLE));
            TransientPropertyData exoOwner = TransientPropertyData.createPropertyData((NodeData)root, Constants.EXO_OWNER, 1, false);
            exoOwner.setValue(new TransientValueData(acl.getOwner()));
            TransientPropertyData exoPerms = TransientPropertyData.createPropertyData((NodeData)root, Constants.EXO_PERMISSIONS, 100, true);
            ArrayList<ValueData> perms = new ArrayList<ValueData>();
            for (int i = 0; i < acl.getPermissionEntries().size(); ++i) {
                AccessControlEntry entry = (AccessControlEntry)acl.getPermissionEntries().get(i);
                perms.add(new TransientValueData(entry));
            }
            exoPerms.setValues(perms);
            this.changesLog.add(ItemState.createAddedState((ItemData)rootMixinTypes)).add(ItemState.createAddedState((ItemData)exoOwner)).add(ItemState.createAddedState((ItemData)exoPerms));
            this.changesLog.add(new ItemState((ItemData)root, 8, false, null));
        }
        this.nsRoot = root;
        for (String nsKey : namespaces.keySet()) {
            if (nsKey != null) {
                log.debug((Object)("Namespace " + nsKey + " " + namespaces.get(nsKey)));
                this.addNamespace(nsKey, namespaces.get(nsKey));
                log.info((Object)("Namespace " + nsKey + " is initialized."));
                continue;
            }
            log.warn((Object)("Namespace is " + nsKey + " " + namespaces.get(nsKey)));
        }
        this.saveChanges();
    }

    public void addNamespace(String prefix, String uri) throws IllegalNameException, RepositoryException, InvalidItemStateException {
        if (!this.isInialized()) {
            log.warn((Object)"Namespace storage (/jcr:system/exo:namespaces node) is not initialized");
            return;
        }
        TransientNodeData nsNode = TransientNodeData.createNodeData(this.nsRoot, new InternalQName("", prefix), Constants.EXO_NAMESPACE);
        TransientPropertyData primaryType = TransientPropertyData.createPropertyData((NodeData)nsNode, Constants.JCR_PRIMARYTYPE, 7, false);
        primaryType.setValue(new TransientValueData(nsNode.getPrimaryTypeName()));
        TransientPropertyData exoUri = TransientPropertyData.createPropertyData((NodeData)nsNode, Constants.EXO_URI_NAME, 1, false);
        exoUri.setValue(new TransientValueData(uri));
        TransientPropertyData exoPrefix = TransientPropertyData.createPropertyData((NodeData)nsNode, Constants.EXO_PREFIX, 1, false);
        exoPrefix.setValue(new TransientValueData(prefix));
        this.changesLog.add(ItemState.createAddedState((ItemData)nsNode)).add(ItemState.createAddedState((ItemData)primaryType)).add(ItemState.createAddedState((ItemData)exoUri)).add(ItemState.createAddedState((ItemData)exoPrefix));
    }

    void removeNamespace(String prefix) throws IllegalNameException {
        if (!this.isInialized()) {
            log.warn((Object)"Namespace storage (/jcr:system/exo:namespaces node) is not initialized");
            return;
        }
        TransientNodeData nsNode = TransientNodeData.createNodeData(this.nsRoot, InternalQName.parse((String)prefix), Constants.EXO_NAMESPACE);
        this.changesLog.add(ItemState.createDeletedState((ItemData)nsNode));
    }

    Map<String, String> loadNamespaces() throws PathNotFoundException, RepositoryException {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        if (this.isInialized()) {
            NodeDataReader nsReader = new NodeDataReader(this.nsRoot, this.dataManager, null);
            nsReader.setRememberSkiped(true);
            nsReader.forNodesByType(Constants.EXO_NAMESPACE);
            nsReader.read();
            List<NodeDataReader> nsData = nsReader.getNodesByType(Constants.EXO_NAMESPACE);
            for (NodeDataReader nsr : nsData) {
                nsr.forProperty(Constants.EXO_URI_NAME, 1).forProperty(Constants.EXO_PREFIX, 1);
                nsr.read();
                String exoUri = nsr.getPropertyValue(Constants.EXO_URI_NAME).getString();
                String exoPrefix = nsr.getPropertyValue(Constants.EXO_PREFIX).getString();
                nsMap.put(exoPrefix, exoUri);
                log.info((Object)("Namespace " + exoPrefix + " is loaded"));
            }
            for (NodeData skipedNs : nsReader.getSkiped()) {
                log.warn((Object)("Namespace node " + skipedNs.getQPath().getName().getAsString() + " (primary type '" + skipedNs.getPrimaryTypeName().getAsString() + "') is not supported for loading. Nodes with 'exo:namespace' node type is supported only now."));
            }
        } else {
            log.warn((Object)"Namespace storage (/jcr:system/exo:namespaces node) is not initialized. No namespaces loaded.");
        }
        return nsMap;
    }

    void saveChanges() throws RepositoryException, InvalidItemStateException {
        this.dataManager.save((ItemDataChangesLog)this.changesLog);
        this.changesLog.clear();
    }

    void discardChanges() throws RepositoryException, InvalidItemStateException {
        this.changesLog.clear();
    }

    private boolean isInialized() {
        return this.nsRoot != null;
    }
}

