/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.Uuid;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.itemfilters.NamePatternFilter;
import org.exoplatform.services.jcr.impl.core.lock.LockImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.core.version.ItemDataMergeVisitor;
import org.exoplatform.services.jcr.impl.core.version.MergeVisitor;
import org.exoplatform.services.jcr.impl.core.version.VersionHistoryImpl;
import org.exoplatform.services.jcr.impl.core.version.VersionImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.MutableItemDataChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.util.EntityCollection;
import org.exoplatform.services.jcr.util.UUIDGenerator;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeImpl
extends ItemImpl
implements ExtendedNode {
    protected static Log log = ExoLogger.getLogger((String)"jcr.NodeImpl");
    protected LocationFactory sysLocFactory;
    private NodeDefinition definition;

    public NodeImpl(NodeData data, SessionImpl session) throws RepositoryException {
        super((ItemData)data, session);
        this.sysLocFactory = session.getSystemLocationFactory();
        this.loadData((ItemData)data);
    }

    @Override
    public void loadData(ItemData data) throws RepositoryException, InvalidItemStateException, ConstraintViolationException {
        if (data == null) {
            throw new InvalidItemStateException("Data is null for " + this.getPath() + " Probably was deleted by another session and can not be loaded from container ");
        }
        if (!data.isNode()) {
            throw new RepositoryException("Load data failed: Node expected");
        }
        NodeData nodeData = (NodeData)data;
        if (nodeData.getPrimaryTypeName() == null) {
            throw new RepositoryException("Load data: NodeData has no primaryTypeName. Null value found. " + (nodeData.getQPath() != null ? nodeData.getQPath().getAsString() : "[null path node]") + " " + nodeData);
        }
        if (nodeData.getMixinTypeNames() == null) {
            throw new RepositoryException("Load data: NodeData has no mixinTypeNames. Null value found. " + (nodeData.getQPath() != null ? nodeData.getQPath().getAsString() : "[null path node]"));
        }
        if (nodeData.getACL() == null) {
            throw new RepositoryException("ACL is NULL " + nodeData.getQPath().getAsString());
        }
        this.data = nodeData;
        this.location = this.session.getLocationFactory().createJCRPath(this.getData().getQPath());
    }

    private void initDefinition() throws RepositoryException, ConstraintViolationException {
        if (this.isRoot()) {
            NodeDefinitionImpl defNodeDef = new NodeDefinitionImpl();
            defNodeDef.setRequiredNodeTypes(new NodeType[]{this.nodeType(Constants.NT_BASE)});
            this.definition = defNodeDef;
            return;
        }
        NodeData parent = (NodeData)this.dataManager.getItemData(this.getParentUUID());
        this.definition = this.session.getWorkspace().getNodeTypeManager().findNodeDefinition(this.getInternalName(), parent.getPrimaryTypeName(), parent.getMixinTypeNames());
        if (this.definition == null) {
            throw new ConstraintViolationException("NodeImpl.getDefinition failed. Definition not found for " + this.getPath());
        }
    }

    public Node getNode(String relPath) throws PathNotFoundException, RepositoryException {
        this.checkValid();
        JCRPath itemPath = this.locationFactory.createJCRPath(this.getLocation(), relPath);
        NodeImpl node = (NodeImpl)this.dataManager.getItem(itemPath.getInternalPath(), true);
        if (node == null) {
            throw new PathNotFoundException("Node not found " + itemPath.getAsString(true));
        }
        return node;
    }

    public NodeIterator getNodes() throws RepositoryException {
        this.checkValid();
        return new EntityCollection(this.childNodes());
    }

    public List<NodeImpl> childNodes() throws RepositoryException, AccessDeniedException {
        List<NodeImpl> storedNodes = this.dataManager.getChildNodes(this.nodeData(), true);
        Collections.sort(storedNodes, new NodesOrderComparator());
        return storedNodes;
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        this.checkValid();
        NamePatternFilter filter = new NamePatternFilter(namePattern);
        ArrayList<NodeImpl> list = new ArrayList<NodeImpl>();
        for (NodeImpl item : this.childNodes()) {
            if (!filter.accept(item)) continue;
            list.add(item);
        }
        return new EntityCollection(list);
    }

    public Property getProperty(String relPath) throws PathNotFoundException, RepositoryException {
        ItemImpl prop;
        this.checkValid();
        JCRPath itemPath = this.locationFactory.createJCRPath(this.getLocation(), relPath);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getProperty() " + itemPath.getAsString(false)));
        }
        if ((prop = this.item(itemPath)) == null || prop.isNode()) {
            throw new PathNotFoundException("Property not found " + itemPath.getAsString(false));
        }
        return (Property)prop;
    }

    protected PropertyImpl property(InternalQName name) throws IllegalPathException, PathNotFoundException, RepositoryException {
        ItemImpl prop = this.item(InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)name));
        if (prop == null || prop.isNode()) {
            throw new PathNotFoundException("Property not found " + name);
        }
        return (PropertyImpl)prop;
    }

    private boolean hasProperty(InternalQName name) {
        try {
            ItemData pdata = this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)name));
            if (pdata != null && !pdata.isNode()) {
                return true;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    public PropertyIterator getProperties() throws RepositoryException {
        this.checkValid();
        return new EntityCollection(this.childProperties());
    }

    public List<PropertyImpl> childProperties() throws RepositoryException, AccessDeniedException {
        List<PropertyImpl> storedProperties = this.dataManager.getChildProperties(this.nodeData(), true);
        Collections.sort(storedProperties, new PropertiesOrderComparator());
        return storedProperties;
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        this.checkValid();
        NamePatternFilter filter = new NamePatternFilter(namePattern);
        ArrayList<PropertyImpl> list = new ArrayList<PropertyImpl>();
        for (PropertyImpl item : this.childProperties()) {
            if (!filter.accept(item)) continue;
            list.add(item);
        }
        return new EntityCollection(list);
    }

    public int getIndex() throws RepositoryException {
        this.checkValid();
        return this.getInternalPath().getIndex();
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        this.checkValid();
        NodeType[] types = this.getAllNodeTypes();
        for (int i = 0; i < types.length; ++i) {
            ItemImpl primaryItem;
            String itemName = types[i].getPrimaryItemName();
            if (itemName == null || (primaryItem = this.dataManager.getItem(this.locationFactory.createJCRPath(this.getLocation(), itemName).getInternalPath(), true)) == null) continue;
            return primaryItem;
        }
        throw new ItemNotFoundException("Primary item not found for " + this.getPath());
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkValid();
        if (this.isNodeType("mix:referenceable")) {
            return this.getInternalUUID();
        }
        throw new UnsupportedRepositoryOperationException("Node " + this.getPath() + " is not referenceable");
    }

    public PropertyIterator getReferences() throws RepositoryException {
        this.checkValid();
        return new EntityCollection(this.dataManager.getReferences(this.getInternalUUID()));
    }

    public boolean hasNode(String relPath) throws RepositoryException {
        this.checkValid();
        try {
            this.getNode(relPath);
        }
        catch (PathNotFoundException e) {
            return false;
        }
        return true;
    }

    public boolean hasNodes() throws RepositoryException {
        this.checkValid();
        return this.getNodes().hasNext();
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        this.checkValid();
        try {
            this.getProperty(relPath);
            return true;
        }
        catch (RepositoryException e) {
            if (e instanceof AccessDeniedException) {
                throw e;
            }
            return false;
        }
    }

    public boolean hasProperties() throws RepositoryException {
        this.checkValid();
        return this.dataManager.getChildProperties(this.nodeData(), true) != null;
    }

    public Node addNode(String relPath) throws PathNotFoundException, ConstraintViolationException, RepositoryException, VersionException, LockException {
        this.checkValid();
        JCRPath itemPath = this.locationFactory.createJCRPath(this.getLocation(), relPath);
        if (itemPath.isIndexSetExplicitly()) {
            throw new RepositoryException("The relPath provided must not have an index on its final element. " + itemPath.getAsString(false));
        }
        ItemImpl parentItem = this.dataManager.getItem(itemPath.makeParentPath().getInternalPath(), true);
        if (parentItem == null) {
            throw new PathNotFoundException("Parent not found for " + itemPath.getAsString(true));
        }
        if (!parentItem.isNode()) {
            throw new ConstraintViolationException("Parent item is not a node " + parentItem.getPath());
        }
        NodeImpl parent = (NodeImpl)parentItem;
        InternalQName name = itemPath.getName().getInternalName();
        JCRName nodeTypeName = parent.findNodeType(itemPath.getName().getAsString());
        return this.doAddNode(parent, name, nodeTypeName.getInternalName());
    }

    private JCRName findNodeType(String name) throws RepositoryException, ConstraintViolationException {
        NodeType[] nodeTypes = this.getAllNodeTypes();
        String residualNodeTypeName = null;
        for (int j = 0; j < nodeTypes.length; ++j) {
            NodeDefinition[] nodeDefs = nodeTypes[j].getChildNodeDefinitions();
            for (int i = 0; i < nodeDefs.length; ++i) {
                NodeDefinition nodeDef = nodeDefs[i];
                if (nodeDef.getName().equals(name)) {
                    return this.sysLocFactory.parseJCRName(nodeDef.getDefaultPrimaryType().getName());
                }
                if (!nodeDef.getName().equals("*")) continue;
                residualNodeTypeName = nodeDef.getDefaultPrimaryType().getName();
            }
        }
        if (residualNodeTypeName == null) {
            throw new ConstraintViolationException("Can not define node type for " + name);
        }
        return this.sysLocFactory.parseJCRName(residualNodeTypeName);
    }

    public Node addNode(String relPath, String nodeTypeName) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, ConstraintViolationException, RepositoryException, VersionException, LockException {
        this.checkValid();
        JCRPath itemPath = this.locationFactory.createJCRPath(this.getLocation(), relPath);
        if (itemPath.isIndexSetExplicitly()) {
            throw new RepositoryException("The relPath provided must not have an index on its final element. " + itemPath.getAsString(false));
        }
        ItemImpl parentItem = this.dataManager.getItem(itemPath.makeParentPath().getInternalPath(), true);
        if (parentItem == null) {
            throw new PathNotFoundException("Parent not found for " + itemPath.getAsString(true));
        }
        if (!parentItem.isNode()) {
            throw new ConstraintViolationException("Parent item is not a node " + parentItem.getPath());
        }
        NodeImpl parent = (NodeImpl)parentItem;
        InternalQName name = itemPath.getName().getInternalName();
        InternalQName ptName = this.locationFactory.parseJCRName(nodeTypeName).getInternalName();
        return this.doAddNode(parent, name, ptName);
    }

    public void validateChildNode(InternalQName name, InternalQName primaryTypeName) throws ItemExistsException, RepositoryException, ConstraintViolationException, VersionException, LockException {
        ExtendedNodeType t;
        String ptStr = this.sysLocFactory.createJCRName(primaryTypeName).getAsString();
        if (this.nodeType(primaryTypeName).isMixin()) {
            throw new ConstraintViolationException("Add Node failed: Node Type <" + ptStr + "> is MIXIN type!");
        }
        NodeType[] types = this.getAllNodeTypes();
        for (int i = 0; i < types.length && !(t = (ExtendedNodeType)types[i]).isChildNodePrimaryTypeAllowed(ptStr); ++i) {
            if (i != types.length - 1) continue;
            throw new ConstraintViolationException("Can't add node " + name.getAsString() + " to " + this.getPath() + " node type " + primaryTypeName.getAsString() + " is not allowed as child's node type for parent node type ");
        }
        if (this.session.getWorkspace().getNodeTypeManager().findNodeDefinition(name, this.nodeData().getPrimaryTypeName(), this.nodeData().getMixinTypeNames()).isProtected()) {
            throw new ConstraintViolationException("Can't add protected node " + name.getAsString() + " to " + this.getPath());
        }
        if (!this.isCheckedOut()) {
            throw new VersionException("Node " + this.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!this.checkLocking()) {
            throw new LockException("Node " + this.getPath() + " is locked ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeImpl doAddNode(NodeImpl parentNode, InternalQName name, InternalQName primaryTypeName) throws ItemExistsException, RepositoryException, ConstraintViolationException, VersionException, LockException {
        ExtendedNodeType t;
        if (this.nodeType(primaryTypeName).isMixin()) {
            throw new ConstraintViolationException("Can not add node to " + parentNode.getPath() + " node type " + primaryTypeName.getAsString() + " is mixin ");
        }
        String ptStr = this.sysLocFactory.createJCRName(primaryTypeName).getAsString();
        NodeType[] types = this.getAllNodeTypes();
        for (int i = 0; i < types.length && !(t = (ExtendedNodeType)types[i]).isChildNodePrimaryTypeAllowed(ptStr); ++i) {
            if (i != types.length - 1) continue;
            throw new ConstraintViolationException("Can't add node " + name.getAsString() + " to " + this.getPath() + " node type " + primaryTypeName.getAsString() + " is not allowed as child's node type for parent node type ");
        }
        NodeDefinitionImpl def = null;
        try {
            def = this.session.getWorkspace().getNodeTypeManager().findNodeDefinition(name, parentNode.nodeData().getPrimaryTypeName(), parentNode.nodeData().getMixinTypeNames());
        }
        finally {
            if (def == null) {
                throw new ConstraintViolationException("Can't add node " + name.getAsString() + " to " + this.getPath() + " node type " + primaryTypeName.getAsString() + " is not allowed as child's node name" + ptStr + " for parent node type ");
            }
        }
        if (def.isProtected()) {
            throw new ConstraintViolationException("Can't add protected node " + name.getAsString() + " to " + parentNode.getPath());
        }
        if (!this.isCheckedOut()) {
            throw new VersionException("Node " + this.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!this.checkLocking()) {
            throw new LockException("Node " + this.getPath() + " is locked ");
        }
        InternalQName[] mixinTypeNames = new InternalQName[]{};
        String uuid = UUIDGenerator.generate();
        List<NodeData> siblings = this.dataManager.getChildNodesData(parentNode.nodeData());
        int orderNum = parentNode.getNextChildOrderNum(siblings);
        int index = parentNode.getNextChildIndex(name, siblings, parentNode.nodeData());
        InternalQPath path = InternalQPath.makeChildPath((InternalQPath)parentNode.getInternalPath(), (InternalQName)name, (int)index);
        AccessControlList acl = parentNode.getACL();
        TransientNodeData nodeData = new TransientNodeData(path, uuid, -1, primaryTypeName, mixinTypeNames, orderNum, parentNode.getInternalUUID(), acl);
        ItemState state = ItemState.createAddedState((ItemData)nodeData, (boolean)false);
        NodeImpl node = (NodeImpl)this.dataManager.update(state, true);
        node.addAutoCreatedItems(primaryTypeName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("new node : " + node.getPath() + " name: " + " primaryType: " + node.getPrimaryNodeType().getName() + " index: " + node.getIndex() + " parent: " + parentNode));
        }
        this.session.getActionHandler().postAddNode(node);
        return node;
    }

    public int getNextChildOrderNum(List<NodeData> siblings) throws RepositoryException {
        int max = -1;
        for (NodeData sibling : siblings) {
            int cur = sibling.getOrderNumber();
            if (cur <= max) continue;
            max = cur;
        }
        return ++max;
    }

    private int getNextChildIndex(InternalQName nameToAdd, List<NodeData> siblings, NodeData parentNode) throws RepositoryException, ItemExistsException {
        int ind = 0;
        for (NodeData sibling : siblings) {
            if (!sibling.getQPath().getName().equals((Object)nameToAdd)) continue;
            NodeDefinitionImpl def = this.session.getWorkspace().getNodeTypeManager().findNodeDefinition(nameToAdd, parentNode.getPrimaryTypeName(), parentNode.getMixinTypeNames());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calculate index for " + nameToAdd + " " + sibling.getQPath().getAsString()));
            }
            if (def.allowsSameNameSiblings()) {
                ++ind;
                continue;
            }
            throw new ItemExistsException("The node " + nameToAdd + " already exists in " + this.getPath() + " and same name sibling is not allowed ");
        }
        return ind + 1;
    }

    public Property setProperty(String name, Value[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), values, true, type);
    }

    public Property setProperty(String name, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), values, true, 0);
    }

    public Property setProperty(String name, String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        Value[] val = null;
        if (values != null) {
            val = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                val[i] = this.valueFactory.createValue(values[i]);
            }
        }
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), val, true, 0);
    }

    public Property setProperty(String name, String[] values, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        Value[] val = null;
        if (values != null) {
            val = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                val[i] = this.valueFactory.createValue(values[i], type);
            }
        }
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), val, true, type);
    }

    public Property setProperty(String name, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), value, false, 0);
    }

    public Property setProperty(String name, Value value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), value, false, type);
    }

    public Property setProperty(String name, String value, int type) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value, type), false, type);
    }

    public Property setProperty(String name, String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public Property setProperty(String name, InputStream value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public Property setProperty(String name, boolean value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public Property setProperty(String name, Calendar value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public Property setProperty(String name, double value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public Property setProperty(String name, long value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public Property setProperty(String name, Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        return this.doUpdateProperty(this, this.locationFactory.parseJCRName(name).getInternalName(), this.valueFactory.createValue(value), false, 0);
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        this.checkValid();
        return this.nodeType(this.nodeData().getPrimaryTypeName());
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        this.checkValid();
        if (this.nodeData().getMixinTypeNames() == null) {
            throw new RepositoryException("Data Container implementation error getMixinTypeNames == null");
        }
        ExtendedNodeType[] mixinNodeTypes = new ExtendedNodeType[this.nodeData().getMixinTypeNames().length];
        for (int i = 0; i < mixinNodeTypes.length; ++i) {
            mixinNodeTypes[i] = this.nodeType(this.nodeData().getMixinTypeNames()[i]);
        }
        return mixinNodeTypes;
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        return this.isNodeType(this.locationFactory.parseJCRName(nodeTypeName).getInternalName());
    }

    public boolean isNodeType(InternalQName qName) throws RepositoryException {
        ExtendedNodeType testNodeType;
        try {
            testNodeType = this.nodeType(qName);
        }
        catch (NoSuchNodeTypeException e) {
            log.warn((Object)("Node.isNodeType() No such nodetype: " + qName.getAsString()));
            return false;
        }
        NodeType[] nodetypes = this.getAllNodeTypes();
        for (int i = 0; i < nodetypes.length; ++i) {
            if (!NodeTypeImpl.isSameOrSubType((NodeType)testNodeType, nodetypes[i])) continue;
            return true;
        }
        return false;
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        this.checkValid();
        if (this.definition == null) {
            this.initDefinition();
        }
        return this.definition;
    }

    public String getCorrespondingNodePath(String workspaceName) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        this.checkValid();
        SessionImpl corrSession = ((RepositoryImpl)this.session.getRepository()).login(this.session.getCredentials(), workspaceName);
        return corrSession.getLocationFactory().createJCRPath(this.getCorrespondingNodeData(corrSession).getQPath()).getAsString(false);
    }

    public NodeData getCorrespondingNodeData(SessionImpl corrSession) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        NodeData corrNode;
        InternalQPath myPath = this.nodeData().getQPath();
        SessionDataManager corrDataManager = corrSession.getTransientNodesManager();
        if (this.isNodeType(Constants.MIX_REFERENCEABLE)) {
            corrNode = (NodeData)corrDataManager.getItemData(this.getUUID());
            if (corrNode != null) {
                return corrNode;
            }
        } else {
            for (int i = myPath.getDepth(); i >= 0; --i) {
                InternalQPath ancesstorPath = myPath.makeAncestorPath(i);
                NodeData ancestor = (NodeData)this.dataManager.getItemData(ancesstorPath);
                if (!corrSession.getWorkspace().getNodeTypeManager().isNodeType(Constants.MIX_REFERENCEABLE, ancestor.getPrimaryTypeName(), ancestor.getMixinTypeNames())) continue;
                NodeData corrAncestor = (NodeData)corrDataManager.getItemData(ancestor.getUUID());
                if (corrAncestor == null) {
                    throw new ItemNotFoundException("No corresponding path for ancestor " + this.locationFactory.createJCRPath(ancesstorPath).getAsString(false) + " in " + corrSession.getWorkspace().getName());
                }
                InternalQPath.Entry[] relQPathEntries = myPath.getRelPath(myPath.getDepth() - i);
                InternalQPath corrNodeQPath = InternalQPath.makeChildPath((InternalQPath)corrAncestor.getQPath(), (InternalQPath.Entry[])relQPathEntries);
                NodeData corrNode2 = (NodeData)corrDataManager.getItemData(corrNodeQPath);
                if (corrNode2 == null) continue;
                return corrNode2;
            }
        }
        if ((corrNode = (NodeData)corrDataManager.getItemData(myPath)) != null) {
            return corrNode;
        }
        throw new ItemNotFoundException("No corresponding path for " + this.getPath() + " in " + corrSession.getWorkspace().getName());
    }

    public NodeImpl getCorrespondingNode(SessionImpl correspSession) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        if (this.isNodeType(Constants.MIX_REFERENCEABLE)) {
            try {
                return (NodeImpl)correspSession.getNodeByUUID(this.getUUID());
            }
            catch (ItemNotFoundException e) {
            }
        } else {
            for (int i = this.getDepth(); i >= 0; --i) {
                NodeImpl ancestor = (NodeImpl)this.getAncestor(i);
                if (!ancestor.isNodeType(Constants.MIX_REFERENCEABLE)) continue;
                NodeImpl correspAncestor = (NodeImpl)correspSession.getNodeByUUID(ancestor.getUUID());
                JCRPath.PathElement[] relJCRPath = this.getLocation().getRelPath(this.getDepth() - i);
                try {
                    return (NodeImpl)correspAncestor.getNode(this.getRelPath(relJCRPath));
                }
                catch (ItemNotFoundException e) {
                    // empty catch block
                }
            }
        }
        try {
            return (NodeImpl)correspSession.getItem(this.getPath());
        }
        catch (PathNotFoundException e) {
            throw new ItemNotFoundException("No corresponding path for " + this.getPath() + " in " + correspSession.getWorkspace().getName());
        }
    }

    private String getRelPath(JCRPath.PathElement[] relPath) throws RepositoryException {
        String path = "";
        for (int i = 0; i < relPath.length; ++i) {
            path = path + relPath[i].getAsString(false);
            if (i >= relPath.length - 1) continue;
            path = path + "/";
        }
        return path;
    }

    public void update(String srcWorkspaceName) throws NoSuchWorkspaceException, AccessDeniedException, InvalidItemStateException, LockException, RepositoryException {
        String srcPath;
        this.checkValid();
        if (this.session.hasPendingChanges()) {
            throw new InvalidItemStateException("Session has pending changes ");
        }
        if (!this.checkLocking()) {
            throw new LockException("Node " + this.getPath() + " is locked ");
        }
        SessionChangesLog changes = new SessionChangesLog(this.session.getId());
        try {
            srcPath = this.getCorrespondingNodePath(srcWorkspaceName);
            ItemDataRemoveVisitor remover = new ItemDataRemoveVisitor(this.session, true);
            this.nodeData().accept((ItemDataVisitor)remover);
            changes.addAll(remover.getRemovedStates());
        }
        catch (ItemNotFoundException e) {
            log.debug((Object)("No corresponding node in workspace: " + srcWorkspaceName));
            return;
        }
        this.session.getTransientNodesManager().getTransactManager().save(changes);
        this.session.getWorkspace().clone(srcWorkspaceName, srcPath, this.getPath(), true);
    }

    public void addMixin(String mixinName) throws NoSuchNodeTypeException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        this.checkValid();
        InternalQName name = this.locationFactory.parseJCRName(mixinName).getInternalName();
        this.doAddMixin(name);
    }

    public void doAddMixin(InternalQName mixinName) throws NoSuchNodeTypeException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        ItemState state;
        ExtendedNodeType type = this.nodeType(mixinName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Node.addMixin " + mixinName + " " + this.getPath()));
        }
        if (type == null || !type.isMixin()) {
            throw new NoSuchNodeTypeException("Node Type " + mixinName + " not found or not mixin type.");
        }
        if (this.hasSameOrSubtypeMixin(type)) {
            throw new ConstraintViolationException("Can not add mixin type " + mixinName + " to " + this.getPath());
        }
        if (this.getDefinition().isProtected()) {
            throw new ConstraintViolationException("Can not add mixin type. Node is protected " + this.getPath());
        }
        if (!this.isCheckedOut()) {
            throw new VersionException("Node " + this.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!this.checkLocking()) {
            throw new LockException("Node " + this.getPath() + " is locked ");
        }
        InternalQName[] mixinTypes = this.nodeData().getMixinTypeNames();
        for (int i = 0; i < mixinTypes.length; ++i) {
            if (!type.equals(this.nodeType(mixinTypes[i]))) continue;
            log.warn((Object)("Node.addMixin node already has this mixin type " + mixinName + " " + this.getPath()));
            return;
        }
        ArrayList<InternalQName> newMixin = new ArrayList<InternalQName>(mixinTypes.length + 1);
        ArrayList<ValueData> values = new ArrayList<ValueData>(mixinTypes.length + 1);
        for (int i = 0; i < mixinTypes.length; ++i) {
            InternalQName cn = mixinTypes[i];
            newMixin.add(cn);
            values.add(new TransientValueData(cn));
        }
        newMixin.add(mixinName);
        values.add(new TransientValueData(mixinName));
        TransientPropertyData prop = (TransientPropertyData)this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_MIXINTYPES));
        if (prop != null) {
            prop = new TransientPropertyData(prop.getQPath(), prop.getUUID(), prop.getPersistedVersion(), prop.getType(), prop.getParentUUID(), prop.isMultiValued());
            prop.setValues(values);
            state = ItemState.createUpdatedState((ItemData)prop);
        } else {
            prop = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_MIXINTYPES, 7, true, values);
            state = ItemState.createAddedState((ItemData)prop);
        }
        this.updateMixin(newMixin);
        this.dataManager.update(state, true);
        this.addAutoCreatedItems(mixinName);
        this.session.getActionHandler().postAddMixin(this, mixinName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Node.addMixin Property " + prop.getQPath().getAsString() + " values " + mixinTypes.length));
        }
    }

    public void removeMixin(String mixinName) throws NoSuchNodeTypeException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        InternalQName[] mixinTypes = this.nodeData().getMixinTypeNames();
        InternalQName name = this.locationFactory.parseJCRName(mixinName).getInternalName();
        boolean found = false;
        for (InternalQName curName : mixinTypes) {
            if (!curName.equals((Object)name)) continue;
            found = true;
        }
        if (!found) {
            throw new NoSuchNodeTypeException("No mixin type found " + mixinName + " for node " + this.getPath());
        }
        if (!this.isCheckedOut()) {
            throw new VersionException("Node " + this.getPath() + " or its nearest ancestor is checked-in");
        }
        if (!this.checkLocking()) {
            throw new LockException("Node " + this.getPath() + " is locked ");
        }
        ArrayList<InternalQName> newMixin = new ArrayList<InternalQName>(mixinTypes.length - 1);
        ArrayList<ValueData> values = new ArrayList<ValueData>();
        for (InternalQName mt : mixinTypes) {
            if (mt.equals((Object)name)) continue;
            newMixin.add(mt);
            values.add(new TransientValueData(mt));
        }
        TransientPropertyData prop = (TransientPropertyData)this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_MIXINTYPES));
        prop.setValues(values);
        this.updateMixin(newMixin);
        this.session.getActionHandler().preRemoveMixin(this, name);
        if (newMixin.size() > 0) {
            this.dataManager.update(ItemState.createUpdatedState((ItemData)prop), true);
        } else {
            this.dataManager.delete((ItemData)prop);
        }
    }

    private void updateMixin(List<InternalQName> newMixin) throws RepositoryException {
        InternalQName[] mixins = new InternalQName[newMixin.size()];
        newMixin.toArray(mixins);
        ((TransientNodeData)this.data).setMixinTypeNames(mixins);
        this.dataManager.update(new ItemState(this.data, 8, false, null), true);
    }

    public boolean canAddMixin(String mixinName) throws RepositoryException {
        this.checkValid();
        if (this.hasSameOrSubtypeMixin(this.nodeType(this.locationFactory.parseJCRName(mixinName).getInternalName()))) {
            return false;
        }
        if (this.getDefinition().isProtected()) {
            return false;
        }
        if (!this.isCheckedOut()) {
            return false;
        }
        return this.checkLocking();
    }

    private boolean hasSameOrSubtypeMixin(ExtendedNodeType type) throws RepositoryException, ValueFormatException {
        InternalQName[] mixinTypes = this.nodeData().getMixinTypeNames();
        for (int i = 0; i < mixinTypes.length; ++i) {
            if (!NodeTypeImpl.isSameOrSubType((NodeType)type, (NodeType)this.nodeType(mixinTypes[i]))) continue;
            return true;
        }
        return false;
    }

    protected void doOrderBefore(JCRPath sourcePath, JCRPath destenationPath) throws RepositoryException {
        InternalQPath destPath;
        InternalQPath srcPath = sourcePath.getInternalPath();
        InternalQPath internalQPath = destPath = destenationPath != null ? destenationPath.getInternalPath() : null;
        if (srcPath.equals((Object)destPath)) {
            return;
        }
        if (destPath != null && srcPath.getDepth() != destPath.getDepth()) {
            throw new ItemNotFoundException("Source and destenation is not relative paths of depth one, i.e. is not a childs of same parent node");
        }
        List<NodeData> siblings = this.dataManager.getChildNodesData(this.nodeData());
        if (siblings.size() < 2) {
            throw new UnsupportedRepositoryOperationException("Nothing to order Count of child nodes " + siblings.size());
        }
        boolean snsOrder = destPath != null && srcPath.getName().equals((Object)destPath.getName());
        SessionChangesLog changes = new SessionChangesLog(this.session.getId());
        class OrderState {
            OrderState() {
            }

            public ItemState orderDeletedState(ItemData itemData) {
                return new ItemState(itemData, 10, true, null);
            }

            public ItemState orderAddedState(ItemData itemData) {
                return new ItemState(itemData, 9, true, null);
            }
        }
        OrderState observationState = new OrderState();
        TransientNodeData srcNode = null;
        TransientItemData destNode = null;
        int lastSourceSNSIndex = -1;
        int destSNSIndex = -1;
        for (int i = 0; i < siblings.size(); ++i) {
            TransientNodeData stateData;
            int orderSNSDirection;
            TransientNodeData sdata;
            block19: {
                block17: {
                    block18: {
                        sdata = (TransientNodeData)siblings.get(i);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("ORDER CHILD\t" + sdata.getQPath().getName() + "[" + sdata.getQPath().getIndex() + "] (" + sdata.getOrderNumber() + ")"));
                        }
                        orderSNSDirection = 0;
                        if (destPath != null && sdata.getQPath().getName().equals((Object)destPath.getName()) && sdata.getQPath().getIndex() == destPath.getIndex()) {
                            destNode = sdata;
                            destSNSIndex = lastSourceSNSIndex;
                            if (srcNode != null) {
                                stateData = lastSourceSNSIndex >= 0 ? srcNode.cloneAsSibling(lastSourceSNSIndex) : srcNode.clone();
                                stateData.setOrderNumber(((TransientNodeData)destNode).getOrderNumber() - 1);
                                changes.add(ItemState.createUpdatedState((ItemData)stateData));
                                changes.add(observationState.orderAddedState((ItemData)stateData));
                                srcNode = stateData;
                                if (!log.isDebugEnabled()) break;
                                log.debug((Object)("ORDER ADD\t\t" + stateData.getQPath().getName() + "[" + stateData.getQPath().getIndex() + "] (" + stateData.getOrderNumber() + ") BEFORE " + destNode.getQPath().getName() + "[" + destNode.getQPath().getIndex() + "] (" + ((TransientNodeData)destNode).getOrderNumber() + ")"));
                                break;
                            }
                            stateData = snsOrder ? ((TransientNodeData)destNode).cloneAsSibling(destNode.getQPath().getIndex() + 1) : ((TransientNodeData)destNode).clone();
                            stateData.setOrderNumber(((TransientNodeData)destNode).getOrderNumber() + 1);
                            changes.add(ItemState.createUpdatedState((ItemData)stateData));
                            destNode = stateData;
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("ORDER DOWN DEST\t" + sdata.getQPath().getName() + "[" + sdata.getQPath().getIndex() + "] (" + sdata.getOrderNumber() + ") --> " + stateData.getQPath().getName() + "[" + stateData.getQPath().getIndex() + "] (" + stateData.getOrderNumber() + ")"));
                            continue;
                        }
                        if (!snsOrder && !sdata.getQPath().getName().equals((Object)srcPath.getName())) break block17;
                        if (sdata.getQPath().getIndex() == srcPath.getIndex()) {
                            srcNode = sdata;
                            changes.add(observationState.orderDeletedState((ItemData)srcNode.clone()));
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("ORDER REMOVE\t" + srcNode.getQPath().getName() + "[" + srcNode.getQPath().getIndex() + "] (" + srcNode.getOrderNumber() + ")"));
                            }
                            if (destNode == null) continue;
                            stateData = snsOrder ? srcNode.cloneAsSibling(destNode.getQPath().getIndex() - 1) : (destSNSIndex >= 0 && lastSourceSNSIndex >= 0 ? srcNode.cloneAsSibling(destSNSIndex + 1) : srcNode.cloneAsSibling(1));
                            stateData.setOrderNumber(((TransientNodeData)destNode).getOrderNumber() - 1);
                            changes.add(ItemState.createUpdatedState((ItemData)stateData));
                            changes.add(observationState.orderAddedState((ItemData)stateData));
                            srcNode = stateData;
                            if (!log.isDebugEnabled()) break;
                            log.debug((Object)("ORDER ADD\t\t" + stateData.getQPath().getName() + "[" + stateData.getQPath().getIndex() + "] (" + stateData.getOrderNumber() + ") BEFORE " + destNode.getQPath().getName() + "[" + destNode.getQPath().getIndex() + "] (" + ((TransientNodeData)destNode).getOrderNumber() + ")"));
                            break;
                        }
                        if (destNode == null) break block18;
                        orderSNSDirection = 1;
                        break block19;
                    }
                    if (srcNode == null) break block19;
                    orderSNSDirection = -1;
                    break block19;
                }
                if (destNode != null) {
                    stateData = sdata.clone();
                    stateData.setOrderNumber(sdata.getOrderNumber() + 1);
                    changes.add(ItemState.createUpdatedState((ItemData)stateData));
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("ORDER DOWN\t\t" + sdata.getQPath().getName() + "[" + sdata.getQPath().getIndex() + "] (" + sdata.getOrderNumber() + ") --> " + stateData.getQPath().getName() + "[" + stateData.getQPath().getIndex() + "] (" + stateData.getOrderNumber() + ")"));
                    continue;
                }
                if (srcNode != null) {
                    stateData = sdata.clone();
                    stateData.setOrderNumber(sdata.getOrderNumber() - 1);
                    changes.add(ItemState.createUpdatedState((ItemData)stateData));
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("ORDER UP\t\t" + sdata.getQPath().getName() + "[" + sdata.getQPath().getIndex() + "] (" + sdata.getOrderNumber() + ") --> " + stateData.getQPath().getName() + "[" + stateData.getQPath().getIndex() + "] (" + stateData.getOrderNumber() + ")"));
                    continue;
                }
            }
            if (orderSNSDirection == 0) continue;
            lastSourceSNSIndex = sdata.getQPath().getIndex();
            stateData = sdata.cloneAsSibling(lastSourceSNSIndex + orderSNSDirection);
            stateData.setOrderNumber(sdata.getOrderNumber() + orderSNSDirection);
            changes.add(ItemState.createUpdatedState((ItemData)stateData));
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("ORDER " + (orderSNSDirection == 1 ? "DOWN" : "UP") + " SNS\t" + sdata.getQPath().getName() + "[" + sdata.getQPath().getIndex() + "] (" + sdata.getOrderNumber() + ") --> " + stateData.getQPath().getName() + "[" + stateData.getQPath().getIndex() + "] (" + stateData.getOrderNumber() + ")"));
        }
        if (srcNode == null) {
            throw new ItemNotFoundException("Source node is not found " + sourcePath.getAsString(false));
        }
        if (destPath == null) {
            if (destNode != null) {
                log.warn((Object)("Dest node found but destPath == null, " + destNode.getQPath().getAsString()));
            }
            TransientNodeData stateData = lastSourceSNSIndex >= 0 ? srcNode.cloneAsSibling(lastSourceSNSIndex) : srcNode.clone();
            stateData.setOrderNumber(siblings.get(siblings.size() - 1).getOrderNumber());
            changes.add(ItemState.createUpdatedState((ItemData)stateData));
            changes.add(observationState.orderAddedState((ItemData)stateData));
            if (log.isDebugEnabled()) {
                log.debug((Object)("ORDER END\t\t" + srcNode.getQPath().getName() + "[" + srcNode.getQPath().getIndex() + "] (" + srcNode.getOrderNumber() + ") --> " + stateData.getQPath().getName() + "[" + stateData.getQPath().getIndex() + "] (" + stateData.getOrderNumber() + ")"));
            }
        }
        if (destPath != null && destNode == null) {
            throw new ItemNotFoundException("Destenation node is not found " + destenationPath.getAsString(false));
        }
        for (ItemState state : changes.getAllStates()) {
            this.dataManager.update(state, true);
        }
    }

    public void orderBefore(String srcName, String destName) throws UnsupportedRepositoryOperationException, ConstraintViolationException, ItemNotFoundException, RepositoryException {
        this.checkValid();
        if (!this.getPrimaryNodeType().hasOrderableChildNodes()) {
            throw new UnsupportedRepositoryOperationException("Node does not support child ordering " + this.getPrimaryNodeType().getName());
        }
        JCRPath sourcePath = this.locationFactory.createJCRPath(this.getLocation(), srcName);
        JCRPath destenationPath = destName != null ? this.locationFactory.createJCRPath(this.getLocation(), destName) : null;
        this.doOrderBefore(sourcePath, destenationPath);
    }

    private int getOrderNumber() {
        return this.nodeData().getOrderNumber();
    }

    public Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, RepositoryException {
        this.checkValid();
        if (!this.isNodeType(Constants.MIX_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node.checkin() is not supported for not mix:versionable node ");
        }
        if (!this.isCheckedOut()) {
            return this.getBaseVersion();
        }
        if (this.session.getTransientNodesManager().hasPendingChanges(this.getInternalPath())) {
            throw new InvalidItemStateException("Node has pending changes " + this.getPath());
        }
        if (this.hasProperty(Constants.JCR_MERGEFAILED)) {
            throw new VersionException("Node has jcr:mergeFailed " + this.getPath());
        }
        if (!this.parent().checkLocking()) {
            throw new LockException("Node " + this.parent().getPath() + " is locked ");
        }
        String verUuid = UUIDGenerator.generate();
        SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
        this.getVersionHistory().addVersion(this.nodeData(), verUuid, changesLog);
        changesLog.add(ItemState.createUpdatedState((ItemData)this.updatePropertyData(Constants.JCR_ISCHECKEDOUT, new TransientValueData(false))));
        changesLog.add(ItemState.createUpdatedState((ItemData)this.updatePropertyData(Constants.JCR_BASEVERSION, new TransientValueData(new Uuid(verUuid)))));
        changesLog.add(ItemState.createUpdatedState((ItemData)this.updatePropertyData(Constants.JCR_PREDECESSORS, new ArrayList<ValueData>())));
        this.dataManager.getTransactManager().save(changesLog);
        VersionImpl version = (VersionImpl)this.dataManager.getItemByUUID(verUuid, true);
        this.session.getActionHandler().postCheckin(this);
        return version;
    }

    public void checkout() throws RepositoryException, UnsupportedRepositoryOperationException {
        this.checkValid();
        if (!this.isNodeType(Constants.MIX_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node.checkout() is not supported for not mix:versionable node ");
        }
        if (this.isCheckedOut()) {
            return;
        }
        SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
        changesLog.add(ItemState.createUpdatedState((ItemData)this.updatePropertyData(Constants.JCR_ISCHECKEDOUT, new TransientValueData(true))));
        ValueData baseVersion = (ValueData)((PropertyData)this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_BASEVERSION))).getValues().get(0);
        changesLog.add(ItemState.createUpdatedState((ItemData)this.updatePropertyData(Constants.JCR_PREDECESSORS, baseVersion)));
        this.dataManager.getTransactManager().save(changesLog);
        this.session.getActionHandler().postCheckout(this);
    }

    public boolean isCheckedOut() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkValid();
        if (this.isRoot()) {
            return true;
        }
        if (this.isNodeType(Constants.MIX_VERSIONABLE)) {
            InternalQPath path = InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_ISCHECKEDOUT);
            return ((Property)this.dataManager.getItem(path, false)).getBoolean();
        }
        NodeImpl ancestor = (NodeImpl)this.getParent();
        while (!ancestor.isRoot()) {
            if (ancestor.isNodeType(Constants.MIX_VERSIONABLE)) {
                return ancestor.isCheckedOut();
            }
            ancestor = (NodeImpl)ancestor.getParent();
        }
        if (ancestor.isNodeType(Constants.MIX_VERSIONABLE)) {
            return ancestor.isCheckedOut();
        }
        return true;
    }

    public VersionHistoryImpl getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkValid();
        if (!this.isNodeType(Constants.MIX_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node is not mix:versionable " + this.getPath());
        }
        PropertyImpl versionHistoryProp = this.property(Constants.JCR_VERSIONHISTORY);
        if (versionHistoryProp == null) {
            throw new UnsupportedRepositoryOperationException("Node does not have jcr:versionHistory: " + this.getPath());
        }
        return (VersionHistoryImpl)this.session.getNodeByUUID(versionHistoryProp.getString());
    }

    public Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkValid();
        if (!this.isNodeType(Constants.MIX_VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException("Node is not versionable " + this.getPath());
        }
        Version v = (Version)this.session.getNodeByUUID(this.property(Constants.JCR_BASEVERSION).getString());
        return v;
    }

    public void restore(Version version, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException, InvalidItemStateException {
        this.checkValid();
        try {
            if (!this.isNodeType(Constants.MIX_VERSIONABLE)) {
                throw new UnsupportedRepositoryOperationException("Node is not versionable " + this.getPath());
            }
            if (this.session.hasPendingChanges()) {
                throw new InvalidItemStateException("Session has pending changes ");
            }
            if (((VersionImpl)version).getInternalName().equals((Object)Constants.JCR_ROOTVERSION)) {
                throw new VersionException("It is illegal to call restore() on jcr:rootVersion");
            }
            if (!this.getVersionHistory().isVersionBelongToThis(version)) {
                throw new VersionException("Bad version " + version.getPath());
            }
            if (!this.checkLocking()) {
                throw new LockException("Node " + this.getPath() + " is locked ");
            }
            ((VersionImpl)version).restore(this, removeExisting);
        }
        catch (UnsupportedRepositoryOperationException e) {
            throw e;
        }
        catch (VersionException e) {
            throw e;
        }
        catch (InvalidItemStateException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw e;
        }
    }

    public void restore(String versionName, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException, InvalidItemStateException {
        this.checkValid();
        VersionImpl version = (VersionImpl)this.getVersionHistory().getVersion(versionName);
        this.restore(version, removeExisting);
    }

    public void restore(Version version, String relPath, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException, InvalidItemStateException {
        NodeImpl node;
        this.checkValid();
        InternalQPath newPath = this.locationFactory.createJCRPath(this.getLocation(), relPath).getInternalPath();
        try {
            node = (NodeImpl)this.dataManager.getItem(newPath, true);
        }
        catch (PathNotFoundException e) {
            NodeData parentData = (NodeData)this.dataManager.getItemData(newPath.makeParentPath());
            TransientNodeData nodeData = TransientNodeData.createNodeData(parentData, newPath.getName(), Constants.NT_BASE);
            this.dataManager.update(ItemState.createAddedState((ItemData)nodeData), true);
            node = (NodeImpl)this.dataManager.getItem(newPath, true);
        }
        node.restore(version, removeExisting);
    }

    public void restoreByLabel(String versionLabel, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException, InvalidItemStateException {
        this.checkValid();
        VersionImpl version = (VersionImpl)this.getVersionHistory().getVersionByLabel(versionLabel);
        this.restore(version, removeExisting);
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws UnsupportedRepositoryOperationException, NoSuchWorkspaceException, AccessDeniedException, MergeException, RepositoryException, InvalidItemStateException {
        this.checkValid();
        if (this.session.hasPendingChanges()) {
            throw new InvalidItemStateException("Session has pending changes ");
        }
        HashMap<String, String> failed = new HashMap<String, String>();
        SessionImpl corrSession = ((RepositoryImpl)this.session.getRepository()).login(this.session.getCredentials(), srcWorkspace);
        ItemDataMergeVisitor visitor = new ItemDataMergeVisitor(this.session, corrSession, failed, bestEffort);
        this.nodeData().accept((ItemDataVisitor)visitor);
        SessionChangesLog changes = visitor.getMergeChanges();
        EntityCollection failedIter = this.createMergeFailed(failed, changes);
        if (changes.getSize() > 0) {
            this.dataManager.getTransactManager().save(changes);
        }
        return failedIter;
    }

    private EntityCollection createMergeFailed(Map<String, String> failed, SessionChangesLog changes) throws RepositoryException {
        EntityCollection res = new EntityCollection();
        TransientPropertyData mergeFailed = (TransientPropertyData)this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_MERGEFAILED));
        ArrayList<ValueData> mergeFailedRefs = null;
        int state = 0;
        if (mergeFailed != null) {
            mergeFailed = mergeFailed.clone();
            mergeFailedRefs = mergeFailed.getValues();
            state = 2;
        } else {
            mergeFailedRefs = new ArrayList();
            mergeFailed = TransientPropertyData.createPropertyData((NodeData)this.getData(), Constants.JCR_MERGEFAILED, 9, true, mergeFailedRefs);
            state = 1;
        }
        block2: for (String uuid : failed.keySet()) {
            NodeImpl versionable = (NodeImpl)this.session.getNodeByUUID(uuid);
            res.add(versionable);
            String offendingUuid = failed.get(uuid);
            for (ValueData vd : mergeFailedRefs) {
                try {
                    String mfUuid = new String(vd.getAsByteArray());
                    if (!mfUuid.equals(offendingUuid)) continue;
                    continue block2;
                }
                catch (IOException e) {
                    throw new RepositoryException("jcr:mergeFailed read error " + e, (Throwable)e);
                }
            }
            mergeFailedRefs.add(new TransientValueData(offendingUuid));
        }
        changes.add(new ItemState((ItemData)mergeFailed, state, true, this.getInternalPath(), true));
        return res;
    }

    public NodeIterator merge_old(String srcWorkspace, boolean bestEffort) throws UnsupportedRepositoryOperationException, NoSuchWorkspaceException, AccessDeniedException, MergeException, RepositoryException, InvalidItemStateException {
        this.checkValid();
        if (this.session.hasPendingChanges()) {
            throw new InvalidItemStateException("Session has pending changes ");
        }
        HashMap<String, String> failed = new HashMap<String, String>();
        SessionImpl corrSession = ((RepositoryImpl)this.session.getRepository()).login(this.session.getCredentials(), srcWorkspace);
        NodeImpl corrNode = null;
        try {
            corrNode = this.getCorrespondingNode(corrSession);
        }
        catch (ItemNotFoundException e) {
            log.debug((Object)("No corresponding node in workspace: " + srcWorkspace));
            return new EntityCollection();
        }
        MergeVisitor visitor = new MergeVisitor(this, failed, bestEffort);
        corrNode.accept((ItemVisitor)visitor);
        MutableItemDataChangesLog changesLog = new SessionChangesLog(this.session.getId()).add(ItemState.createAddedState((ItemData)this.getData()));
        this.dataManager.getTransactManager().save(changesLog);
        NodeIterator failedIter = this.createMergeFailed(failed);
        return failedIter;
    }

    private NodeIterator createMergeFailed(Map<String, String> failed) throws RepositoryException {
        EntityCollection res = new EntityCollection();
        for (String uuid : failed.keySet()) {
            NodeImpl versionable = (NodeImpl)this.session.getNodeByUUID(uuid);
            res.add(versionable);
            String offendingUuid = failed.get(uuid);
            List mergeFailedRefs = new ArrayList();
            try {
                mergeFailedRefs = ((PropertyData)this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_MERGEFAILED))).getValues();
            }
            catch (PathNotFoundException e) {
                // empty catch block
            }
            ArrayList<ValueData> newMergeFailedRefs = new ArrayList<ValueData>();
            for (ValueData vd : mergeFailedRefs) {
                Value val = this.valueFactory.loadValue((TransientValueData)vd, 9);
                if (!val.getString().equals(offendingUuid)) continue;
                newMergeFailedRefs = null;
                break;
            }
            if (newMergeFailedRefs == null) continue;
            newMergeFailedRefs.add(new TransientValueData(offendingUuid));
            SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
            TransientPropertyData mergeFailed = TransientPropertyData.createPropertyData((NodeData)this.getData(), Constants.JCR_MERGEFAILED, 9, true, newMergeFailedRefs);
            changesLog.add(ItemState.createUpdatedState((ItemData)mergeFailed));
            this.dataManager.getTransactManager().save(changesLog);
        }
        return res;
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
        VersionImpl base = (VersionImpl)this.getBaseVersion();
        base.addPredecessor(version.getUUID(), changesLog);
        this.removeMergeFailed(version, changesLog);
        this.dataManager.getTransactManager().save(changesLog);
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.checkValid();
        SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
        this.removeMergeFailed(version, changesLog);
        this.dataManager.getTransactManager().save(changesLog);
    }

    private void removeMergeFailed(Version version, MutableItemDataChangesLog changesLog) throws RepositoryException {
        TransientPropertyData mergeFailed = (TransientPropertyData)this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_MERGEFAILED));
        if (mergeFailed == null) {
            return;
        }
        ArrayList<ValueData> mf = new ArrayList<ValueData>();
        for (ValueData mfvd : mergeFailed.getValues()) {
            try {
                String mfUuid = new String(mfvd.getAsByteArray());
                if (mfUuid.equals(version.getUUID())) continue;
                mf.add(mfvd);
            }
            catch (IOException e) {
                throw new RepositoryException("Remove jcr:mergeFailed error " + e, (Throwable)e);
            }
        }
        if (mf.size() > 0) {
            TransientPropertyData mergeFailedRef = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_MERGEFAILED, 9, true, mf);
            changesLog.add(ItemState.createUpdatedState((ItemData)mergeFailedRef));
        } else {
            changesLog.add(ItemState.createDeletedState((ItemData)mergeFailed.clone(), (boolean)true));
        }
    }

    public Lock lock(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        this.checkValid();
        if (!this.isNodeType(Constants.MIX_LOCKABLE)) {
            throw new LockException("Node is not lockable " + this.getPath());
        }
        LockImpl lock = this.session.getLockManager().getLock(this, false);
        if (lock != null) {
            throw new LockException("Node is already locked " + this.getPath() + " on " + lock.getNode().getPath());
        }
        if (isDeep && this.session.getLockManager().getChildLock(this) != null) {
            throw new LockException("Lock is deep and node already has locked child " + this.getPath());
        }
        if (this.dataManager.hasPendingChanges(this.getInternalPath())) {
            throw new InvalidItemStateException("Node has pending unsaved changes " + this.getPath());
        }
        SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
        TransientPropertyData propData = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_LOCKOWNER, 1, false, new TransientValueData(this.session.getUserID()));
        changesLog.add(ItemState.createAddedState((ItemData)propData));
        propData = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_LOCKISDEEP, 6, false, new TransientValueData(isDeep));
        changesLog.add(ItemState.createAddedState((ItemData)propData));
        this.dataManager.getTransactManager().save(changesLog);
        Lock newLock = this.session.getLockManager().addLock(this, isDeep, isSessionScoped);
        this.session.getActionHandler().postLock(this);
        return newLock;
    }

    protected Lock lockInSession(boolean isDeep, boolean isSessionScoped) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        if (!this.isNodeType(Constants.MIX_LOCKABLE)) {
            throw new LockException("Node is not lockable " + this.getPath());
        }
        LockImpl lock = this.session.getLockManager().getLock(this, false);
        if (lock != null) {
            throw new LockException("Node is already locked " + this.getPath() + " on " + lock.getNode().getPath());
        }
        if (isDeep && this.session.getLockManager().getChildLock(this) != null) {
            throw new LockException("Lock is deep and node already has locked child " + this.getPath());
        }
        if (this.dataManager.hasPendingChanges(this.getInternalPath())) {
            throw new InvalidItemStateException("Node has pending unsaved changes " + this.getPath());
        }
        TransientPropertyData propData = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_LOCKOWNER, 1, false, new TransientValueData(this.session.getUserID()));
        this.dataManager.update(ItemState.createAddedState((ItemData)propData), true);
        propData = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_LOCKISDEEP, 6, false, new TransientValueData(isDeep));
        this.dataManager.update(ItemState.createAddedState((ItemData)propData), true);
        Lock newLock = this.session.getLockManager().addLock(this, isDeep, isSessionScoped);
        return newLock;
    }

    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        this.checkValid();
        LockImpl lock = this.session.getLockManager().getLock(this, false);
        if (lock == null) {
            throw new LockException("Lock not found " + this.getPath());
        }
        return lock;
    }

    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        this.checkValid();
        if (!this.session.hasLockToken(this.session.getLockManager().getLockToken(this))) {
            throw new LockException("There are no permission to unlock the node or node is not locked " + this.getPath());
        }
        if (this.dataManager.hasPendingChanges(this.getInternalPath())) {
            throw new InvalidItemStateException("Node has pending unsaved changes " + this.getPath());
        }
        SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
        ItemData lockOwner = this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_LOCKOWNER));
        changesLog.add(ItemState.createDeletedState((ItemData)lockOwner));
        ItemData lockIsDeep = this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_LOCKISDEEP));
        changesLog.add(ItemState.createDeletedState((ItemData)lockIsDeep));
        this.dataManager.getTransactManager().save(changesLog);
        this.session.getLockManager().removeLock(this);
        this.session.getActionHandler().postUnlock(this);
    }

    protected void unlockInSession() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        ItemData lockIsDeep;
        if (!this.session.hasLockToken(this.session.getLockManager().getLockToken(this))) {
            throw new LockException("There are no permission to unlock the node or node is not locked " + this.getPath());
        }
        if (this.dataManager.hasPendingChanges(this.getInternalPath())) {
            throw new InvalidItemStateException("Node has pending unsaved changes " + this.getPath());
        }
        ItemData lockOwner = this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_LOCKOWNER));
        if (lockOwner != null) {
            this.dataManager.delete(lockOwner);
        }
        if ((lockIsDeep = this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.JCR_LOCKISDEEP))) != null) {
            this.dataManager.delete(lockIsDeep);
        }
        this.session.getLockManager().removeLock(this);
    }

    public boolean holdsLock() throws RepositoryException {
        this.checkValid();
        return this.session.getLockManager().getLock(this, true) != null;
    }

    public boolean isLocked() throws RepositoryException {
        this.checkValid();
        return this.session.getLockManager().getLock(this, false) != null;
    }

    boolean checkLocking() throws RepositoryException {
        return !this.isLocked() || this.session.hasLockToken(this.session.getLockManager().getLockToken(this)) || this.session.getUserID().equals("__system");
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.checkValid();
        visitor.visit((Node)this);
    }

    public boolean isNode() {
        return true;
    }

    public void addAutoCreatedItems(InternalQName nodeTypeName) throws RepositoryException, ConstraintViolationException {
        int i;
        ExtendedNodeType type = this.nodeType(nodeTypeName);
        NodeDefinition[] nodeDefs = type.getChildNodeDefinitions();
        PropertyDefinition[] propDefs = type.getPropertyDefinitions();
        for (i = 0; i < propDefs.length; ++i) {
            if (propDefs[i] == null || !propDefs[i].isAutoCreated()) continue;
            PropertyDefinitionImpl pdImpl = (PropertyDefinitionImpl)propDefs[i];
            if (!this.hasProperty(pdImpl.getQName())) {
                this.dataManager.update(ItemState.createAddedState((ItemData)TransientPropertyData.createPropertyData(this.nodeData(), pdImpl.getQName(), pdImpl.getRequiredType(), pdImpl.isMultiple(), this.autoCreatedValue(type, pdImpl))), true);
                continue;
            }
            log.warn((Object)("Duplicate property " + pdImpl.getName() + " for node " + this.getName() + " skeepd for mixin " + nodeTypeName.getName()));
        }
        for (i = 0; i < nodeDefs.length; ++i) {
            if (!nodeDefs[i].isAutoCreated()) continue;
            NodeDefinitionImpl ndImpl = (NodeDefinitionImpl)nodeDefs[i];
            this.dataManager.update(ItemState.createAddedState((ItemData)TransientNodeData.createNodeData(this.nodeData(), ndImpl.getQName(), ((ExtendedNodeType)ndImpl.getDefaultPrimaryType()).getQName(), UUIDGenerator.generate())), true);
        }
        if (type.isNodeType(Constants.MIX_VERSIONABLE)) {
            this.initVersionable();
        }
    }

    private List<ValueData> autoCreatedValue(ExtendedNodeType type, PropertyDefinitionImpl def) throws RepositoryException {
        ArrayList<ValueData> vals = new ArrayList<ValueData>();
        if (type.isNodeType(Constants.NT_BASE) && def.getQName().equals((Object)Constants.JCR_PRIMARYTYPE)) {
            vals.add(new TransientValueData(this.nodeData().getPrimaryTypeName()));
        } else if (type.isNodeType(Constants.MIX_REFERENCEABLE) && def.getQName().equals((Object)Constants.JCR_UUID)) {
            vals.add(new TransientValueData(this.nodeData().getUUID()));
        } else if (type.isNodeType(Constants.NT_HIERARCHYNODE) && def.getQName().equals((Object)Constants.JCR_CREATED)) {
            vals.add(new TransientValueData(this.dataManager.getTransactManager().getStorageDataManager().getCurrentTime()));
        } else if (type.isNodeType(Constants.EXO_OWNEABLE) && def.getQName().equals((Object)Constants.EXO_OWNER)) {
            String owner = this.session.getUserID();
            vals.add(new TransientValueData(owner));
            this.setACL(new AccessControlList(owner, this.getACL().getPermissionEntries()));
        } else if (type.isNodeType(Constants.EXO_PRIVILEGEABLE) && def.getQName().equals((Object)Constants.EXO_PERMISSIONS)) {
            AccessControlList superACL = this.getACL();
            if (this.parent() != null && this.parent().getACL() != null) {
                superACL = this.parent().getACL();
            }
            for (AccessControlEntry ace : superACL.getPermissionEntries()) {
                vals.add(new TransientValueData(ace));
            }
            String owner = this.getACL().getOwner() != null ? this.getACL().getOwner() : superACL.getOwner();
            this.setACL(new AccessControlList(owner, superACL.getPermissionEntries()));
        } else {
            Value[] propVal = def.getDefaultValues();
            if (propVal != null) {
                for (Value v : propVal) {
                    if (v != null) {
                        vals.add(((BaseValue)v).getInternalData());
                        continue;
                    }
                    vals.add(null);
                }
            }
        }
        return vals;
    }

    private void initVersionable() throws RepositoryException {
        String versionHistoryUuid = UUIDGenerator.generate();
        String baseVersionUuid = UUIDGenerator.generate();
        NodeData versionStorageData = (NodeData)this.dataManager.getItemData(Constants.JCR_VERSION_STORAGE_PATH);
        InternalQName vhName = new InternalQName(null, this.nodeData().getUUID());
        TransientNodeData versionHistory = TransientNodeData.createNodeData(versionStorageData, vhName, Constants.NT_VERSIONHISTORY);
        versionHistory.setUUID(versionHistoryUuid);
        TransientPropertyData vhPrimaryType = TransientPropertyData.createPropertyData((NodeData)versionHistory, Constants.JCR_PRIMARYTYPE, 7, false);
        vhPrimaryType.setValue(new TransientValueData(versionHistory.getPrimaryTypeName()));
        TransientPropertyData vhUuid = TransientPropertyData.createPropertyData((NodeData)versionHistory, Constants.JCR_UUID, 1, false);
        vhUuid.setValue(new TransientValueData(versionHistoryUuid));
        TransientPropertyData vhVersionableUuid = TransientPropertyData.createPropertyData((NodeData)versionHistory, Constants.JCR_VERSIONABLEUUID, 9, false);
        vhVersionableUuid.setValue(new TransientValueData(new Uuid(this.nodeData().getUUID())));
        TransientNodeData vhVersionLabels = TransientNodeData.createNodeData((NodeData)versionHistory, Constants.JCR_VERSIONLABELS, Constants.NT_VERSIONLABELS);
        TransientPropertyData vlPrimaryType = TransientPropertyData.createPropertyData((NodeData)vhVersionLabels, Constants.JCR_PRIMARYTYPE, 7, false);
        vlPrimaryType.setValue(new TransientValueData(vhVersionLabels.getPrimaryTypeName()));
        TransientNodeData rootVersionData = TransientNodeData.createNodeData((NodeData)versionHistory, Constants.JCR_ROOTVERSION, Constants.NT_VERSION, baseVersionUuid);
        TransientPropertyData rvPrimaryType = TransientPropertyData.createPropertyData((NodeData)rootVersionData, Constants.JCR_PRIMARYTYPE, 7, false);
        rvPrimaryType.setValue(new TransientValueData(rootVersionData.getPrimaryTypeName()));
        TransientPropertyData rvUuid = TransientPropertyData.createPropertyData((NodeData)rootVersionData, Constants.JCR_UUID, 1, false);
        rvUuid.setValue(new TransientValueData(baseVersionUuid));
        TransientPropertyData rvMixinTypes = TransientPropertyData.createPropertyData((NodeData)rootVersionData, Constants.JCR_MIXINTYPES, 7, true);
        rvMixinTypes.setValue(new TransientValueData(Constants.MIX_REFERENCEABLE));
        TransientPropertyData rvCreated = TransientPropertyData.createPropertyData((NodeData)rootVersionData, Constants.JCR_CREATED, 5, false);
        rvCreated.setValue(new TransientValueData(this.dataManager.getTransactManager().getStorageDataManager().getCurrentTime()));
        TransientPropertyData vh = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_VERSIONHISTORY, 9, false);
        vh.setValue(new TransientValueData(new Uuid(versionHistoryUuid)));
        TransientPropertyData bv = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_BASEVERSION, 9, false);
        bv.setValue(new TransientValueData(new Uuid(baseVersionUuid)));
        TransientPropertyData pd = TransientPropertyData.createPropertyData(this.nodeData(), Constants.JCR_PREDECESSORS, 9, true);
        pd.setValue(new TransientValueData(new Uuid(baseVersionUuid)));
        this.dataManager.update(new ItemState((ItemData)versionHistory, 1, true, this.getInternalPath()), false);
        this.dataManager.update(new ItemState((ItemData)vhPrimaryType, 1, true, this.getInternalPath()), false);
        this.dataManager.update(new ItemState((ItemData)vhUuid, 1, true, this.getInternalPath()), false);
        this.dataManager.update(new ItemState((ItemData)vhVersionableUuid, 1, true, this.getInternalPath()), false);
        this.dataManager.update(new ItemState((ItemData)vhVersionLabels, 1, true, this.getInternalPath()), false);
        this.dataManager.update(new ItemState((ItemData)vlPrimaryType, 1, true, this.getInternalPath()), false);
        this.dataManager.update(new ItemState((ItemData)rootVersionData, 1, true, this.getInternalPath()), false);
        this.dataManager.update(new ItemState((ItemData)rvPrimaryType, 1, true, this.getInternalPath()), false);
        this.dataManager.update(new ItemState((ItemData)rvMixinTypes, 1, true, this.getInternalPath()), false);
        this.dataManager.update(new ItemState((ItemData)rvUuid, 1, true, this.getInternalPath()), false);
        this.dataManager.update(new ItemState((ItemData)rvCreated, 1, true, this.getInternalPath()), false);
        this.dataManager.update(ItemState.createAddedState((ItemData)vh), true);
        this.dataManager.update(ItemState.createAddedState((ItemData)bv), true);
        this.dataManager.update(ItemState.createAddedState((ItemData)pd), true);
    }

    public String[] getMixinTypeNames() throws RepositoryException {
        NodeType[] mixinTypes = this.getMixinNodeTypes();
        String[] mtNames = new String[mixinTypes.length];
        for (int i = 0; i < mtNames.length; ++i) {
            mtNames[i] = mixinTypes[i].getName();
        }
        return mtNames;
    }

    public void validateMandatoryChildren() throws ConstraintViolationException, AccessDeniedException, RepositoryException {
        ArrayList mandatoryItemDefs = ((ExtendedNodeType)this.getPrimaryNodeType()).getManadatoryItemDefs();
        NodeType[] mixinTypes = this.getMixinNodeTypes();
        for (int i = 0; i < mixinTypes.length; ++i) {
            mandatoryItemDefs.addAll(((ExtendedNodeType)mixinTypes[i]).getManadatoryItemDefs());
        }
        for (ItemDefinition def : mandatoryItemDefs) {
            if ((!(def instanceof NodeDefinition) || this.hasNode(def.getName())) && (!(def instanceof PropertyDefinition) || this.hasProperty(def.getName()))) continue;
            throw new ConstraintViolationException("Mandatory item " + def.getName() + " not found. Node [" + this.getPath() + " primary type: " + this.getPrimaryNodeType().getName() + "]");
        }
    }

    public void setPermissions(Map permissions) throws RepositoryException, AccessDeniedException, AccessControlException {
        if (!this.isNodeType(Constants.EXO_PRIVILEGEABLE)) {
            throw new AccessControlException("Node is not exo:privilegeable " + this.getPath());
        }
        if (permissions.size() == 0) {
            throw new RepositoryException(" Permission size cannot be 0");
        }
        this.checkPermission("add_node,set_property,remove");
        ArrayList<AccessControlEntry> aces = new ArrayList<AccessControlEntry>();
        for (String identity : permissions.keySet()) {
            String[] perm = (String[])permissions.get(identity);
            for (int j = 0; j < perm.length; ++j) {
                AccessControlEntry ace = new AccessControlEntry(identity, perm[j]);
                aces.add(ace);
            }
        }
        AccessControlList acl = new AccessControlList(this.getACL().getOwner(), aces);
        this.updatePermissions(acl);
        this.setACL(acl);
    }

    private void updatePermissions(AccessControlList acl) throws RepositoryException {
        ArrayList<ValueData> permValues = new ArrayList<ValueData>();
        List aces = acl.getPermissionEntries();
        for (AccessControlEntry ace : aces) {
            TransientValueData vd = new TransientValueData(ace);
            permValues.add(vd);
        }
        TransientPropertyData permProp = (TransientPropertyData)this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getInternalPath(), (InternalQName)Constants.EXO_PERMISSIONS));
        permProp = new TransientPropertyData(permProp.getQPath(), permProp.getUUID(), permProp.getPersistedVersion(), permProp.getType(), permProp.getParentUUID(), permProp.isMultiValued());
        permProp.setValues(permValues);
        this.dataManager.update(new ItemState(this.getData(), 8, false, null, true), true);
        this.dataManager.update(ItemState.createUpdatedState((ItemData)permProp, (boolean)true), true);
    }

    public AccessControlList getACL() throws RepositoryException {
        this.checkValid();
        return ((NodeData)this.data).getACL();
    }

    private void setACL(AccessControlList acl) {
        ((NodeData)this.data).setACL(acl);
    }

    public void clearACL() throws RepositoryException, AccessControlException {
        if (!this.isNodeType(Constants.EXO_PRIVILEGEABLE)) {
            throw new AccessControlException("Node is not exo:privilegeable " + this.getPath());
        }
        this.checkPermission("add_node,set_property,remove");
        ArrayList<AccessControlEntry> aces = new ArrayList<AccessControlEntry>();
        for (String perm : PermissionType.ALL) {
            AccessControlEntry ace = new AccessControlEntry("any", perm);
            aces.add(ace);
        }
        AccessControlList acl = new AccessControlList(this.getACL().getOwner(), aces);
        this.setACL(acl);
    }

    public void removePermission(String identity) throws RepositoryException, AccessControlException {
        if (!this.isNodeType(Constants.EXO_PRIVILEGEABLE)) {
            throw new AccessControlException("Node is not exo:privilegeable " + this.getPath());
        }
        this.checkPermission("add_node,set_property,remove");
        AccessControlList acl = new AccessControlList(this.getACL().getOwner(), this.getACL().getPermissionEntries());
        acl.removePermissions(identity);
        this.updatePermissions(acl);
        this.setACL(acl);
    }

    public void setPermission(String identity, String[] permission) throws RepositoryException, AccessControlException {
        if (!this.isNodeType(Constants.EXO_PRIVILEGEABLE)) {
            throw new AccessControlException("Node is not exo:privilegeable " + this.getPath());
        }
        this.checkPermission("add_node,set_property,remove");
        AccessControlList acl = new AccessControlList(this.getACL().getOwner(), this.getACL().getPermissionEntries());
        acl.addPermissions(identity, permission);
        this.updatePermissions(acl);
        this.setACL(acl);
    }

    public void checkPermission(String actions) throws AccessControlException, RepositoryException {
        this.checkValid();
        if (!this.session.getAccessManager().hasPermission(this.getACL(), actions, this.session.getUserID())) {
            throw new AccessControlException("Permission denied " + this.getPath() + " : " + actions);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof NodeImpl) {
            NodeImpl otherNode = (NodeImpl)obj;
            if (!otherNode.isValid() || !this.isValid()) {
                return false;
            }
            try {
                if (otherNode.isNodeType("mix:referenceable") && this.isNodeType("mix:referenceable")) {
                    return this.getInternalUUID().equals(otherNode.getInternalUUID());
                }
                return this.getLocation().equals(otherNode.getLocation());
            }
            catch (RepositoryException e) {
                return false;
            }
        }
        return false;
    }

    private ExtendedNodeType nodeType(InternalQName qName) throws NoSuchNodeTypeException, RepositoryException {
        return this.session.getWorkspace().getNodeTypeManager().getNodeType(qName);
    }

    public NodeType[] getAllNodeTypes() throws RepositoryException {
        ExtendedNodeType primaryType = this.nodeType(this.nodeData().getPrimaryTypeName());
        InternalQName[] mixinNames = this.nodeData().getMixinTypeNames();
        NodeType[] nodeTypes = new NodeType[mixinNames.length + 1];
        nodeTypes[0] = primaryType;
        for (int i = 1; i <= mixinNames.length; ++i) {
            nodeTypes[i] = this.nodeType(mixinNames[i - 1]);
        }
        return nodeTypes;
    }

    protected NodeData nodeData() {
        return (NodeData)this.data;
    }

    protected PropertyData updatePropertyData(InternalQName name, ValueData value) throws RepositoryException {
        return this.updatePropertyData(this.getInternalPath(), name, value);
    }

    protected PropertyData updatePropertyData(InternalQPath parentPath, InternalQName name, ValueData value) throws RepositoryException {
        InternalQPath path = InternalQPath.makeChildPath((InternalQPath)parentPath, (InternalQName)name);
        PropertyData existed = (PropertyData)this.dataManager.getItemData(path);
        if (existed != null) {
            TransientPropertyData tdata = new TransientPropertyData(path, existed.getUUID(), existed.getPersistedVersion(), existed.getType(), existed.getParentUUID(), existed.isMultiValued());
            tdata.setValue(value);
            return tdata;
        }
        throw new RepositoryException("Property data is not found " + path.getAsString());
    }

    protected PropertyData updatePropertyData(InternalQName name, List<ValueData> values) throws RepositoryException {
        return this.updatePropertyData(this.getInternalPath(), name, values);
    }

    protected PropertyData updatePropertyData(InternalQPath parentPath, InternalQName name, List<ValueData> values) throws ValueFormatException, RepositoryException {
        InternalQPath path = InternalQPath.makeChildPath((InternalQPath)parentPath, (InternalQName)name);
        PropertyData existed = (PropertyData)this.dataManager.getItemData(path);
        if (existed != null) {
            TransientPropertyData tdata = new TransientPropertyData(path, existed.getUUID(), existed.getPersistedVersion(), existed.getType(), existed.getParentUUID(), existed.isMultiValued());
            if (!existed.isMultiValued()) {
                throw new ValueFormatException("An existed property is single-valued " + path.getAsString());
            }
            tdata.setValues(values);
            return tdata;
        }
        throw new RepositoryException("Property data is not found " + path.getAsString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertiesOrderComparator
    implements Comparator<PropertyImpl> {
        private PropertiesOrderComparator() {
        }

        @Override
        public int compare(PropertyImpl p1, PropertyImpl p2) {
            int r = 0;
            try {
                InternalQName qname1 = p1.getLocation().getName().getInternalName();
                InternalQName qname2 = p2.getLocation().getName().getInternalName();
                r = qname1.equals((Object)Constants.JCR_PRIMARYTYPE) ? Integer.MIN_VALUE : (qname2.equals((Object)Constants.JCR_PRIMARYTYPE) ? Integer.MAX_VALUE : (qname1.equals((Object)Constants.JCR_MIXINTYPES) ? -2147483647 : (qname2.equals((Object)Constants.JCR_MIXINTYPES) ? 0x7FFFFFFE : (qname1.equals((Object)Constants.JCR_UUID) ? -2147483646 : (qname2.equals((Object)Constants.JCR_UUID) ? 0x7FFFFFFD : qname1.getAsString().compareTo(qname2.getAsString()))))));
            }
            catch (Exception e) {
                log.error((Object)("PropertiesOrderComparator error: " + e), (Throwable)e);
            }
            return r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodesOrderComparator
    implements Comparator<NodeImpl> {
        private NodesOrderComparator() {
        }

        @Override
        public int compare(NodeImpl n1, NodeImpl n2) {
            return n1.getOrderNumber() - n2.getOrderNumber();
        }
    }
}

