/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.version.VersionHistoryImpl;
import org.exoplatform.services.jcr.impl.core.version.VersionImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.jcr.impl.dataflow.session.WorkspaceStorageDataManagerProxy;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionDataManager
implements ItemDataConsumer {
    public static final int MERGE_NODES = 1;
    public static final int MERGE_PROPS = 2;
    public static final int MERGE_ITEMS = 3;
    protected static Log log = ExoLogger.getLogger((String)"jcr.SessionDataManager");
    protected final SessionImpl session;
    protected final ItemReferencePool itemsPool;
    protected final List<ItemImpl> invalidated = new ArrayList<ItemImpl>();
    private final SessionChangesLog changesLog;
    protected final SessionItemFactory itemFactory;
    protected final AccessManager accessManager;
    protected final TransactionableDataManager transactionableManager;

    public SessionDataManager(SessionImpl session, LocalWorkspaceDataManagerStub dataManager) throws RepositoryException {
        this.session = session;
        this.changesLog = new SessionChangesLog(session.getId());
        this.itemsPool = new ItemReferencePool();
        this.itemFactory = new SessionItemFactory();
        this.accessManager = session.getAccessManager();
        this.transactionableManager = new TransactionableDataManager(dataManager, session);
    }

    public WorkspaceStorageDataManagerProxy getWorkspaceDataManager() {
        return this.transactionableManager.getStorageDataManager();
    }

    public String dump() {
        String d = "\nChanges:";
        d = d + this.changesLog.dump();
        d = d + "\nCache:";
        d = d + this.itemsPool.dump();
        return d;
    }

    public TransactionableDataManager getTransactManager() {
        return this.transactionableManager;
    }

    public ItemData getItemData(InternalQPath path) throws RepositoryException {
        ItemData data = null;
        ItemState state = this.changesLog.getItemState(path);
        if (state == null) {
            data = this.transactionableManager.getItemData(path);
        } else if (!state.isDeleted()) {
            data = state.getData();
        }
        return data;
    }

    public ItemImpl getItem(InternalQPath path, boolean pool) throws RepositoryException {
        ItemData itemData = this.getItemData(path);
        if (itemData == null) {
            return null;
        }
        ItemImpl item = this.itemFactory.createItem(itemData);
        if (!item.hasPermission("read")) {
            throw new AccessDeniedException("Access denied " + path.getAsString() + " for " + this.session.getUserID() + " (get item by path)");
        }
        if (pool) {
            return this.itemsPool.get(item);
        }
        return item;
    }

    public ItemData getItemData(String uuid) throws RepositoryException {
        ItemData data = null;
        ItemState state = this.changesLog.getItemState(uuid);
        if (state == null) {
            data = this.transactionableManager.getItemData(uuid);
        } else if (!state.isDeleted()) {
            data = state.getData();
        }
        return data;
    }

    public ItemImpl getItemByUUID(String uuid, boolean pool) throws RepositoryException {
        ItemData itemData = this.getItemData(uuid);
        if (itemData == null) {
            return null;
        }
        ItemImpl item = this.itemFactory.createItem(itemData);
        if (!item.hasPermission("read")) {
            throw new AccessDeniedException("Access denied, item with id : " + item.getPath() + " (get item by UUID), user " + this.session.getUserID() + " has no privileges on reading");
        }
        if (pool) {
            return this.itemsPool.get(item);
        }
        return item;
    }

    public boolean hasPendingChanges(InternalQPath path) {
        return this.changesLog.getDescendantsChanges(path).size() > 0;
    }

    public boolean isNew(String uuid) {
        ItemState lastState;
        List states = this.changesLog.getItemStates(uuid);
        ItemState itemState = lastState = states.size() > 0 ? (ItemState)states.get(states.size() - 1) : null;
        if (lastState == null || lastState.isDeleted()) {
            return false;
        }
        for (ItemState state : states) {
            if (!state.isAdded()) continue;
            return true;
        }
        return false;
    }

    public boolean isModified(ItemData item) {
        if (item.isNode()) {
            Collection<ItemState> nodeChanges = this.changesLog.getLastModifyStates((NodeData)item);
            return nodeChanges.size() > 0;
        }
        List states = this.changesLog.getItemStates(item.getUUID());
        if (states.size() > 0) {
            ItemState lastState = (ItemState)states.get(states.size() - 1);
            return !lastState.isAdded() && !lastState.isDeleted();
        }
        return false;
    }

    List<PropertyImpl> getReferences(String uuid) throws RepositoryException {
        ArrayList<PropertyImpl> refs = new ArrayList<PropertyImpl>();
        for (PropertyData data : this.transactionableManager.getReferencesData(uuid)) {
            refs.add((PropertyImpl)this.itemFactory.createItem((ItemData)data));
        }
        return refs;
    }

    public List<NodeImpl> getChildNodes(NodeData parent, boolean pool) throws RepositoryException, AccessDeniedException {
        ArrayList<NodeImpl> nodes = new ArrayList<NodeImpl>();
        List<NodeData> nodeDatas = this.getChildNodesData(parent);
        for (NodeData data : nodeDatas) {
            if (!this.accessManager.hasPermission(data.getACL(), "read", this.session.getUserID())) continue;
            NodeImpl item = this.itemFactory.createNode(data);
            if (pool) {
                item = (NodeImpl)this.itemsPool.get(item);
            }
            nodes.add(item);
        }
        return nodes;
    }

    public List<PropertyImpl> getChildProperties(NodeData parent, boolean pool) throws RepositoryException, AccessDeniedException {
        ArrayList<PropertyImpl> props = new ArrayList<PropertyImpl>();
        for (PropertyData data : this.getChildPropertiesData(parent)) {
            if (!this.accessManager.hasPermission(parent.getACL(), "read", this.session.getUserID())) continue;
            ItemImpl item = this.itemFactory.createItem((ItemData)data);
            if (pool) {
                item = this.itemsPool.get(item);
            }
            props.add((PropertyImpl)item);
        }
        return props;
    }

    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException {
        return this.merge((ItemData)parent, this.transactionableManager, false, 1);
    }

    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException {
        return this.merge((ItemData)parent, this.transactionableManager, false, 2);
    }

    public AccessControlList getACL(InternalQPath path) throws RepositoryException {
        ItemData item = this.getItemData(path);
        if (item == null || !item.isNode()) {
            return this.transactionableManager.getACL(path);
        }
        return ((NodeData)item).getACL();
    }

    public void delete(ItemData itemData) throws RepositoryException {
        List<? extends ItemData> list = this.merge(itemData, this.transactionableManager, true, 3);
        ArrayList<ItemState> deletes = new ArrayList<ItemState>();
        boolean fireEvent = !this.isNew(itemData.getUUID());
        boolean rootAdded = false;
        for (ItemData itemData2 : list) {
            if (itemData2.equals(itemData)) {
                rootAdded = true;
            }
            deletes.add(new ItemState(itemData2, 3, fireEvent, itemData.getQPath(), false));
            ItemImpl pooled = this.itemsPool.remove(itemData2.getUUID());
            if (pooled != null) {
                pooled.invalidate();
                this.invalidated.add(pooled);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("deleted: " + itemData2.getQPath().getAsString()));
        }
        if (!rootAdded) {
            deletes.add(new ItemState(itemData, 3, fireEvent, itemData.getQPath(), false));
            ItemImpl pooled = this.itemsPool.remove(itemData.getUUID());
            if (pooled != null) {
                pooled.invalidate();
                this.invalidated.add(pooled);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("deleted top item: " + itemData.getQPath().getAsString()));
            }
        }
        Collections.sort(deletes, new PathSorter(true));
        if (!fireEvent) {
            this.changesLog.eraseEventFire(itemData.getUUID());
        }
        this.changesLog.addAll(deletes);
        if (itemData.isNode()) {
            this.changesLog.addAll(this.reindexSameNameSiblings((NodeData)itemData, this));
        }
    }

    protected List<ItemState> reindexSameNameSiblings(NodeData cause, ItemDataConsumer dataManager) throws RepositoryException {
        ArrayList<ItemState> changes = new ArrayList<ItemState>();
        InternalQPath parent = cause.getQPath().makeParentPath();
        InternalQPath nextSiblingPath = InternalQPath.makeChildPath((InternalQPath)parent, (InternalQName)cause.getQPath().getName(), (int)(cause.getQPath().getIndex() + 1));
        TransientNodeData nextSibling = (TransientNodeData)dataManager.getItemData(nextSiblingPath);
        while (nextSibling != null) {
            if (nextSibling.getUUID().equals(cause.getUUID())) {
                return changes;
            }
            TransientNodeData reindexed = nextSibling.cloneAsSibling(nextSibling.getQPath().getIndex() - 1);
            changes.add(ItemState.createUpdatedState((ItemData)reindexed));
            this.itemsPool.reload((ItemData)reindexed);
            nextSiblingPath = InternalQPath.makeChildPath((InternalQPath)parent, (InternalQName)nextSibling.getQPath().getName(), (int)(nextSibling.getQPath().getIndex() + 1));
            nextSibling = (TransientNodeData)dataManager.getItemData(nextSiblingPath);
        }
        return changes;
    }

    public ItemImpl update(ItemState itemState, boolean pool) throws RepositoryException {
        if (itemState.isDeleted()) {
            throw new RepositoryException("Illegal state DELETED. Use delete(...) method");
        }
        this.changesLog.add(itemState);
        ItemImpl item = this.itemFactory.createItem(itemState.getData());
        if (pool) {
            item = this.itemsPool.get(item);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(ItemState.nameFromValue((int)itemState.getState()) + (item.isNode() ? " NODE (order:" + ((NodeImpl)item).nodeData().getOrderNumber() + ")" : " PROPERTY") + ", " + item.getPath()));
        }
        return item;
    }

    public void commit(InternalQPath path) throws RepositoryException, AccessDeniedException, ReferentialIntegrityException, InvalidItemStateException {
        this.validate(path);
        ItemDataChangesLog cLog = this.changesLog.pushLog(path);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" ----- commit -------- \n" + cLog.dump()));
        }
        this.transactionableManager.save(cLog);
        this.invalidated.clear();
    }

    public List<PropertyData> getReferencesData(String uuid) throws RepositoryException {
        return this.transactionableManager.getReferencesData(uuid);
    }

    private void validate(InternalQPath path) throws RepositoryException, AccessDeniedException, ReferentialIntegrityException {
        List changes = this.changesLog.getAllStates();
        for (ItemState itemState : changes) {
            if (itemState.isInternalCreated()) continue;
            if (itemState.isDescendant(path)) {
                this.validateAccessPermissions(itemState);
                this.validateMandatoryItem(itemState);
            }
            if (!path.isDescendantOf(itemState.getAncestorToSave(), false)) continue;
            throw new ConstraintViolationException(path.getAsString() + " is the same or descendant of either Session.move()'s destination or source node only " + path.getAsString());
        }
    }

    private void validateAccessPermissions(ItemState changedItem) throws RepositoryException, AccessDeniedException {
        NodeData parent = (NodeData)this.getItemData(changedItem.getData().getParentUUID());
        if (parent != null) {
            if (changedItem.getData().isNode() && changedItem.isAdded() && !this.accessManager.hasPermission(parent.getACL(), "add_node", this.session.getUserID())) {
                throw new AccessDeniedException("Access denied: ADD_NODE " + changedItem.getData().getQPath().getAsString() + " for: " + this.session.getUserID() + " item owner " + parent.getACL().getOwner());
            }
            if (!changedItem.getData().isNode() && (changedItem.isAdded() || changedItem.isUpdated()) && !this.accessManager.hasPermission(parent.getACL(), "set_property", this.session.getUserID())) {
                throw new AccessDeniedException("Access denied: SET_PROPERTY " + changedItem.getData().getQPath().getAsString() + " for: " + this.session.getUserID() + " item owner " + parent.getACL().getOwner());
            }
            if (changedItem.isDeleted() && !this.accessManager.hasPermission(parent.getACL(), "remove", this.session.getUserID())) {
                throw new AccessDeniedException("Access denied: REMOVE " + changedItem.getData().getQPath().getAsString() + " for: " + this.session.getUserID() + " item owner " + parent.getACL().getOwner());
            }
        }
    }

    private void validateMandatoryItem(ItemState changedItem) throws ConstraintViolationException, AccessDeniedException {
        if (changedItem.getData().isNode() && changedItem.isAdded() && !this.changesLog.getItemState(changedItem.getData().getUUID()).isDeleted()) {
            NodeData nData = (NodeData)changedItem.getData();
            try {
                NodeImpl node = this.itemFactory.createNode(nData);
                node.validateMandatoryChildren();
            }
            catch (ConstraintViolationException e) {
                throw e;
            }
            catch (AccessDeniedException e) {
                throw e;
            }
            catch (RepositoryException e) {
                log.warn((Object)("Unexpected exception. Probable wrong data. Exception message:" + e.getLocalizedMessage()));
            }
        }
    }

    void rollback(ItemData item) throws InvalidItemStateException, RepositoryException {
        this.changesLog.remove(item.getQPath());
        ArrayList<ItemImpl> rolledBack = new ArrayList<ItemImpl>();
        for (ItemImpl removed : this.invalidated) {
            ItemData persisted;
            InternalQPath removedPath = removed.getLocation().getInternalPath();
            if (!removedPath.equals((Object)item.getQPath()) && !removedPath.isDescendantOf(item.getQPath(), false) || (persisted = this.transactionableManager.getItemData(removedPath)) == null) continue;
            removed.loadData(persisted);
            rolledBack.add(removed);
        }
        for (ItemImpl rolledBackNode : rolledBack) {
            this.invalidated.remove(rolledBackNode);
        }
    }

    void refresh(ItemData item) throws InvalidItemStateException, RepositoryException {
        if (!this.isModified(item)) {
            ItemData persisted = this.transactionableManager.getItemData(item.getUUID());
            if (persisted == null) {
                persisted = this.transactionableManager.getItemData(item.getQPath());
            }
            if (persisted != null) {
                this.itemsPool.reload(item.getUUID(), persisted);
            } else {
                throw new InvalidItemStateException("An item is transient only or removed (either by this session or another) " + this.session.getLocationFactory().createJCRPath(item.getQPath()).getAsString(false));
            }
        }
    }

    protected ItemReferencePool getItemsPool() {
        return this.itemsPool;
    }

    protected SessionChangesLog getChangesLog() {
        return this.changesLog;
    }

    protected List<? extends ItemData> merge(ItemData rootData, DataManager dataManager, boolean deep, int action) throws RepositoryException {
        LinkedHashMap<String, ItemData> descendants = new LinkedHashMap<String, ItemData>();
        this.traverseStoredDescendants(rootData, dataManager, deep, action, descendants);
        ArrayList<ItemState> transientDescendants = new ArrayList<ItemState>();
        this.traverseTransientDescendants(rootData, deep, action, transientDescendants);
        for (ItemState state : transientDescendants) {
            ItemData data = state.getData();
            if (!state.isDeleted()) {
                descendants.put(data.getUUID(), data);
                continue;
            }
            descendants.remove(data.getUUID());
        }
        return new ArrayList(descendants.values());
    }

    private void traverseStoredDescendants(ItemData parent, DataManager dataManager, boolean deep, int action, Map<String, ItemData> ret) throws RepositoryException {
        if (parent.isNode()) {
            if (action != 2) {
                List childNodes = dataManager.getChildNodesData((NodeData)parent);
                for (NodeData childNode : childNodes) {
                    ret.put(childNode.getUUID(), (ItemData)childNode);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Traverse stored (N) " + childNode.getQPath().getAsString()));
                    }
                    if (!deep) continue;
                    this.traverseStoredDescendants((ItemData)childNode, dataManager, deep, action, ret);
                }
            }
            if (action != 1) {
                List childProps = dataManager.getChildPropertiesData((NodeData)parent);
                for (PropertyData childProp : childProps) {
                    ret.put(childProp.getUUID(), (ItemData)childProp);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Traverse stored (P) " + childProp.getQPath().getAsString()));
                }
            }
        }
    }

    private void traverseTransientDescendants(ItemData parent, boolean deep, int action, List<ItemState> ret) throws RepositoryException {
        if (parent.isNode()) {
            if (action != 2) {
                Collection<ItemState> childNodes = this.changesLog.getLastChildrenStates(parent, true);
                for (ItemState childNode : childNodes) {
                    ret.add(childNode);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Traverse transient (N) " + childNode.getData().getQPath().getAsString() + " " + ItemState.nameFromValue((int)childNode.getState())));
                    }
                    if (!deep) continue;
                    this.traverseTransientDescendants(childNode.getData(), deep, action, ret);
                }
            }
            if (action != 1) {
                Collection<ItemState> childProps = this.changesLog.getLastChildrenStates(parent, false);
                for (ItemState childProp : childProps) {
                    ret.add(childProp);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Traverse transient  (P) " + childProp.getData().getQPath().getAsString()));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathSorter
    implements Comparator<ItemState> {
        private boolean reverse = false;

        public PathSorter(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(ItemState i1, ItemState i2) {
            int res = i1.getData().getQPath().compareTo((Object)i2.getData().getQPath());
            if (this.reverse) {
                res *= -1;
            }
            return res;
        }
    }

    private class SessionItemFactory {
        private SessionItemFactory() {
        }

        public ItemImpl createItem(ItemData data) throws RepositoryException {
            if (data.isNode()) {
                return this.createNode((NodeData)data);
            }
            return this.createProperty(data);
        }

        private NodeImpl createNode(NodeData data) throws RepositoryException {
            NodeImpl node = new NodeImpl(data, SessionDataManager.this.session);
            if (node.isNodeType(Constants.NT_VERSION)) {
                return new VersionImpl(data, SessionDataManager.this.session);
            }
            if (node.isNodeType(Constants.NT_VERSIONHISTORY)) {
                return new VersionHistoryImpl(data, SessionDataManager.this.session);
            }
            return node;
        }

        private PropertyImpl createProperty(ItemData data) throws RepositoryException {
            return new PropertyImpl(data, SessionDataManager.this.session);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ItemReferencePool {
        private WeakHashMap<String, ItemImpl> items = new WeakHashMap();

        ItemReferencePool() {
        }

        ItemImpl remove(String uuid) {
            return this.items.remove(uuid);
        }

        int size() {
            return this.items.size();
        }

        boolean contains(String uuid) {
            return this.items.containsKey(uuid);
        }

        ItemImpl get(ItemImpl newItem) throws RepositoryException {
            String uuid = newItem.getInternalUUID();
            ItemImpl item = this.items.get(uuid);
            if (item == null) {
                this.items.put(uuid, newItem);
                return newItem;
            }
            item.loadData(newItem.getData());
            return item;
        }

        ItemImpl reload(ItemData itemData) throws RepositoryException {
            return this.reload(itemData.getUUID(), itemData);
        }

        ItemImpl reload(String uuid, ItemData newItemData) throws RepositoryException {
            ItemImpl item = this.items.get(uuid);
            if (item != null) {
                item.loadData(newItemData);
                return item;
            }
            return null;
        }

        List<NodeImpl> getNodes(List<NodeImpl> nodes) throws RepositoryException {
            ArrayList<NodeImpl> children = new ArrayList<NodeImpl>();
            for (NodeImpl node : nodes) {
                String id = node.getInternalUUID();
                NodeImpl pooled = (NodeImpl)this.items.get(id);
                if (pooled == null) {
                    this.items.put(id, node);
                    children.add(node);
                    continue;
                }
                pooled.loadData(node.getData());
                children.add(pooled);
            }
            return children;
        }

        List<PropertyImpl> getProperties(List<PropertyImpl> props) throws RepositoryException {
            ArrayList<PropertyImpl> children = new ArrayList<PropertyImpl>();
            for (PropertyImpl prop : props) {
                String id = prop.getInternalUUID();
                PropertyImpl pooled = (PropertyImpl)this.items.get(id);
                if (pooled == null) {
                    this.items.put(id, prop);
                    children.add(prop);
                    continue;
                }
                pooled.loadData(prop.getData());
                children.add(pooled);
            }
            return children;
        }

        String dump() {
            String str = "Items Pool: \n";
            for (ItemImpl item : this.items.values()) {
                str = str + item.getPath() + "\n";
            }
            return str;
        }
    }
}

