/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NamespaceDataPersister;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.dataflow.MutableItemDataChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.util.EntityCollection;
import org.exoplatform.services.jcr.util.UUIDGenerator;
import org.exoplatform.services.log.ExoLogger;

public class WorkspaceInitializer {
    protected static Log log = ExoLogger.getLogger((String)"jcr.WorkspaceInitializer");
    private String systemWorkspaceName;
    private String workspaceName;
    private DataManager dataManager;
    private String accessControlType;
    private NamespaceDataPersister nsPersister;
    private ExtendedNodeTypeManager ntRegistry;
    private NodeTypeDataPersister ntPersister;
    private SearchIndex searchIndex;

    public WorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceDataPersister nsPersister, ExtendedNodeTypeManager ntRegistry, NodeTypeDataPersister ntPersister) {
        this.workspaceName = config.getName();
        this.systemWorkspaceName = repConfig.getSystemWorkspaceName();
        this.dataManager = dataManager;
        this.nsPersister = nsPersister;
        this.ntRegistry = ntRegistry;
        this.ntPersister = ntPersister;
        this.accessControlType = repConfig.getAuthenticationPolicy();
    }

    public WorkspaceInitializer(WorkspaceEntry config, RepositoryEntry repConfig, CacheableWorkspaceDataManager dataManager, NamespaceDataPersister nsPersister, ExtendedNodeTypeManager ntRegistry, NodeTypeDataPersister ntPersister, SearchIndex searchIndex) {
        this.workspaceName = config.getName();
        this.systemWorkspaceName = repConfig.getSystemWorkspaceName();
        this.dataManager = dataManager;
        this.nsPersister = nsPersister;
        this.ntRegistry = ntRegistry;
        this.ntPersister = ntPersister;
        this.accessControlType = repConfig.getAuthenticationPolicy();
        this.searchIndex = searchIndex;
    }

    public NodeData initWorkspace(InternalQName rootNodeType) throws RepositoryException {
        if (this.isWorkspaceInitialized()) {
            return (NodeData)this.dataManager.getItemData(Constants.ROOT_PATH);
        }
        NodeData root = this.initRootNode(rootNodeType);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Root node for " + this.workspaceName + " initialized. NodeType: " + rootNodeType + " system workspace: " + this.systemWorkspaceName));
        }
        if (this.workspaceName.equals(this.systemWorkspaceName)) {
            NodeData nodeData = this.initJcrSystemNode(root);
        }
        return root;
    }

    public void startWorkspace() throws RepositoryException {
        this.initSearchIndex();
    }

    private void initSearchIndex() throws RepositoryException {
        if (this.searchIndex != null) {
            try {
                this.searchIndex.init();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    public boolean isWorkspaceInitialized() {
        try {
            return this.dataManager.getItemData("00exo0jcr0root0uuid0000000000000") != null;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private NodeData initRootNode(InternalQName rootNodeType) throws RepositoryException {
        MutableItemDataChangesLog changesLog = new MutableItemDataChangesLog();
        TransientNodeData nodeData = new TransientNodeData(Constants.ROOT_PATH, "00exo0jcr0root0uuid0000000000000", -1, rootNodeType, new InternalQName[0], 0, null, new AccessControlList());
        changesLog.add(new ItemState((ItemData)nodeData, 1, false, null));
        TransientPropertyData primaryType = new TransientPropertyData(InternalQPath.makeChildPath((InternalQPath)nodeData.getQPath(), (InternalQName)Constants.JCR_PRIMARYTYPE), UUIDGenerator.generate(), -1, 7, nodeData.getUUID(), false);
        primaryType.setValue(new TransientValueData(rootNodeType));
        changesLog.add(new ItemState((ItemData)primaryType, 1, false, null));
        this.dataManager.save((ItemDataChangesLog)changesLog);
        return nodeData;
    }

    private NodeData initJcrSystemNode(NodeData root) throws RepositoryException {
        boolean addACL;
        MutableItemDataChangesLog changesLog = new MutableItemDataChangesLog();
        TransientNodeData sysNodeData = TransientNodeData.createNodeData(root, Constants.JCR_SYSTEM, Constants.NT_UNSTRUCTURED, "00exo0jcr0system0uuid00000000000");
        TransientPropertyData primaryType = TransientPropertyData.createPropertyData((NodeData)sysNodeData, Constants.JCR_PRIMARYTYPE, 7, false);
        primaryType.setValue(new TransientValueData(sysNodeData.getPrimaryTypeName()));
        changesLog.add(ItemState.createAddedState((ItemData)sysNodeData)).add(ItemState.createAddedState((ItemData)primaryType));
        boolean bl = addACL = !this.accessControlType.equals("disable");
        if (addACL) {
            AccessControlList acl = new AccessControlList();
            sysNodeData.setMixinTypeNames(new InternalQName[]{Constants.EXO_ACCESS_CONTROLLABLE});
            TransientPropertyData exoMixinTypes = TransientPropertyData.createPropertyData((NodeData)sysNodeData, Constants.JCR_MIXINTYPES, 7, false);
            exoMixinTypes.setValue(new TransientValueData(Constants.EXO_ACCESS_CONTROLLABLE));
            TransientPropertyData exoOwner = TransientPropertyData.createPropertyData((NodeData)sysNodeData, Constants.EXO_OWNER, 1, false, new TransientValueData(acl.getOwner()));
            TransientPropertyData exoPerms = TransientPropertyData.createPropertyData((NodeData)sysNodeData, Constants.EXO_PERMISSIONS, 100, true);
            ArrayList<ValueData> perms = new ArrayList<ValueData>();
            for (int i = 0; i < acl.getPermissionEntries().size(); ++i) {
                AccessControlEntry entry = (AccessControlEntry)acl.getPermissionEntries().get(i);
                perms.add(new TransientValueData(entry));
            }
            exoPerms.setValues(perms);
            changesLog.add(ItemState.createAddedState((ItemData)exoMixinTypes)).add(ItemState.createAddedState((ItemData)exoOwner)).add(ItemState.createAddedState((ItemData)exoPerms));
            changesLog.add(new ItemState((ItemData)sysNodeData, 8, false, null));
        }
        TransientNodeData versionStorageNodeData = TransientNodeData.createNodeData((NodeData)sysNodeData, Constants.JCR_VERSIONSTORAGE, Constants.EXO_VERSIONSTORAGE, "00exo0jcr0version0storage0uuid00");
        TransientPropertyData vsPrimaryType = TransientPropertyData.createPropertyData((NodeData)versionStorageNodeData, Constants.JCR_PRIMARYTYPE, 7, false);
        vsPrimaryType.setValue(new TransientValueData(versionStorageNodeData.getPrimaryTypeName()));
        changesLog.add(ItemState.createAddedState((ItemData)versionStorageNodeData)).add(ItemState.createAddedState((ItemData)vsPrimaryType));
        this.dataManager.save((ItemDataChangesLog)changesLog);
        changesLog.clear();
        this.nsPersister.initStorage((NodeData)sysNodeData, addACL, NamespaceRegistryImpl.DEF_NAMESPACES);
        this.ntPersister.initNodetypesRoot((NodeData)sysNodeData, addACL);
        this.ntPersister.initStorage(((EntityCollection)this.ntRegistry.getAllNodeTypes()).getList());
        return sysNodeData;
    }
}

