/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.access;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.impl.core.CredentialsImpl;
import org.exoplatform.services.jcr.impl.core.access.BaseAuthenticationPolicy;
import org.exoplatform.services.security.SecurityService;

public class PortalAuthenticationPolicy
extends BaseAuthenticationPolicy {
    public PortalAuthenticationPolicy(RepositoryEntry config, SecurityService securityService) {
        super(config, securityService);
    }

    public Credentials authenticate() throws LoginException {
        String userId;
        SessionContainer sessionContainer = SessionContainer.getInstance();
        if (sessionContainer != null) {
            userId = SessionContainer.getInstance().getRemoteUser();
            if (userId == null) {
                userId = "__anonim";
            }
        } else {
            throw new LoginException("Current User should be authenticated externally but was not.");
        }
        CredentialsImpl thisCredentials = new CredentialsImpl(userId, new char[0]);
        log.debug((Object)("Repository.login() gets user  " + userId + " from SessionContainer"));
        return thisCredentials;
    }
}

