/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.value.NameValue;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.MutableItemDataChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.util.NodeDataReader;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeDataPersister {
    public static Log log = ExoLogger.getLogger((String)"jcr.NodeTypeDataPersister");
    private DataManager dataManager;
    private MutableItemDataChangesLog changesLog;
    private NodeData ntRoot;
    private ValueFactoryImpl valueFactory = null;
    private LocationFactory locationFactory;

    public NodeTypeDataPersister(DataManager dataManager, ValueFactoryImpl valueFactory, LocationFactory locationFactory) {
        this.dataManager = dataManager;
        this.valueFactory = valueFactory;
        this.locationFactory = locationFactory;
        this.changesLog = new MutableItemDataChangesLog();
        try {
            this.ntRoot = (NodeData)dataManager.getItemData(Constants.JCR_NODETYPES_PATH);
        }
        catch (RepositoryException e) {
            log.warn((Object)"Nodetypes storage (/jcr:system/jcr:nodetypes node) is not initialized.");
        }
    }

    boolean isPersisted() {
        return this.ntRoot != null;
    }

    private InternalQName parseName(String name) throws RepositoryException {
        return this.locationFactory.parseJCRName(name).getInternalName();
    }

    void saveChanges() throws RepositoryException, InvalidItemStateException {
        this.dataManager.save((ItemDataChangesLog)this.changesLog);
        this.changesLog.clear();
    }

    public synchronized void initNodetypesRoot(NodeData nsSystem, boolean addACL) {
        if (this.ntRoot == null) {
            long start = System.currentTimeMillis();
            TransientNodeData root = TransientNodeData.createNodeData(nsSystem, Constants.JCR_NODETYPES, Constants.NT_UNSTRUCTURED, "00exo0jcr0node0types0root0uuid00");
            TransientPropertyData primaryType = TransientPropertyData.createPropertyData((NodeData)root, Constants.JCR_PRIMARYTYPE, 7, false);
            primaryType.setValue(new TransientValueData(root.getPrimaryTypeName()));
            this.changesLog.add(ItemState.createAddedState((ItemData)root)).add(ItemState.createAddedState((ItemData)primaryType));
            if (addACL) {
                AccessControlList acl = new AccessControlList();
                root.setMixinTypeNames(new InternalQName[]{Constants.EXO_ACCESS_CONTROLLABLE});
                TransientPropertyData rootMixinTypes = TransientPropertyData.createPropertyData((NodeData)root, Constants.JCR_MIXINTYPES, 7, false);
                rootMixinTypes.setValue(new TransientValueData(Constants.EXO_ACCESS_CONTROLLABLE));
                TransientPropertyData exoOwner = TransientPropertyData.createPropertyData((NodeData)root, Constants.EXO_OWNER, 1, false);
                exoOwner.setValue(new TransientValueData(acl.getOwner()));
                TransientPropertyData exoPerms = TransientPropertyData.createPropertyData((NodeData)root, Constants.EXO_PERMISSIONS, 100, true);
                ArrayList<ValueData> perms = new ArrayList<ValueData>();
                for (int i = 0; i < acl.getPermissionEntries().size(); ++i) {
                    AccessControlEntry entry = (AccessControlEntry)acl.getPermissionEntries().get(i);
                    perms.add(new TransientValueData(entry));
                }
                exoPerms.setValues(perms);
                this.changesLog.add(ItemState.createAddedState((ItemData)rootMixinTypes)).add(ItemState.createAddedState((ItemData)exoOwner)).add(ItemState.createAddedState((ItemData)exoPerms));
                this.changesLog.add(new ItemState((ItemData)root, 8, false, null));
            }
            this.ntRoot = root;
            log.info((Object)("/jcr:system/jcr:nodetypes is created, creation time: " + (System.currentTimeMillis() - start) + " ms"));
        } else {
            log.warn((Object)"/jcr:system/jcr:nodetypes already exists");
        }
    }

    public synchronized void initStorage(List<NodeType> nodetypes) throws PathNotFoundException, RepositoryException {
        if (!this.isPersisted()) {
            log.warn((Object)"Nodetypes storage (/jcr:system/jcr:nodetypes node) is not exists. Possible is not initialized (call initNodetypesRoot() before)");
            return;
        }
        long ntStart = System.currentTimeMillis();
        for (NodeType nt : nodetypes) {
            try {
                this.addNodeType(nt);
                log.info((Object)("Node type " + nt.getName() + " is initialized. "));
            }
            catch (ItemExistsException e) {
                log.warn((Object)("Node exists " + nt.getName() + ". Error: " + e.getMessage()));
            }
        }
        this.saveChanges();
        log.info((Object)("Node types initialized. Time: " + (System.currentTimeMillis() - ntStart) + " ms"));
    }

    public boolean hasNodeTypeData(String nodeTypeName) throws RepositoryException {
        return this.hasNodeTypeData(this.parseName(nodeTypeName));
    }

    public boolean hasNodeTypeData(InternalQName nodeTypeName) throws RepositoryException {
        try {
            return this.getNodeTypesData(nodeTypeName).size() > 0;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    private List<NodeDataReader> getNodeTypesData(InternalQName nodeTypeName) throws RepositoryException {
        NodeDataReader ntReader = new NodeDataReader(this.ntRoot, this.dataManager, this.valueFactory);
        ntReader.forNode(nodeTypeName);
        ntReader.read();
        ntReader.getNodes(nodeTypeName);
        return ntReader.getNodes(nodeTypeName);
    }

    public NodeData addNodeType(NodeType nodeType) throws PathNotFoundException, RepositoryException, ValueFormatException {
        int i;
        if (!this.isPersisted()) {
            log.warn((Object)"Nodetypes storage (/jcr:system/jcr:nodetypes node) is not initialized.");
            return null;
        }
        TransientNodeData ntNode = TransientNodeData.createNodeData(this.ntRoot, this.parseName(nodeType.getName()), Constants.NT_NODETYPE);
        TransientPropertyData primaryType = TransientPropertyData.createPropertyData((NodeData)ntNode, Constants.JCR_PRIMARYTYPE, 7, false);
        primaryType.setValue(new TransientValueData(ntNode.getPrimaryTypeName()));
        TransientPropertyData name = TransientPropertyData.createPropertyData((NodeData)ntNode, Constants.JCR_NODETYPENAME, 7, false);
        name.setValue(new TransientValueData(this.parseName(nodeType.getName())));
        TransientPropertyData isMixin = TransientPropertyData.createPropertyData((NodeData)ntNode, Constants.JCR_ISMIXIN, 6, false);
        isMixin.setValue(new TransientValueData(nodeType.isMixin()));
        TransientPropertyData hasOrderableChildNodes = TransientPropertyData.createPropertyData((NodeData)ntNode, Constants.JCR_HASORDERABLECHILDNODES, 6, false);
        hasOrderableChildNodes.setValue(new TransientValueData(nodeType.hasOrderableChildNodes()));
        this.changesLog.add(ItemState.createAddedState((ItemData)ntNode)).add(ItemState.createAddedState((ItemData)primaryType)).add(ItemState.createAddedState((ItemData)name)).add(ItemState.createAddedState((ItemData)isMixin)).add(ItemState.createAddedState((ItemData)hasOrderableChildNodes));
        if (nodeType.getPrimaryItemName() != null) {
            TransientPropertyData primaryItemName = TransientPropertyData.createPropertyData((NodeData)ntNode, Constants.JCR_PRIMARYITEMNAME, 7, false);
            primaryItemName.setValue(new TransientValueData(this.parseName(nodeType.getPrimaryItemName())));
            this.changesLog.add(ItemState.createAddedState((ItemData)primaryItemName));
        }
        ArrayList<ValueData> parents = new ArrayList<ValueData>();
        for (i = 0; i < nodeType.getDeclaredSupertypes().length; ++i) {
            parents.add(new TransientValueData(this.parseName(nodeType.getDeclaredSupertypes()[i].getName())));
        }
        if (parents.size() != 0) {
            TransientPropertyData supertypes = TransientPropertyData.createPropertyData((NodeData)ntNode, Constants.JCR_SUPERTYPES, 7, true);
            supertypes.setValues(parents);
            this.changesLog.add(ItemState.createAddedState((ItemData)supertypes));
        }
        if (nodeType.getDeclaredPropertyDefinitions().length > 0) {
            for (i = 0; i < nodeType.getDeclaredPropertyDefinitions().length; ++i) {
                TransientNodeData childProps = TransientNodeData.createNodeData((NodeData)ntNode, Constants.JCR_PROPERTYDEFINITION, Constants.NT_PROPERTYDEFINITION, i + 1);
                TransientPropertyData cpPrimaryType = TransientPropertyData.createPropertyData((NodeData)childProps, Constants.JCR_PRIMARYTYPE, 7, false);
                cpPrimaryType.setValue(new TransientValueData(childProps.getPrimaryTypeName()));
                this.changesLog.add(ItemState.createAddedState((ItemData)childProps)).add(ItemState.createAddedState((ItemData)cpPrimaryType));
                this.initPropertyDefProps((NodeData)childProps, nodeType.getDeclaredPropertyDefinitions()[i]);
            }
        }
        if (nodeType.getDeclaredChildNodeDefinitions().length > 0) {
            for (i = 0; i < nodeType.getDeclaredChildNodeDefinitions().length; ++i) {
                TransientNodeData childNodes = TransientNodeData.createNodeData((NodeData)ntNode, Constants.JCR_CHILDNODEDEFINITION, Constants.NT_CHILDNODEDEFINITION, i + 1);
                TransientPropertyData cnPrimaryType = TransientPropertyData.createPropertyData((NodeData)childNodes, Constants.JCR_PRIMARYTYPE, 7, false);
                cnPrimaryType.setValue(new TransientValueData(childNodes.getPrimaryTypeName()));
                this.changesLog.add(ItemState.createAddedState((ItemData)childNodes)).add(ItemState.createAddedState((ItemData)cnPrimaryType));
                this.initNodeDefProps((NodeData)childNodes, nodeType.getDeclaredChildNodeDefinitions()[i]);
            }
        }
        return ntNode;
    }

    private void initPropertyDefProps(NodeData parent, PropertyDefinition def) throws ValueFormatException, RepositoryException {
        if (def.getName() != null) {
            TransientPropertyData name = TransientPropertyData.createPropertyData(parent, Constants.JCR_NAME, 7, false);
            name.setValue(new TransientValueData(this.parseName(def.getName())));
            this.changesLog.add(ItemState.createAddedState((ItemData)name));
        }
        TransientPropertyData autoCreated = TransientPropertyData.createPropertyData(parent, Constants.JCR_AUTOCREATED, 6, false);
        autoCreated.setValue(new TransientValueData(def.isAutoCreated()));
        TransientPropertyData isMandatory = TransientPropertyData.createPropertyData(parent, Constants.JCR_MANDATORY, 6, false);
        isMandatory.setValue(new TransientValueData(def.isMandatory()));
        TransientPropertyData onParentVersion = TransientPropertyData.createPropertyData(parent, Constants.JCR_ONPARENTVERSION, 1, false);
        onParentVersion.setValue(new TransientValueData(OnParentVersionAction.nameFromValue((int)def.getOnParentVersion())));
        TransientPropertyData isProtected = TransientPropertyData.createPropertyData(parent, Constants.JCR_PROTECTED, 6, false);
        isProtected.setValue(new TransientValueData(def.isProtected()));
        TransientPropertyData requiredType = TransientPropertyData.createPropertyData(parent, Constants.JCR_REQUIREDTYPE, 1, false);
        requiredType.setValue(new TransientValueData(ExtendedPropertyType.nameFromValue((int)def.getRequiredType())));
        TransientPropertyData isMultiple = TransientPropertyData.createPropertyData(parent, Constants.JCR_MULTIPLE, 6, false);
        isMultiple.setValue(new TransientValueData(def.isMultiple()));
        this.changesLog.add(ItemState.createAddedState((ItemData)autoCreated)).add(ItemState.createAddedState((ItemData)isMandatory)).add(ItemState.createAddedState((ItemData)onParentVersion)).add(ItemState.createAddedState((ItemData)isProtected)).add(ItemState.createAddedState((ItemData)requiredType)).add(ItemState.createAddedState((ItemData)isMultiple));
        if (def.getValueConstraints() != null && def.getValueConstraints().length != 0) {
            ArrayList<ValueData> valueConstraintsValues = new ArrayList<ValueData>();
            for (int i = 0; i < def.getValueConstraints().length; ++i) {
                valueConstraintsValues.add(new TransientValueData(def.getValueConstraints()[i]));
            }
            TransientPropertyData valueConstraints = TransientPropertyData.createPropertyData(parent, Constants.JCR_VALUECONSTRAINTS, 1, true);
            valueConstraints.setValues(valueConstraintsValues);
            this.changesLog.add(ItemState.createAddedState((ItemData)valueConstraints));
        }
        if (def.getDefaultValues() != null && def.getDefaultValues().length != 0) {
            ArrayList<ValueData> defaultValuesValues = new ArrayList<ValueData>();
            for (int i = 0; i < def.getDefaultValues().length; ++i) {
                if (def.getDefaultValues()[i] == null) continue;
                defaultValuesValues.add(new TransientValueData(def.getDefaultValues()[i].getString()));
            }
            TransientPropertyData defaultValues = TransientPropertyData.createPropertyData(parent, Constants.JCR_DEFAULTVALUES, 1, true);
            defaultValues.setValues(defaultValuesValues);
            this.changesLog.add(ItemState.createAddedState((ItemData)defaultValues));
        }
    }

    private void initNodeDefProps(NodeData parent, NodeDefinition def) throws ValueFormatException, RepositoryException {
        if (def.getName() != null) {
            TransientPropertyData name = TransientPropertyData.createPropertyData(parent, Constants.JCR_NAME, 7, false);
            name.setValue(new TransientValueData(this.parseName(def.getName())));
            this.changesLog.add(ItemState.createAddedState((ItemData)name));
        }
        TransientPropertyData autoCreated = TransientPropertyData.createPropertyData(parent, Constants.JCR_AUTOCREATED, 6, false);
        autoCreated.setValue(new TransientValueData(def.isAutoCreated()));
        TransientPropertyData isMandatory = TransientPropertyData.createPropertyData(parent, Constants.JCR_MANDATORY, 6, false);
        isMandatory.setValue(new TransientValueData(def.isMandatory()));
        TransientPropertyData onParentVersion = TransientPropertyData.createPropertyData(parent, Constants.JCR_ONPARENTVERSION, 1, false);
        onParentVersion.setValue(new TransientValueData(OnParentVersionAction.nameFromValue((int)def.getOnParentVersion())));
        TransientPropertyData isProtected = TransientPropertyData.createPropertyData(parent, Constants.JCR_PROTECTED, 6, false);
        isProtected.setValue(new TransientValueData(def.isProtected()));
        TransientPropertyData sameNameSiblings = TransientPropertyData.createPropertyData(parent, Constants.JCR_SAMENAMESIBLINGS, 6, false);
        sameNameSiblings.setValue(new TransientValueData(def.allowsSameNameSiblings()));
        if (def.getDefaultPrimaryType() != null) {
            TransientPropertyData defaultPrimaryType = TransientPropertyData.createPropertyData(parent, Constants.JCR_DEFAULTPRIMNARYTYPE, 7, false);
            defaultPrimaryType.setValue(new TransientValueData(this.parseName(def.getDefaultPrimaryType().getName())));
            this.changesLog.add(ItemState.createAddedState((ItemData)defaultPrimaryType));
        }
        this.changesLog.add(ItemState.createAddedState((ItemData)autoCreated)).add(ItemState.createAddedState((ItemData)isMandatory)).add(ItemState.createAddedState((ItemData)onParentVersion)).add(ItemState.createAddedState((ItemData)isProtected)).add(ItemState.createAddedState((ItemData)sameNameSiblings));
        if (def.getRequiredPrimaryTypes() != null && def.getRequiredPrimaryTypes().length != 0) {
            ArrayList<ValueData> requiredPrimaryTypesValues = new ArrayList<ValueData>();
            for (int i = 0; i < def.getRequiredPrimaryTypes().length; ++i) {
                requiredPrimaryTypesValues.add(new TransientValueData(this.parseName(def.getRequiredPrimaryTypes()[i].getName())));
            }
            TransientPropertyData requiredPrimaryTypes = TransientPropertyData.createPropertyData(parent, Constants.JCR_REQUIREDPRIMARYTYPES, 7, true);
            requiredPrimaryTypes.setValues(requiredPrimaryTypesValues);
            this.changesLog.add(ItemState.createAddedState((ItemData)requiredPrimaryTypes));
        }
    }

    private NodeType findType(String nodeTypeName, List<NodeType> ntList) {
        for (NodeType regNt : ntList) {
            if (!regNt.getName().equals(nodeTypeName)) continue;
            return regNt;
        }
        return null;
    }

    public List<NodeType> loadNodetypes(List<NodeType> registeredNodeTypes, NodeTypeManagerImpl ntManager) throws PathNotFoundException, RepositoryException {
        if (!this.isPersisted()) {
            this.ntRoot = (NodeData)this.dataManager.getItemData(Constants.JCR_NODETYPES_PATH);
        }
        if (!this.isPersisted()) {
            log.warn((Object)"Nodetypes storage (/jcr:system/jcr:nodetypes node) is not initialized. No nodetypes loaded.");
            return new ArrayList<NodeType>();
        }
        ArrayList<NodeType> ntList = new ArrayList<NodeType>();
        ArrayList<NodeType> loadedList = new ArrayList<NodeType>();
        ntList.addAll(registeredNodeTypes);
        boolean nextCycle = false;
        ArrayList<NodeType> registeringTypes = new ArrayList<NodeType>();
        int registerCyclesCount = 1;
        do {
            long cycleStart = System.currentTimeMillis();
            log.info((Object)(">>> Node types registration cycle " + registerCyclesCount + " started"));
            NodeDataReader ntReader = new NodeDataReader(this.ntRoot, this.dataManager, this.valueFactory);
            ntReader.forNodesByType(Constants.NT_NODETYPE);
            ntReader.read();
            block23: for (NodeDataReader ntr : ntReader.getNodesByType(Constants.NT_NODETYPE)) {
                int j;
                NameValue nameValue;
                long ntStart = System.currentTimeMillis();
                ntr.forProperty(Constants.JCR_NODETYPENAME, 7);
                ntr.read();
                String ntName = ntr.getPropertyValue(Constants.JCR_NODETYPENAME).getString();
                NodeType existedNodeType = this.findType(ntName, ntList);
                if (existedNodeType != null) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Already reagistered " + ntName));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Reagistering from storage " + ntName + " " + (System.currentTimeMillis() - ntStart)));
                }
                ntr.forProperty(Constants.JCR_PRIMARYTYPE, 7).forProperty(Constants.JCR_ISMIXIN, 6).forProperty(Constants.JCR_HASORDERABLECHILDNODES, 6).forProperty(Constants.JCR_PRIMARYITEMNAME, 7).forProperty(Constants.JCR_SUPERTYPES, 7);
                ntr.forNodesByType(Constants.NT_PROPERTYDEFINITION).forNodesByType(Constants.NT_CHILDNODEDEFINITION);
                ntr.read();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Node type readed " + ntName + " " + (System.currentTimeMillis() - ntStart)));
                }
                NodeTypeImpl type = new NodeTypeImpl(ntManager);
                type.setName(ntr.getPropertyValue(Constants.JCR_NODETYPENAME).getString());
                type.setMixin(ntr.getPropertyValue(Constants.JCR_ISMIXIN).getBoolean());
                type.setOrderableChild(ntr.getPropertyValue(Constants.JCR_HASORDERABLECHILDNODES).getBoolean());
                try {
                    type.setPrimaryItemName(ntr.getPropertyValue(Constants.JCR_PRIMARYITEMNAME).getString());
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
                if (!registeringTypes.contains(type)) {
                    registeringTypes.add((NodeType)type);
                }
                try {
                    List<Value> dst = ntr.getPropertyValues(Constants.JCR_SUPERTYPES);
                    NodeType[] declaredSupertypes = new NodeType[dst.size()];
                    for (int i = 0; i < dst.size(); ++i) {
                        String superTypeName = dst.get(i).getString();
                        declaredSupertypes[i] = this.findType(superTypeName, ntList);
                        if (declaredSupertypes[i] != null) continue;
                        if (nextCycle && this.findType(superTypeName, registeringTypes) == null) {
                            throw new ConstraintViolationException("Supertype " + superTypeName + " is not registered in repository (but need to be registered before nodetype " + type.getName() + "). Node type resistration aborted.");
                        }
                        log.info((Object)("Supertype " + superTypeName + " is not registered. " + type.getName() + " node type will be registered in a next cycle."));
                        continue block23;
                    }
                    type.setDeclaredSupertypes(declaredSupertypes);
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Property definitions for " + ntName + " " + (System.currentTimeMillis() - ntStart)));
                }
                try {
                    List<NodeDataReader> pdNodes = ntr.getNodesByType(Constants.NT_PROPERTYDEFINITION);
                    PropertyDefinition[] declaredPropertyDefs = new PropertyDefinition[pdNodes.size()];
                    for (int pdi = 0; pdi < pdNodes.size(); ++pdi) {
                        NodeDataReader pdr = pdNodes.get(pdi);
                        pdr.forProperty(Constants.JCR_NAME, 7).forProperty(Constants.JCR_AUTOCREATED, 6).forProperty(Constants.JCR_MANDATORY, 6).forProperty(Constants.JCR_PROTECTED, 6).forProperty(Constants.JCR_MULTIPLE, 6).forProperty(Constants.JCR_ONPARENTVERSION, 1).forProperty(Constants.JCR_REQUIREDTYPE, 1).forProperty(Constants.JCR_VALUECONSTRAINTS, 1).forProperty(Constants.JCR_DEFAULTVALUES, 1);
                        pdr.read();
                        PropertyDefinitionImpl pDef = new PropertyDefinitionImpl();
                        try {
                            nameValue = (NameValue)pdr.getPropertyValue(Constants.JCR_NAME);
                            pDef.setName(nameValue.getString());
                            pDef.setQName(nameValue.getQName());
                        }
                        catch (PathNotFoundException e) {
                            // empty catch block
                        }
                        try {
                            pDef.setAutoCreate(pdr.getPropertyValue(Constants.JCR_AUTOCREATED).getBoolean());
                            pDef.setMandatory(pdr.getPropertyValue(Constants.JCR_MANDATORY).getBoolean());
                            pDef.setReadOnly(pdr.getPropertyValue(Constants.JCR_PROTECTED).getBoolean());
                            pDef.setMultiple(pdr.getPropertyValue(Constants.JCR_MULTIPLE).getBoolean());
                            pDef.setOnVersion(OnParentVersionAction.valueFromName((String)pdr.getPropertyValue(Constants.JCR_ONPARENTVERSION).getString()));
                            pDef.setDeclaringNodeType((NodeType)type);
                            pDef.setRequiredType(ExtendedPropertyType.valueFromName((String)pdr.getPropertyValue(Constants.JCR_REQUIREDTYPE).getString()));
                        }
                        catch (PathNotFoundException e) {
                            throw new ConstraintViolationException("Mandatory property did not set. PropertyDefinition: " + pDef.getName() + ". Type: " + type.getName() + ". Error: " + e.getMessage() + ". Node type resistration aborted.");
                        }
                        try {
                            List<Value> valueConstraintValues = pdr.getPropertyValues(Constants.JCR_VALUECONSTRAINTS);
                            String[] valueConstraints = new String[valueConstraintValues.size()];
                            for (j = 0; j < valueConstraintValues.size(); ++j) {
                                valueConstraints[j] = valueConstraintValues.get(j) != null ? valueConstraintValues.get(j).getString() : null;
                            }
                            pDef.setValueConstraints(valueConstraints);
                        }
                        catch (PathNotFoundException e) {
                            // empty catch block
                        }
                        try {
                            List<Value> dvl = pdr.getPropertyValues(Constants.JCR_DEFAULTVALUES);
                            Value[] defaultValues = new Value[dvl.size()];
                            for (int i = 0; i < dvl.size(); ++i) {
                                defaultValues[i] = dvl.get(i);
                            }
                            pDef.setDefaultValues(defaultValues);
                        }
                        catch (PathNotFoundException e) {
                            // empty catch block
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Property definitions readed " + pDef.getName() + " " + (System.currentTimeMillis() - ntStart)));
                        }
                        declaredPropertyDefs[pdi] = pDef;
                    }
                    type.setDeclaredPropertyDefs(declaredPropertyDefs);
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Child nodes definitions for " + ntName + " " + (System.currentTimeMillis() - ntStart)));
                }
                try {
                    List<NodeDataReader> cdNodes = ntr.getNodesByType(Constants.NT_CHILDNODEDEFINITION);
                    NodeDefinition[] declaredChildNodesDefs = new NodeDefinition[cdNodes.size()];
                    for (int cdi = 0; cdi < cdNodes.size(); ++cdi) {
                        NodeDataReader cdr = cdNodes.get(cdi);
                        cdr.forProperty(Constants.JCR_NAME, 7).forProperty(Constants.JCR_REQUIREDPRIMARYTYPES, 7).forProperty(Constants.JCR_AUTOCREATED, 6).forProperty(Constants.JCR_MANDATORY, 6).forProperty(Constants.JCR_PROTECTED, 6).forProperty(Constants.JCR_ONPARENTVERSION, 1).forProperty(Constants.JCR_SAMENAMESIBLINGS, 1).forProperty(Constants.JCR_DEFAULTPRIMNARYTYPE, 7);
                        cdr.read();
                        NodeDefinitionImpl nDef = new NodeDefinitionImpl();
                        try {
                            nameValue = (NameValue)cdr.getPropertyValue(Constants.JCR_NAME);
                            nDef.setName(nameValue.getString());
                            nDef.setQName(nameValue.getQName());
                        }
                        catch (PathNotFoundException e) {
                            // empty catch block
                        }
                        try {
                            String defaultNodeTypeName = cdr.getPropertyValue(Constants.JCR_DEFAULTPRIMNARYTYPE).getString();
                            NodeType defaultNodeType = this.findType(defaultNodeTypeName, ntList);
                            if (defaultNodeType != null) {
                                nDef.setDefaultNodeType(defaultNodeType);
                            } else if (defaultNodeType == null && defaultNodeTypeName.equals(type.getName())) {
                                nDef.setDefaultNodeType((NodeType)type);
                            }
                        }
                        catch (PathNotFoundException e) {
                            // empty catch block
                        }
                        try {
                            List<Value> requiredNodeTypesValues = cdr.getPropertyValues(Constants.JCR_REQUIREDPRIMARYTYPES);
                            NodeType[] requiredNodeTypes = new NodeType[requiredNodeTypesValues.size()];
                            for (j = 0; j < requiredNodeTypesValues.size(); ++j) {
                                NodeType requiredNodeType;
                                if (requiredNodeTypesValues.get(j) != null) {
                                    String requiredNodeTypeName = requiredNodeTypesValues.get(j).getString();
                                    requiredNodeType = this.findType(requiredNodeTypeName, ntList);
                                    if (requiredNodeType == null) {
                                        if (nextCycle && this.findType(requiredNodeTypeName, registeringTypes) == null) {
                                            throw new ConstraintViolationException("Required node type of NodeDefinition " + nDef.getName() + " is not registered in repository. Required node type " + requiredNodeTypeName + " must be registered before " + type.getName() + ". Node type resistration aborted.");
                                        }
                                        log.info((Object)("Required node type of NodeDefinition " + nDef.getName() + " is not registered." + type.getName() + " node type will be registered in a next cycle."));
                                        continue block23;
                                    }
                                } else {
                                    throw new ConstraintViolationException("Required node type is null. Type: " + type.getName() + ". NodeDefinition: " + nDef.getName() + ". Node type resistration aborted.");
                                }
                                requiredNodeTypes[j] = requiredNodeType;
                            }
                            nDef.setRequiredNodeTypes(requiredNodeTypes);
                            nDef.setDeclaringNodeType((NodeType)type);
                            nDef.setAutoCreate(cdr.getPropertyValue(Constants.JCR_AUTOCREATED).getBoolean());
                            nDef.setMandatory(cdr.getPropertyValue(Constants.JCR_MANDATORY).getBoolean());
                            nDef.setReadOnly(cdr.getPropertyValue(Constants.JCR_PROTECTED).getBoolean());
                            nDef.setMultiple(cdr.getPropertyValue(Constants.JCR_SAMENAMESIBLINGS).getBoolean());
                            nDef.setOnVersion(OnParentVersionAction.valueFromName((String)cdr.getPropertyValue(Constants.JCR_ONPARENTVERSION).getString()));
                        }
                        catch (PathNotFoundException e) {
                            throw new ConstraintViolationException("Mandatory property did not set. NodeDefinition: " + nDef.getName() + ". Type: " + type.getName() + ". Error: " + e.getMessage() + ". Node type resistration aborted.", (Throwable)e);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Child nodes definitions readed " + nDef.getName() + " " + (System.currentTimeMillis() - ntStart)));
                        }
                        declaredChildNodesDefs[cdi] = nDef;
                    }
                    type.setDeclaredNodeDefs(declaredChildNodesDefs);
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
                ntList.add((NodeType)type);
                loadedList.add((NodeType)type);
                log.info((Object)("NodeType " + type.getName() + " loaded. " + (System.currentTimeMillis() - ntStart) + " ms"));
            }
            nextCycle = true;
            log.info((Object)("<<< Node types registration cycle " + registerCyclesCount + " finished. " + (System.currentTimeMillis() - cycleStart) + " ms"));
            if (++registerCyclesCount < 1000) continue;
            throw new RepositoryException("Maximum cycles count of NodeType registrations reached, 1000. Registration breaked.");
        } while (registeringTypes.size() > loadedList.size());
        return loadedList;
    }
}

