/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.spi.ServiceRegistry;
import javax.jcr.query.InvalidQueryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.core.query.QueryTreeBuilder;
import org.exoplatform.services.log.ExoLogger;

public class QueryTreeBuilderRegistry {
    private static Log log = ExoLogger.getLogger((String)"jcr.QueryTreeBuilderRegistry");
    private static final List BUILDERS = new ArrayList();

    public static QueryTreeBuilder getQueryTreeBuilder(String language) throws InvalidQueryException {
        for (int i = 0; i < BUILDERS.size(); ++i) {
            QueryTreeBuilder builder = (QueryTreeBuilder)BUILDERS.get(i);
            if (!builder.canHandle(language)) continue;
            return builder;
        }
        throw new InvalidQueryException("Unsupported language: " + language);
    }

    static {
        try {
            Iterator<QueryTreeBuilder> it = ServiceRegistry.lookupProviders(QueryTreeBuilder.class, QueryTreeBuilderRegistry.class.getClassLoader());
            while (it.hasNext()) {
                BUILDERS.add(it.next());
            }
        }
        catch (Error e) {
            log.warn((Object)("Unable to load providers for QueryTreeBuilder: " + e));
        }
    }
}

