/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;

public class SearchManager
implements Startable {
    private static Log log = ExoLogger.getLogger((String)"jcr.SearchManager");
    private long lastAccess = System.currentTimeMillis();
    private final String queryImplClassName = "org.exoplatform.services.jcr.impl.core.query.QueryImpl";
    private LocationFactory sysLocationFactory;
    private QueryHandler handler;
    private final WorkspacePersistentDataManager wsDataManager;
    private final Map activeQueries = Collections.synchronizedMap(new WeakHashMap(){});

    public SearchManager(WorkspacePersistentDataManager wsDataManager, NamespaceRegistry nsReg, QueryHandler handler, LocationFactory sysLocationFactory) throws RepositoryException {
        this.wsDataManager = wsDataManager;
        this.sysLocationFactory = sysLocationFactory;
        this.handler = handler;
    }

    public void close() {
        try {
            this.handler.close();
        }
        catch (IOException e) {
            log.error((Object)"Exception closing QueryHandler.", (Throwable)e);
        }
    }

    public Query createQuery(SessionImpl session, String statement, String language) throws InvalidQueryException, RepositoryException {
        AbstractQueryImpl query = this.createQueryInstance();
        query.init(session, this.handler, statement, language);
        return query;
    }

    public Query createQuery(SessionImpl session, Node node) throws InvalidQueryException, RepositoryException {
        this.ensureInitialized();
        AbstractQueryImpl query = this.createQueryInstance();
        query.init(session, this.handler, node);
        return query;
    }

    public void start() {
    }

    public void stop() {
        this.close();
    }

    protected AbstractQueryImpl createQueryInstance() throws RepositoryException {
        try {
            Object obj = Class.forName("org.exoplatform.services.jcr.impl.core.query.QueryImpl").newInstance();
            if (obj instanceof AbstractQueryImpl) {
                this.activeQueries.put(obj, null);
                return (AbstractQueryImpl)obj;
            }
            throw new IllegalArgumentException("org.exoplatform.services.jcr.impl.core.query.QueryImpl is not of type " + AbstractQueryImpl.class.getName());
        }
        catch (Throwable t) {
            throw new RepositoryException("Unable to create query: " + t.toString());
        }
    }

    private void initializeQueryHandler() throws RepositoryException {
        try {
            this.handler.init();
        }
        catch (Exception e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    private synchronized void shutdownQueryHandler() throws IOException {
        if (this.handler != null) {
            this.handler.close();
            this.handler = null;
        }
    }

    private synchronized void ensureInitialized() throws RepositoryException {
        this.lastAccess = System.currentTimeMillis();
        if (this.handler == null) {
            this.initializeQueryHandler();
        }
    }
}

