/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import org.apache.commons.logging.Log;
import org.apache.lucene.search.Query;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AndQueryNode;
import org.exoplatform.services.jcr.impl.core.query.DefaultQueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.ExecutableQuery;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NotQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrderQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PathQueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryParser;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.TextsearchQueryNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.LuceneQueryBuilder;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.WorkspaceTraversalResult;
import org.exoplatform.services.log.ExoLogger;

class QueryImpl
implements ExecutableQuery {
    private static Log log = ExoLogger.getLogger((String)"jcr.QueryImpl");
    private static final QueryRootNode ALL_NODES = new QueryRootNode();
    private final QueryRootNode root;
    private final SessionImpl session;
    private final SearchIndex index;
    private boolean documentOrder = true;

    public QueryImpl(SessionImpl session, SearchIndex index, String statement, String language) throws InvalidQueryException {
        this.session = session;
        this.index = index;
        log.debug((Object)("Query Statement: " + statement));
        this.root = QueryParser.parse(statement, language, session.getLocationFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult execute() throws RepositoryException {
        ArrayList<Float> scores;
        ArrayList<String> uuids;
        Query query;
        LocationFactory locFactory = this.session.getLocationFactory();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Executing query: \n" + this.root.dump()));
        }
        if (ALL_NODES.equals(this.root)) {
            return new WorkspaceTraversalResult(this.session, new InternalQName[]{Constants.JCR_PATH});
        }
        try {
            query = LuceneQueryBuilder.createQuery(this.root, this.session, this.index.getSysLocationFactory(), this.index.getAnalyzer());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            throw new RepositoryException(e.getMessage());
        }
        OrderQueryNode orderNode = this.root.getOrderNode();
        OrderQueryNode.OrderSpec[] orderSpecs = orderNode != null ? orderNode.getOrderSpecs() : new OrderQueryNode.OrderSpec[]{};
        InternalQName[] orderProperties = new InternalQName[orderSpecs.length];
        boolean[] ascSpecs = new boolean[orderSpecs.length];
        for (int i = 0; i < orderSpecs.length; ++i) {
            orderProperties[i] = orderSpecs[i].getProperty();
            ascSpecs[i] = orderSpecs[i].isAscending();
        }
        QueryHits result = null;
        try {
            result = this.index.executeQuery(query, orderProperties, ascSpecs);
            uuids = new ArrayList<String>(result.length());
            scores = new ArrayList<Float>(result.length());
            for (int i = 0; i < result.length(); ++i) {
                String uuid = result.doc(i).get(FieldNames.UUID);
                uuids.add(uuid);
                scores.add(new Float(result.score(i)));
            }
        }
        catch (IOException e) {
            log.error((Object)"Exception while executing query: ", (Throwable)e);
            uuids = Collections.EMPTY_LIST;
            scores = Collections.EMPTY_LIST;
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Unable to close query result: " + e));
                }
            }
        }
        ArrayList<InternalQName> selectProps = new ArrayList<InternalQName>();
        selectProps.addAll(Arrays.asList(this.root.getSelectProperties()));
        if (selectProps.size() == 0) {
            LocationStepQueryNode[] steps = this.root.getLocationNode().getPathSteps();
            final InternalQName[] ntName = new InternalQName[1];
            steps[steps.length - 1].acceptOperands(new DefaultQueryNodeVisitor(){

                public Object visit(NodeTypeQueryNode node, Object data) {
                    ntName[0] = node.getValue();
                    return data;
                }
            }, null);
            if (ntName[0] == null) {
                ntName[0] = Constants.NT_BASE;
            }
            ExtendedNodeType nt = this.session.getWorkspace().getNodeTypeManager().getNodeType(ntName[0]);
            PropertyDefinition[] propDefs = nt.getPropertyDefinitions();
            for (int i = 0; i < propDefs.length; ++i) {
                if (propDefs[i].isMultiple()) continue;
                InternalQName qname = locFactory.parseJCRName(propDefs[i].getName()).getInternalName();
                selectProps.add(qname);
            }
        }
        selectProps.add(Constants.JCR_PATH);
        selectProps.add(Constants.JCR_SCORE);
        return new QueryResultImpl(this.session, uuids.toArray(new String[uuids.size()]), scores.toArray(new Float[scores.size()]), selectProps.toArray(new InternalQName[selectProps.size()]), orderNode == null && this.documentOrder);
    }

    public boolean getRespectDocumentOrder() {
        return this.documentOrder;
    }

    public void setRespectDocumentOrder(boolean documentOrder) {
        this.documentOrder = documentOrder;
    }

    private static boolean hasTextsearchNode(PathQueryNode node) {
        final boolean[] textsearch = new boolean[1];
        node.acceptOperands(new DefaultQueryNodeVisitor(){

            public Object visit(OrQueryNode node, Object data) {
                return node.acceptOperands(this, data);
            }

            public Object visit(AndQueryNode node, Object data) {
                return node.acceptOperands(this, data);
            }

            public Object visit(NotQueryNode node, Object data) {
                return node.acceptOperands(this, data);
            }

            public Object visit(TextsearchQueryNode node, Object data) {
                textsearch[0] = true;
                return data;
            }

            public Object visit(LocationStepQueryNode node, Object data) {
                return node.acceptOperands(this, data);
            }
        }, null);
        return textsearch[0];
    }

    public QueryRootNode getRoot() {
        return this.root;
    }

    static {
        PathQueryNode pathNode = new PathQueryNode(ALL_NODES);
        pathNode.addPathStep(new LocationStepQueryNode(pathNode, null, true));
        pathNode.setAbsolute(true);
        ALL_NODES.setLocationNode(pathNode);
    }
}

