/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.RedoLog;
import org.exoplatform.services.log.ExoLogger;

class Recovery {
    private static Log log = ExoLogger.getLogger((String)"jcr.Recovery");
    private final MultiIndex index;
    private final RedoLog redoLog;
    private final Set losers = new HashSet();

    private Recovery(MultiIndex index, RedoLog redoLog) {
        this.index = index;
        this.redoLog = redoLog;
    }

    static void run(MultiIndex index, RedoLog redoLog) throws IOException {
        if (!redoLog.hasEntries()) {
            log.debug((Object)"RedoLog is empty, no recovery needed.");
            return;
        }
        log.info((Object)"Found uncommitted redo log. Applying changes now...");
        Recovery r = new Recovery(index, redoLog);
        r.run();
        log.info((Object)"Redo changes applied.");
    }

    private void run() throws IOException {
        MultiIndex.Action a;
        int i;
        List actions = this.redoLog.getActions();
        for (MultiIndex.Action a2 : actions) {
            if (a2.getType() == 0) {
                this.losers.add(new Long(a2.getTransactionId()));
                continue;
            }
            if (a2.getType() != 3) continue;
            this.losers.remove(new Long(a2.getTransactionId()));
        }
        int lastSafeVolatileCommit = -1;
        HashSet<Long> transactionIds = new HashSet<Long>();
        for (i = 0; i < actions.size(); ++i) {
            a = (MultiIndex.Action)actions.get(i);
            if (a.getType() == 3) {
                transactionIds.clear();
                continue;
            }
            if (a.getType() == 4) {
                transactionIds.retainAll(this.losers);
                if (transactionIds.size() > 0) break;
                lastSafeVolatileCommit = i;
                continue;
            }
            transactionIds.add(new Long(a.getTransactionId()));
        }
        for (i = lastSafeVolatileCommit + 1; i < actions.size(); ++i) {
            a = (MultiIndex.Action)actions.get(i);
            if (a.getType() != 5) continue;
            a.undo(this.index);
        }
        for (i = 0; i < actions.size() && i <= lastSafeVolatileCommit; ++i) {
            a = (MultiIndex.Action)actions.get(i);
            switch (a.getType()) {
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    a.execute(this.index);
                }
            }
        }
        for (i = lastSafeVolatileCommit + 1; i < actions.size() && !this.losers.contains(new Long((a = (MultiIndex.Action)actions.get(i)).getTransactionId())); ++i) {
            a.execute(this.index);
        }
        this.index.flush();
    }
}

