/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.RowIteratorImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;

class WorkspaceTraversalResult
implements QueryResult {
    private final SessionImpl session;
    private final InternalQName[] properties;
    private final LocationFactory locationFactory;

    WorkspaceTraversalResult(SessionImpl session, InternalQName[] properties) {
        this.session = session;
        this.properties = properties;
        this.locationFactory = session.getLocationFactory();
    }

    public String[] getColumnNames() throws RepositoryException {
        String[] propNames = new String[this.properties.length];
        for (int i = 0; i < this.properties.length; ++i) {
            propNames[i] = this.locationFactory.createJCRName(this.properties[i]).getAsString();
        }
        return propNames;
    }

    public RowIterator getRows() throws RepositoryException {
        return new RowIteratorImpl(this.getNodeIterator(), this.properties, this.session);
    }

    public NodeIterator getNodes() throws RepositoryException {
        return this.getNodeIterator();
    }

    private ScoreNodeIterator getNodeIterator() throws RepositoryException {
        return new TraversingNodeIterator(this.session.getRootNode(), Offset.ZERO);
    }

    static interface Offset {
        public static final Offset ZERO = new Offset(){

            public long getValue() {
                return 0L;
            }
        };

        public long getValue();
    }

    private class TraversingNodeIterator
    implements ScoreNodeIterator,
    Offset {
        private final Node currentNode;
        private IteratorChain selfAndChildren;
        private final Offset offset;
        private long position;

        TraversingNodeIterator(Node start, Offset offset) {
            this.currentNode = start;
            this.offset = offset;
        }

        public float getScore() {
            return 1.0f;
        }

        public NodeImpl nextNodeImpl() {
            this.init();
            NodeImpl n = (NodeImpl)this.selfAndChildren.next();
            ++this.position;
            return n;
        }

        public Node nextNode() {
            return this.nextNodeImpl();
        }

        public void skip(long skipNum) {
            while (skipNum > 0L) {
                if (this.hasNext()) {
                    this.next();
                    --skipNum;
                    continue;
                }
                throw new NoSuchElementException();
            }
        }

        public long getSize() {
            return -1L;
        }

        public long getPosition() {
            return this.offset.getValue() + this.position;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public boolean hasNext() {
            this.init();
            return this.selfAndChildren.hasNext();
        }

        public Object next() {
            return this.nextNode();
        }

        public long getValue() {
            return this.getPosition() + 1L;
        }

        private void init() {
            if (this.selfAndChildren == null) {
                Iterator<Node> current = Arrays.asList(this.currentNode).iterator();
                ArrayList<Object> allIterators = new ArrayList<Object>();
                allIterators.add(current);
                Offset offset = new Offset(){

                    public long getValue() {
                        return TraversingNodeIterator.this.offset.getValue() + 1L;
                    }
                };
                try {
                    NodeIterator children = this.currentNode.getNodes();
                    while (children.hasNext()) {
                        offset = new TraversingNodeIterator(children.nextNode(), offset);
                        allIterators.add(offset);
                    }
                }
                catch (RepositoryException e) {
                    // empty catch block
                }
                this.selfAndChildren = new IteratorChain(allIterators);
            }
        }
    }
}

