/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.IOException;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.JCRName;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

public class NameValue
extends BaseValue {
    public static final int TYPE = 7;
    private final LocationFactory locationFactory;

    public NameValue(InternalQName name, LocationFactory locationFactory) throws IOException {
        super(7, new TransientValueData(name));
        this.locationFactory = locationFactory;
    }

    public NameValue(TransientValueData data, LocationFactory locationFactory) throws IOException {
        super(7, data);
        this.locationFactory = locationFactory;
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        JCRName name = this.locationFactory.createJCRName(this.getQName());
        return name.getAsString();
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("conversion to date failed: inconvertible types");
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("conversion to long failed: inconvertible types");
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("conversion to boolean failed: inconvertible types");
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("conversion to double failed: inconvertible types");
    }

    public InternalQName getQName() throws ValueFormatException, IllegalStateException, RepositoryException {
        return InternalQName.parse((String)this.getInternalString());
    }
}

