/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.value;

import java.io.IOException;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.datamodel.Uuid;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

public class ReferenceValue
extends BaseValue {
    public static final int TYPE = 9;
    private final Uuid uuid;

    public ReferenceValue(Node target) throws IOException, RepositoryException {
        super(9, new TransientValueData(new Uuid(target.getProperty("jcr:uuid").getString())));
        this.uuid = new Uuid(target.getProperty("jcr:uuid").getString());
    }

    public ReferenceValue(Uuid uuid) throws IOException {
        super(9, new TransientValueData(uuid));
        this.uuid = uuid;
    }

    public ReferenceValue(TransientValueData data) throws IOException, RepositoryException {
        super(9, data);
        this.uuid = new Uuid(this.getInternalString());
    }

    public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("conversion to date failed: inconvertible types");
    }

    public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("conversion to long failed: inconvertible types");
    }

    public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("conversion to boolean failed: inconvertible types");
    }

    public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
        throw new ValueFormatException("conversion to double failed: inconvertible types");
    }

    public String getReference() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.getInternalString();
    }

    public Uuid getUuid() {
        return this.uuid;
    }
}

