/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.version;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.version.ItemDataCopyIgnoredVisitor;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataCopyVisitor;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;
import org.exoplatform.services.jcr.util.UUIDGenerator;
import org.exoplatform.services.log.ExoLogger;

public class ItemDataRestoreVisitor
extends ItemDataTraversingVisitor {
    private static Log log = ExoLogger.getLogger((String)"jcr.ItemDataRestoreVisitor");
    protected final boolean removeExisting;
    protected final Stack<NodeDataContext> parents = new Stack();
    protected final NodeData context;
    protected final NodeData history;
    protected final InternalQName restoringName;
    protected NodeData restored;
    protected final NodeTypeManagerImpl ntManager;
    protected final SessionImpl userSession;
    protected final SessionChangesLog changes;
    protected final SessionChangesLog delegatedChanges;

    ItemDataRestoreVisitor(NodeData context, InternalQName restoringName, NodeData history, SessionImpl userSession, boolean removeExisting) throws RepositoryException {
        this(context, restoringName, history, userSession, removeExisting, null);
    }

    ItemDataRestoreVisitor(NodeData context, InternalQName restoringName, NodeData history, SessionImpl userSession, boolean removeExisting, SessionChangesLog delegatedChanges) throws RepositoryException {
        super((ItemDataConsumer)userSession.getTransientNodesManager().getTransactManager());
        this.userSession = userSession;
        this.changes = new SessionChangesLog(userSession.getId());
        this.context = context;
        this.restoringName = restoringName;
        this.history = history;
        this.parents.push(new NodeDataContext(context));
        this.removeExisting = removeExisting;
        this.ntManager = userSession.getWorkspace().getNodeTypeManager();
        this.delegatedChanges = delegatedChanges;
    }

    private NodeData currentNode() {
        return this.parents.peek().getNode();
    }

    private NodeData pushCurrent(NodeData node) {
        return this.parents.push(new NodeDataContext(node)).getNode();
    }

    private ItemData findDelegated(String uuid) {
        if (this.delegatedChanges != null) {
            for (ItemState state : this.delegatedChanges.getAllStates()) {
                if (!state.getData().getUUID().equals(uuid)) continue;
                return state.getData();
            }
        }
        return null;
    }

    private ItemData findDelegated(InternalQPath path) {
        if (this.delegatedChanges != null) {
            for (ItemState state : this.delegatedChanges.getAllStates()) {
                if (!state.getData().getQPath().equals((Object)path)) continue;
                return state.getData();
            }
        }
        return null;
    }

    private void deleteDelegated(InternalQPath path) {
        if (this.delegatedChanges != null) {
            ArrayList<ItemState> removed = new ArrayList<ItemState>();
            for (ItemState state : this.delegatedChanges.getAllStates()) {
                if (!state.getData().getQPath().equals((Object)path) && !state.getData().getQPath().isDescendantOf(path, false)) continue;
                removed.add(state);
            }
            for (ItemState state : removed) {
                this.delegatedChanges.remove(state.getData().getQPath());
            }
        }
    }

    protected void initRestoreRoot(NodeData parentData, InternalQName name, NodeData frozen) throws RepositoryException {
        NodeData existing;
        String fuuid;
        InternalQPath frozenPath;
        InternalQPath nodePath;
        block16: {
            nodePath = InternalQPath.makeChildPath((InternalQPath)parentData.getQPath(), (InternalQName)name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Restore: " + nodePath.getAsString() + ", removeExisting=" + this.removeExisting));
            }
            frozenPath = frozen.getQPath();
            InternalQPath frozenUuidPath = InternalQPath.makeChildPath((InternalQPath)frozenPath, (InternalQName)Constants.JCR_FROZENUUID);
            PropertyData frozenUuid = (PropertyData)this.dataManager.getItemData(frozenUuidPath);
            fuuid = null;
            existing = null;
            try {
                fuuid = new String(((ValueData)frozenUuid.getValues().get(0)).getAsByteArray());
                NodeData sameUuidNodeRestored = (NodeData)this.findDelegated(fuuid);
                if (sameUuidNodeRestored != null) {
                    this.deleteDelegated(sameUuidNodeRestored.getQPath());
                    break block16;
                }
                NodeData sameUuidNode = (NodeData)this.dataManager.getItemData(fuuid);
                if (sameUuidNode == null) break block16;
                InternalQPath sameUuidPath = sameUuidNode.getQPath();
                if (sameUuidPath.makeParentPath().equals((Object)nodePath.makeParentPath()) && sameUuidPath.getName().equals((Object)nodePath.getName())) {
                    if (sameUuidPath.getIndex() != nodePath.getIndex()) {
                        nodePath = InternalQPath.makeChildPath((InternalQPath)parentData.getQPath(), (InternalQName)name, (int)sameUuidPath.getIndex());
                    }
                    existing = sameUuidNode;
                    ItemDataRestoreVisitor.RemoveVisitor removeVisitor = new ItemDataRestoreVisitor.RemoveVisitor();
                    removeVisitor.visit(existing);
                    this.changes.addAll(removeVisitor.getRemovedStates());
                    break block16;
                }
                if (sameUuidPath.isDescendantOf(nodePath, false)) break block16;
                if (this.removeExisting) {
                    final InternalQPath restorePath = nodePath;
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class RemoveVisitor
                    extends ItemDataRemoveVisitor {
                        RemoveVisitor() {
                            super(ItemDataRestoreVisitor.this.userSession, true);
                        }

                        @Override
                        protected boolean isRemoveDescendant(ItemData item) throws RepositoryException {
                            return item.getQPath().isDescendantOf(this.removedRoot.getQPath(), false) || item.getQPath().isDescendantOf(restorePath, false);
                        }
                    }
                    RemoveVisitor removeVisitor = new RemoveVisitor();
                    removeVisitor.visit(sameUuidNode);
                    this.changes.addAll(removeVisitor.getRemovedStates());
                    break block16;
                }
                throw new ItemExistsException("Item with the same UUID as restored node " + nodePath.getAsString() + " already exists and removeExisting=false. Existed " + sameUuidPath.getAsString() + " " + sameUuidNode.getUUID());
            }
            catch (IllegalStateException e) {
                throw new RepositoryException("jcr:frozenUuid, error of data read " + frozenUuid.getQPath().getAsString(), (Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException("jcr:frozenUuid, error of data read " + frozenUuid.getQPath().getAsString(), (Throwable)e);
            }
        }
        InternalQPath frozenPrimaryTypePath = InternalQPath.makeChildPath((InternalQPath)frozenPath, (InternalQName)Constants.JCR_FROZENPRIMARYTYPE);
        PropertyData frozenPrimaryType = (PropertyData)this.dataManager.getItemData(frozenPrimaryTypePath);
        InternalQPath frozenMixinTypesPath = InternalQPath.makeChildPath((InternalQPath)frozenPath, (InternalQName)Constants.JCR_FROZENMIXINTYPES);
        PropertyData frozenMixinTypes = (PropertyData)this.dataManager.getItemData(frozenMixinTypesPath);
        InternalQName[] mixins = null;
        if (frozenMixinTypes != null) {
            try {
                List mvs = frozenMixinTypes.getValues();
                mixins = new InternalQName[mvs.size()];
                for (int i = 0; i < mvs.size(); ++i) {
                    ValueData mvd = (ValueData)mvs.get(i);
                    mixins[i] = InternalQName.parse((String)new String(mvd.getAsByteArray()));
                }
            }
            catch (IllegalStateException e) {
                throw new RepositoryException("jcr:frozenMixinTypes, error of data read " + frozenMixinTypes.getQPath().getAsString(), (Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException("jcr:frozenMixinTypes, error of data read " + frozenMixinTypes.getQPath().getAsString(), (Throwable)e);
            }
        }
        InternalQName ptName = null;
        try {
            ptName = InternalQName.parse((String)new String(((ValueData)frozenPrimaryType.getValues().get(0)).getAsByteArray()));
        }
        catch (IllegalStateException e) {
            throw new RepositoryException("jcr:frozenPrimaryType, error of data read " + frozenPrimaryType.getQPath().getAsString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException("jcr:frozenPrimaryType, error of data read " + frozenPrimaryType.getQPath().getAsString(), (Throwable)e);
        }
        TransientNodeData restoredData = new TransientNodeData(nodePath, fuuid, existing != null ? existing.getPersistedVersion() : -1, ptName, mixins == null ? new InternalQName[]{} : mixins, 0, parentData.getUUID(), parentData.getACL());
        this.changes.add(ItemState.createAddedState((ItemData)restoredData));
        this.pushCurrent((NodeData)restoredData);
    }

    protected void entering(NodeData frozen, int level) throws RepositoryException {
        if (frozen == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Visit node " + frozen.getQPath().getAsString() + ", HAS NULL FROZEN NODE"));
            }
            return;
        }
        InternalQName qname = frozen.getQPath().getName();
        if (qname.equals((Object)Constants.JCR_FROZENNODE) && level == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("jcr:frozenNode " + frozen.getQPath().getAsString()));
            }
            this.initRestoreRoot(this.currentNode(), this.restoringName, frozen);
            this.restored = this.currentNode();
        } else if (this.ntManager.isNodeType(Constants.NT_VERSIONEDCHILD, frozen.getPrimaryTypeName())) {
            InternalQPath cvhpPropPath = InternalQPath.makeChildPath((InternalQPath)frozen.getQPath(), (InternalQName)Constants.JCR_CHILDVERSIONHISTORY);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Versioned child node " + cvhpPropPath.getAsString()));
            }
            VersionHistoryDataHelper childHistory = null;
            try {
                String vhUuid = new String(((ValueData)((PropertyData)this.dataManager.getItemData(cvhpPropPath)).getValues().get(0)).getAsByteArray());
                NodeData cHistory = null;
                cHistory = (NodeData)this.dataManager.getItemData(vhUuid);
                if (cHistory == null) {
                    throw new RepositoryException("Version history is not found with uuid " + vhUuid);
                }
                childHistory = new VersionHistoryDataHelper(cHistory, this.dataManager, this.ntManager);
            }
            catch (IllegalStateException e) {
                throw new RepositoryException("jcr:childVersionHistory, error of data read " + cvhpPropPath.getAsString(), (Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException("jcr:childVersionHistory, error of data read " + cvhpPropPath.getAsString(), (Throwable)e);
            }
            InternalQPath cvhVersionableUuidPath = InternalQPath.makeChildPath((InternalQPath)childHistory.getQPath(), (InternalQName)Constants.JCR_VERSIONABLEUUID);
            String versionableUuid = null;
            try {
                versionableUuid = new String(((ValueData)((PropertyData)this.dataManager.getItemData(cvhVersionableUuidPath)).getValues().get(0)).getAsByteArray());
            }
            catch (IOException e) {
                throw new RepositoryException("jcr:childVersionHistory, error of data read " + cvhpPropPath.getAsString(), (Throwable)e);
            }
            NodeData versionable = (NodeData)this.dataManager.getItemData(versionableUuid);
            if (versionable != null) {
                if (!this.removeExisting) {
                    throw new ItemExistsException("Item with the same UUID " + versionableUuid + " as versionable child node " + versionable.getQPath().getAsString() + " already exists and removeExisting=false");
                }
            } else {
                NodeData lastVersionData = childHistory.getLastVersionData();
                InternalQPath cvFrozenPath = InternalQPath.makeChildPath((InternalQPath)lastVersionData.getQPath(), (InternalQName)Constants.JCR_FROZENNODE);
                NodeData cvFrozen = (NodeData)this.dataManager.getItemData(cvFrozenPath);
                ItemDataRestoreVisitor restoreVisitor = new ItemDataRestoreVisitor(this.currentNode(), qname, (NodeData)childHistory, this.userSession, this.removeExisting, this.changes);
                cvFrozen.accept((ItemDataVisitor)restoreVisitor);
                this.changes.addAll(restoreVisitor.getRestoreChanges().getAllStates());
            }
            this.pushCurrent(null);
        } else if (this.currentNode() != null) {
            int action = this.ntManager.findNodeDefinition(qname, this.currentNode().getPrimaryTypeName(), this.currentNode().getMixinTypeNames()).getOnParentVersion();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Stored node " + frozen.getQPath().getAsString() + ", " + OnParentVersionAction.nameFromValue((int)action)));
            }
            if (action == 1 || action == 2) {
                InternalQPath restoredPath = InternalQPath.makeChildPath((InternalQPath)this.currentNode().getQPath(), (InternalQName)frozen.getQPath().getName(), (int)frozen.getQPath().getIndex());
                String jcrUuid = null;
                NodeData existing = null;
                if (this.ntManager.isNodeType(Constants.MIX_REFERENCEABLE, frozen.getPrimaryTypeName(), frozen.getMixinTypeNames())) {
                    InternalQPath jcrUuidPath = InternalQPath.makeChildPath((InternalQPath)frozen.getQPath(), (InternalQName)Constants.JCR_UUID);
                    try {
                        jcrUuid = new String(((ValueData)((PropertyData)this.dataManager.getItemData(jcrUuidPath)).getValues().get(0)).getAsByteArray());
                    }
                    catch (IOException e) {
                        throw new RepositoryException("jcr:uuid, error of data read " + jcrUuidPath.getAsString(), (Throwable)e);
                    }
                    existing = (NodeData)this.dataManager.getItemData(jcrUuid);
                } else {
                    existing = (NodeData)this.dataManager.getItemData(restoredPath);
                    jcrUuid = existing != null ? existing.getUUID() : UUIDGenerator.generate();
                }
                if (existing != null && !existing.getQPath().isDescendantOf(this.restored.getQPath(), false)) {
                    NodeData existingDelegared = (NodeData)this.findDelegated(existing.getQPath());
                    if (existingDelegared != null) {
                        this.deleteDelegated(existing.getQPath());
                    } else if (this.removeExisting) {
                        RemoveVisitor removeVisitor = new RemoveVisitor();
                        removeVisitor.visit(existing);
                        this.changes.addAll(removeVisitor.getRemovedStates());
                    } else {
                        throw new ItemExistsException("Node with the same UUID as restored child node " + restoredPath.getAsString() + " already exists and removeExisting=false. Existed " + existing.getQPath().getAsString() + " " + existing.getUUID());
                    }
                }
                TransientNodeData restoredData = new TransientNodeData(restoredPath, jcrUuid, frozen.getPersistedVersion(), frozen.getPrimaryTypeName(), frozen.getMixinTypeNames(), frozen.getOrderNumber(), this.currentNode().getUUID(), frozen.getACL());
                this.changes.add(ItemState.createAddedState((ItemData)restoredData));
                this.pushCurrent((NodeData)restoredData);
            } else if (action == 3 || action == 4) {
                InternalQPath existedPath = InternalQPath.makeChildPath((InternalQPath)this.currentNode().getQPath(), (InternalQName)frozen.getQPath().getName());
                NodeData existed = (NodeData)this.dataManager.getItemData(existedPath);
                if (existed != null) {
                    ItemDataCopyVisitor copyVisitor = new ItemDataCopyVisitor(this.currentNode(), frozen.getQPath().getName(), this.ntManager, this.userSession.getTransientNodesManager(), true);
                    existed.accept((ItemDataVisitor)copyVisitor);
                    this.changes.addAll(copyVisitor.getItemAddStates());
                }
                this.pushCurrent(null);
            }
        }
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        if (this.currentNode() != null) {
            NodeData frozenParent = (NodeData)this.dataManager.getItemData(property.getParentUUID());
            InternalQName qname = property.getQPath().getName();
            if (this.ntManager.isNodeType(Constants.NT_FROZENNODE, frozenParent.getPrimaryTypeName())) {
                if (qname.equals((Object)Constants.JCR_FROZENPRIMARYTYPE)) {
                    qname = Constants.JCR_PRIMARYTYPE;
                } else if (qname.equals((Object)Constants.JCR_FROZENUUID)) {
                    qname = Constants.JCR_UUID;
                } else if (qname.equals((Object)Constants.JCR_FROZENMIXINTYPES)) {
                    qname = Constants.JCR_MIXINTYPES;
                } else if (qname.equals((Object)Constants.JCR_PRIMARYTYPE) || qname.equals((Object)Constants.JCR_UUID) || qname.equals((Object)Constants.JCR_MIXINTYPES)) {
                    return;
                }
            }
            int action = this.ntManager.findPropertyDefinition(qname, this.currentNode().getPrimaryTypeName(), this.currentNode().getMixinTypeNames()).getOnParentVersion();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Visit property " + property.getQPath().getAsString() + " " + this.currentNode().getQPath().getAsString() + " " + OnParentVersionAction.nameFromValue((int)action)));
            }
            if (action == 1 || action == 2 || action == 3 || action == 4) {
                TransientPropertyData tagetProperty = TransientPropertyData.createPropertyData(this.currentNode(), qname, property.getType(), property.isMultiValued(), property.getValues());
                this.changes.add(ItemState.createAddedState((ItemData)tagetProperty));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Visit property " + property.getQPath().getAsString() + " HAS " + OnParentVersionAction.nameFromValue((int)action) + " action"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Visit property " + property.getQPath().getAsString() + " HAS NULL PARENT. Restore of this property is impossible."));
        }
    }

    protected void leaving(NodeData frozen, int level) throws RepositoryException {
        InternalQName qname = frozen.getQPath().getName();
        if (qname.equals((Object)Constants.JCR_FROZENNODE) && level == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("leaving jcr:frozenNode " + frozen.getQPath().getAsString()));
            }
            TransientPropertyData baseVersion = TransientPropertyData.createPropertyData(this.restored, Constants.JCR_BASEVERSION, 9, false, new TransientValueData(frozen.getParentUUID()));
            TransientPropertyData isCheckedOut = TransientPropertyData.createPropertyData(this.restored, Constants.JCR_ISCHECKEDOUT, 6, false, new TransientValueData(false));
            NodeData existing = (NodeData)this.dataManager.getItemData(this.restored.getUUID());
            if (existing != null && !existing.getQPath().isDescendantOf(Constants.JCR_VERSION_STORAGE_PATH, false)) {
                ItemDataCopyIgnoredVisitor copyIgnoredVisitor = new ItemDataCopyIgnoredVisitor((NodeData)this.dataManager.getItemData(this.restored.getParentUUID()), this.restored.getQPath().getName(), this.ntManager, this.userSession.getTransientNodesManager(), this.changes);
                existing.accept((ItemDataVisitor)copyIgnoredVisitor);
                this.changes.addAll(copyIgnoredVisitor.getItemAddStates());
            }
            this.changes.add(ItemState.createAddedState((ItemData)baseVersion));
            this.changes.add(ItemState.createAddedState((ItemData)isCheckedOut));
        }
        if (this.parents.size() <= 0) {
            log.error((Object)"Empty parents stack");
        }
        this.parents.pop();
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    public SessionChangesLog getRestoreChanges() {
        return this.changes;
    }

    public NodeData getRestoreRoot() {
        return this.restored;
    }

    protected class RemoveVisitor
    extends ItemDataRemoveVisitor {
        RemoveVisitor() {
            super(ItemDataRestoreVisitor.this.userSession, true);
        }

        protected void validateReferential(NodeData node) throws RepositoryException {
        }
    }

    protected class NodeDataContext {
        private final NodeData node;
        private final boolean existing;

        protected NodeDataContext(NodeData node) {
            this.node = node;
            this.existing = false;
        }

        protected NodeDataContext(NodeData node, boolean existing) {
            this.node = node;
            this.existing = existing;
        }

        protected NodeData getNode() {
            return this.node;
        }

        public boolean isExisting() {
            return this.existing;
        }
    }
}

