/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.util.UUIDGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDataCopyVisitor
extends ItemDataTraversingVisitor {
    private InternalQName destNodeName;
    protected Stack<NodeData> parents;
    protected List<ItemState> itemAddStates = new ArrayList<ItemState>();
    protected boolean keepUUIDs;
    protected NodeTypeManagerImpl ntManager;
    protected InternalQPath ancestorToSave = null;

    public ItemDataCopyVisitor(NodeData parent, InternalQName destNodeName, NodeTypeManagerImpl nodeTypeManager, SessionDataManager dataManager, boolean keepUUIDs) {
        super((ItemDataConsumer)dataManager);
        this.keepUUIDs = keepUUIDs;
        this.ntManager = nodeTypeManager;
        this.destNodeName = destNodeName;
        this.parents = new Stack();
        this.parents.add(parent);
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        ArrayList<ValueData> values;
        InternalQName qname = property.getQPath().getName();
        if (this.ntManager.isNodeType(Constants.MIX_REFERENCEABLE, this.curParent().getPrimaryTypeName(), this.curParent().getMixinTypeNames()) && qname.equals((Object)Constants.JCR_UUID)) {
            values = new ArrayList<ValueData>(1);
            values.add(new TransientValueData(this.curParent().getUUID()));
        } else {
            values = property.getValues();
        }
        TransientPropertyData newProperty = TransientPropertyData.createPropertyData(this.curParent(), qname, property.getType(), property.isMultiValued(), values);
        this.itemAddStates.add(new ItemState((ItemData)newProperty, 1, true, this.ancestorToSave, level != 0));
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        if (this.ancestorToSave == null) {
            this.ancestorToSave = this.curParent().getQPath();
        }
        InternalQName qname = null;
        List existedChilds = this.dataManager.getChildNodesData(this.curParent());
        int newIndex = 1;
        if (level == 0) {
            qname = this.destNodeName;
            for (NodeData child : existedChilds) {
                if (!child.getQPath().getName().equals((Object)qname)) continue;
                ++newIndex;
            }
        } else {
            qname = node.getQPath().getName();
            newIndex = node.getQPath().getIndex();
        }
        TransientNodeData newNode = TransientNodeData.createNodeData(this.curParent(), qname, node.getPrimaryTypeName(), newIndex);
        newNode.setMixinTypeNames(node.getMixinTypeNames());
        newNode.setACL(node.getACL());
        if (this.ntManager.isOrderableChildNodesSupported(this.curParent().getPrimaryTypeName(), this.curParent().getMixinTypeNames())) {
            if (existedChilds.size() > 0) {
                newNode.setOrderNumber(((NodeData)existedChilds.get(existedChilds.size() - 1)).getOrderNumber() + 1);
            } else {
                newNode.setOrderNumber(0);
            }
        } else {
            newNode.setOrderNumber(node.getOrderNumber());
        }
        if (this.keepUUIDs) {
            newNode.setUUID(node.getUUID());
        } else {
            newNode.setUUID(UUIDGenerator.generate());
        }
        this.parents.push((NodeData)newNode);
        this.itemAddStates.add(new ItemState((ItemData)newNode, 1, true, this.ancestorToSave, level != 0));
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
        this.parents.pop();
    }

    protected NodeData curParent() {
        return this.parents.peek();
    }

    public List<ItemState> getItemAddStates() {
        return this.itemAddStates;
    }
}

