/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataCopyVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDataMoveVisitor
extends ItemDataCopyVisitor {
    protected List<ItemState> itemDeletedStates = new ArrayList<ItemState>();

    public ItemDataMoveVisitor(NodeData parent, InternalQName dstNodeName, NodeTypeManagerImpl nodeTypeManager, SessionDataManager srcDataManager, boolean keepUUIDs) {
        super(parent, dstNodeName, nodeTypeManager, srcDataManager, keepUUIDs);
    }

    @Override
    protected void entering(NodeData node, int level) throws RepositoryException {
        if (this.ancestorToSave == null) {
            this.ancestorToSave = InternalQPath.getPrimogenitorPath((InternalQPath)this.curParent().getQPath(), (InternalQPath)node.getQPath());
        }
        super.entering(node, level);
        if (level > 0) {
            ((ItemState)this.itemAddStates.get(this.itemAddStates.size() - 1)).eraseEventFire();
        }
        this.itemDeletedStates.add(new ItemState((ItemData)node, 3, level == 0, this.ancestorToSave));
    }

    @Override
    protected void entering(PropertyData property, int level) throws RepositoryException {
        super.entering(property, level);
        List vals = property.getValues();
        for (ValueData valueData : vals) {
            ((TransientValueData)valueData).lock();
        }
        if (level > 1) {
            ((ItemState)this.itemAddStates.get(this.itemAddStates.size() - 1)).eraseEventFire();
        }
        this.itemDeletedStates.add(new ItemState((ItemData)property, 3, level == 1, this.ancestorToSave));
    }

    public List<ItemState> getItemDeletedStates(boolean isInverse) {
        if (isInverse) {
            Collections.reverse(this.itemDeletedStates);
        }
        return this.itemDeletedStates;
    }
}

