/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataTraversingVisitor;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemDataRemoveVisitor
extends ItemDataTraversingVisitor {
    private static Log log = ExoLogger.getLogger((String)"jcr.ItemDataRemoveVisitor");
    protected List<ItemState> itemRemovedStates = new ArrayList<ItemState>();
    protected List<ItemState> reversedItemRemovedStates = null;
    protected final SessionImpl session;
    protected final boolean validate;
    protected NodeData removedRoot = null;

    public ItemDataRemoveVisitor(ItemDataConsumer dataManager) {
        super(dataManager);
        this.session = null;
        this.validate = false;
    }

    public ItemDataRemoveVisitor(SessionImpl session, boolean validate) {
        super((ItemDataConsumer)session.getTransientNodesManager());
        this.session = session;
        this.validate = validate;
    }

    protected void validate(PropertyData property) throws RepositoryException {
        this.validateAccessDenied(property);
        this.validateConstraints(property);
        this.validateVersion(property);
        this.validateLock(property);
    }

    protected void validateAccessDenied(PropertyData property) throws RepositoryException {
        NodeData parent = (NodeData)this.dataManager.getItemData(property.getParentUUID());
        if (!this.session.getAccessManager().hasPermission(parent.getACL(), "read", this.session.getUserID())) {
            throw new AccessDeniedException("Access denied " + this.session.getLocationFactory().createJCRPath(property.getQPath()).getAsString(false) + " for " + this.session.getUserID() + " (get item parent by uuid)");
        }
    }

    protected void validateConstraints(PropertyData property) throws RepositoryException {
    }

    protected void validateVersion(PropertyData property) throws RepositoryException {
    }

    protected void validateLock(PropertyData property) throws RepositoryException {
    }

    protected void validate(NodeData node) throws RepositoryException {
        this.validateAccessDenied(node);
        if (this.session.getWorkspace().getNodeTypeManager().isNodeType(Constants.MIX_REFERENCEABLE, node.getPrimaryTypeName(), node.getMixinTypeNames())) {
            this.validateReferential(node);
        }
        this.validateConstraints(node);
        this.validateVersion(node);
        this.validateLock(node);
    }

    protected void validateAccessDenied(NodeData node) throws RepositoryException {
        if (!this.session.getAccessManager().hasPermission(node.getACL(), "read", this.session.getUserID())) {
            throw new AccessDeniedException("Access denied " + this.session.getLocationFactory().createJCRPath(node.getQPath()).getAsString(false) + " for " + this.session.getUserID() + " (get item by uuid)");
        }
    }

    protected void validateReferential(NodeData node) throws RepositoryException {
        List refs = this.dataManager.getReferencesData(node.getUUID());
        for (PropertyData rpd : refs) {
            if (this.isRemoveDescendant((ItemData)this.removedRoot)) {
                this.entering(rpd, this.currentLevel);
                continue;
            }
            NodeData refParent = (NodeData)this.dataManager.getItemData(rpd.getParentUUID());
            if (!this.session.getAccessManager().hasPermission(refParent.getACL(), "read", this.session.getUserID())) {
                throw new AccessDeniedException("Access denied " + this.session.getLocationFactory().createJCRPath(rpd.getQPath()).getAsString(false) + " for " + this.session.getUserID() + " (get reference property parent by uuid)");
            }
            throw new ReferentialIntegrityException("This node " + this.session.getLocationFactory().createJCRPath(node.getQPath()).getAsString(false) + " is currently the target of a REFERENCE property " + this.session.getLocationFactory().createJCRPath(rpd.getQPath()).getAsString(false) + " located in this workspace. Session id: " + this.session.getUserID());
        }
    }

    protected boolean isRemoveDescendant(ItemData item) throws RepositoryException {
        return item.getQPath().isDescendantOf(this.removedRoot.getQPath(), false);
    }

    protected void validateConstraints(NodeData node) throws RepositoryException {
    }

    protected void validateVersion(NodeData node) throws RepositoryException {
    }

    protected void validateLock(NodeData node) throws RepositoryException {
    }

    protected void entering(PropertyData property, int level) throws RepositoryException {
        ItemState state;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering property " + property.getQPath().getAsString()));
        }
        if (this.validate) {
            this.validate(property);
        }
        if (!this.itemRemovedStates.contains(state = ItemState.createDeletedState((ItemData)property))) {
            this.itemRemovedStates.add(state);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("A property " + property.getQPath().getAsString() + " is already listed for remove"));
        }
    }

    protected void entering(NodeData node, int level) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entering node " + node.getQPath().getAsString()));
        }
        if (level == 0) {
            this.removedRoot = node;
        }
        if (this.validate) {
            this.validate(node);
        }
        this.itemRemovedStates.add(ItemState.createDeletedState((ItemData)node));
    }

    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    protected void leaving(NodeData node, int level) throws RepositoryException {
    }

    public List<ItemState> getRemovedStates() {
        if (this.reversedItemRemovedStates == null) {
            Collections.reverse(this.itemRemovedStates);
            this.reversedItemRemovedStates = this.itemRemovedStates;
        }
        return this.reversedItemRemovedStates;
    }
}

