/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.MutableItemData;

public abstract class TransientItemData
implements MutableItemData,
Externalizable {
    protected InternalQPath QPath;
    protected String UUID;
    protected String parentUUID;
    protected int persistedVersion;

    TransientItemData(InternalQPath path, String uuid, int version, String parentUUID) {
        this.parentUUID = parentUUID != null ? parentUUID.intern() : null;
        this.UUID = uuid.intern();
        this.QPath = path;
        this.persistedVersion = version;
    }

    protected int initHashCode() {
        int prime = 31;
        int hcode = 31 * this.UUID.hashCode();
        return hcode;
    }

    public InternalQPath getQPath() {
        return this.QPath;
    }

    public String getUUID() {
        return this.UUID;
    }

    public int getPersistedVersion() {
        return this.persistedVersion;
    }

    public String getParentUUID() {
        return this.parentUUID;
    }

    public void increasePersistedVersion() {
        ++this.persistedVersion;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ItemData) {
            return this.getUUID().hashCode() == ((ItemData)obj).getUUID().hashCode();
        }
        return false;
    }

    public InternalQName getQName() {
        return this.QPath.getName();
    }

    TransientItemData() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.QPath.getAsString().getBytes().length);
        out.write(this.QPath.getAsString().getBytes());
        out.writeInt(this.UUID.getBytes().length);
        out.write(this.UUID.getBytes());
        out.writeInt(this.parentUUID.getBytes().length);
        out.write(this.parentUUID.getBytes());
        out.writeInt(this.persistedVersion);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buf;
        try {
            buf = new byte[in.readInt()];
            in.read(buf);
            String sQPath = new String(buf, "UTF-8");
            this.QPath = InternalQPath.parse((String)sQPath);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
        }
        buf = new byte[in.readInt()];
        in.read(buf);
        this.UUID = new String(buf, "UTF-8").intern();
        buf = new byte[in.readInt()];
        in.read(buf);
        this.parentUUID = new String(buf, "UTF-8").intern();
        this.persistedVersion = in.readInt();
    }
}

