/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.IllegalPathException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.MutableNodeData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.TraverseableNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.util.UUIDGenerator;

public class TransientNodeData
extends TransientItemData
implements Comparable,
MutableNodeData,
TraverseableNodeData,
Externalizable,
Cloneable {
    private InternalQName primaryTypeName;
    private InternalQName[] mixinTypeNames;
    private int orderNum;
    private AccessControlList acl;

    public TransientNodeData(InternalQPath path, String uuid, int version, InternalQName primaryTypeName, InternalQName[] mixinTypeNames, int orderNum, String parentUUID, AccessControlList acl) {
        super(path, uuid, version, parentUUID);
        this.primaryTypeName = primaryTypeName;
        this.mixinTypeNames = mixinTypeNames;
        this.orderNum = orderNum;
        this.acl = acl;
    }

    public boolean isNode() {
        return true;
    }

    public int getOrderNumber() {
        return this.orderNum;
    }

    public InternalQName getPrimaryTypeName() {
        return this.primaryTypeName;
    }

    public InternalQName[] getMixinTypeNames() {
        return this.mixinTypeNames;
    }

    public AccessControlList getACL() {
        return this.acl;
    }

    public void setOrderNumber(int orderNum) {
        this.orderNum = orderNum;
    }

    public void setMixinTypeNames(InternalQName[] mixinTypeNames) {
        this.mixinTypeNames = mixinTypeNames;
    }

    public void setUUID(String uuid) {
        this.UUID = uuid;
    }

    public void setACL(AccessControlList acl) {
        this.acl = acl;
    }

    public void accept(ItemDataVisitor visitor) throws RepositoryException {
        visitor.visit((NodeData)this);
    }

    public static TransientNodeData createNodeData(NodeData parent, InternalQName name, InternalQName primaryTypeName) {
        TransientNodeData nodeData = null;
        InternalQPath path = InternalQPath.makeChildPath((InternalQPath)parent.getQPath(), (InternalQName)name);
        nodeData = new TransientNodeData(path, UUIDGenerator.generate(), -1, primaryTypeName, new InternalQName[0], 0, parent.getUUID(), parent.getACL());
        return nodeData;
    }

    public static TransientNodeData createNodeData(NodeData parent, InternalQName name, InternalQName primaryTypeName, int index) {
        TransientNodeData nodeData = null;
        InternalQPath path = InternalQPath.makeChildPath((InternalQPath)parent.getQPath(), (InternalQName)name, (int)index);
        nodeData = new TransientNodeData(path, UUIDGenerator.generate(), -1, primaryTypeName, new InternalQName[0], 0, parent.getUUID(), parent.getACL());
        return nodeData;
    }

    public static TransientNodeData createNodeData(NodeData parent, InternalQName name, InternalQName primaryTypeName, String uuid) {
        TransientNodeData nodeData = null;
        InternalQPath path = InternalQPath.makeChildPath((InternalQPath)parent.getQPath(), (InternalQName)name);
        nodeData = new TransientNodeData(path, uuid, -1, primaryTypeName, new InternalQName[0], 0, parent.getUUID(), parent.getACL());
        return nodeData;
    }

    public int compareTo(Object obj) {
        return ((NodeData)obj).getOrderNumber() - this.orderNum;
    }

    public TransientNodeData() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.orderNum);
        out.writeInt(this.primaryTypeName.getAsString().getBytes().length);
        out.write(this.primaryTypeName.getAsString().getBytes());
        out.writeInt(this.mixinTypeNames.length);
        for (int i = 0; i < this.mixinTypeNames.length; ++i) {
            out.writeInt(this.mixinTypeNames[i].getAsString().getBytes().length);
            out.write(this.mixinTypeNames[i].getAsString().getBytes());
        }
        out.writeObject(this.acl);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buf;
        super.readExternal(in);
        this.orderNum = in.readInt();
        try {
            buf = new byte[in.readInt()];
            in.read(buf);
            String sQName = new String(buf, "UTF-8");
            this.primaryTypeName = InternalQName.parse((String)sQName);
        }
        catch (IllegalNameException e) {
            e.printStackTrace();
        }
        int count = in.readInt();
        this.mixinTypeNames = new InternalQName[count];
        for (int i = 0; i < count; ++i) {
            try {
                buf = new byte[in.readInt()];
                in.read(buf);
                String sQName = new String(buf, "UTF-8");
                this.mixinTypeNames[i] = InternalQName.parse((String)sQName);
                continue;
            }
            catch (IllegalNameException e) {
                e.printStackTrace();
            }
        }
        this.acl = (AccessControlList)in.readObject();
    }

    public TransientNodeData clone() {
        TransientNodeData dataCopy = new TransientNodeData(this.getQPath(), this.getUUID(), this.getPersistedVersion(), this.getPrimaryTypeName(), this.getMixinTypeNames(), this.getOrderNumber(), this.getParentUUID() != null ? this.getParentUUID() : null, this.getACL());
        return dataCopy;
    }

    public TransientNodeData cloneAsSibling(int index) throws PathNotFoundException, IllegalPathException {
        InternalQPath siblingPath = InternalQPath.makeChildPath((InternalQPath)this.getQPath().makeParentPath(), (InternalQName)this.getQPath().getName(), (int)index);
        TransientNodeData dataCopy = new TransientNodeData(siblingPath, this.getUUID(), this.getPersistedVersion(), this.getPrimaryTypeName(), this.getMixinTypeNames(), this.getOrderNumber(), this.getParentUUID() != null ? this.getParentUUID() : null, this.getACL());
        return dataCopy;
    }
}

