/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.MutablePropertyData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.util.UUIDGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransientPropertyData
extends TransientItemData
implements MutablePropertyData,
Externalizable {
    private List<ValueData> values;
    private int type;
    private boolean multiValued = false;

    public TransientPropertyData(InternalQPath path, String uuid, int version, int type, String parentUUID, boolean multiValued) {
        super(path, uuid, version, parentUUID);
        this.type = type;
        this.multiValued = multiValued;
    }

    public boolean isNode() {
        return false;
    }

    public int getType() {
        return this.type;
    }

    public List<ValueData> getValues() {
        return this.values;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public void setValues(List<ValueData> values) {
        this.values = values;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setValue(ValueData value) {
        this.values = new ArrayList<ValueData>();
        this.values.add(value);
    }

    public static TransientPropertyData createPropertyData(NodeData parent, InternalQName name, int type, boolean multiValued) {
        TransientPropertyData propData = null;
        InternalQPath path = InternalQPath.makeChildPath((InternalQPath)parent.getQPath(), (InternalQName)name);
        propData = new TransientPropertyData(path, UUIDGenerator.generate(), -1, type, parent.getUUID(), multiValued);
        return propData;
    }

    public static TransientPropertyData createPropertyData(NodeData parent, InternalQName name, int type, boolean multiValued, ValueData value) {
        TransientPropertyData propData = TransientPropertyData.createPropertyData(parent, name, type, multiValued);
        propData.setValue(value);
        return propData;
    }

    public static TransientPropertyData createPropertyData(NodeData parent, InternalQName name, int type, boolean multiValued, List<ValueData> values) {
        TransientPropertyData propData = TransientPropertyData.createPropertyData(parent, name, type, multiValued);
        propData.setValues(values);
        return propData;
    }

    public void accept(ItemDataVisitor visitor) throws RepositoryException {
        visitor.visit((PropertyData)this);
    }

    public TransientPropertyData clone() {
        TransientPropertyData dataCopy = new TransientPropertyData(this.getQPath(), this.getUUID(), this.getPersistedVersion(), this.getType(), this.getParentUUID(), this.isMultiValued());
        ArrayList<ValueData> copyValues = new ArrayList<ValueData>();
        for (ValueData vdata : this.getValues()) {
            copyValues.add(((TransientValueData)vdata).createTransientCopy());
        }
        dataCopy.setValues(copyValues);
        return dataCopy;
    }

    public TransientPropertyData() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.type);
        out.writeBoolean(this.multiValued);
        int listSize = this.values.size();
        out.writeInt(listSize);
        for (int i = 0; i < listSize; ++i) {
            out.writeObject(this.values.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.type = in.readInt();
        this.multiValued = in.readBoolean();
        this.values = new ArrayList<ValueData>();
        int listSize = in.readInt();
        for (int i = 0; i < listSize; ++i) {
            this.values.add((ValueData)in.readObject());
        }
    }
}

