/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ACLInheritanceSupportedWorkspaceDataManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionableWorkspaceDataManager
extends ACLInheritanceSupportedWorkspaceDataManager {
    private static Log log = ExoLogger.getLogger((String)"jcr.VersionableWorkspaceDataManager");
    private ACLInheritanceSupportedWorkspaceDataManager versionDataManager;

    public VersionableWorkspaceDataManager(CacheableWorkspaceDataManager persistentManager) {
        super(persistentManager);
    }

    public void setSystemDataManager(DataManager systemDataManager) {
        this.versionDataManager = (ACLInheritanceSupportedWorkspaceDataManager)systemDataManager;
    }

    @Override
    public List<NodeData> getChildNodesData(NodeData nodeData) throws RepositoryException {
        InternalQPath path = nodeData.getQPath();
        if (this.isSystemDescendant(path) && !this.equals(this.versionDataManager)) {
            return this.versionDataManager.getChildNodesData(nodeData);
        }
        return super.getChildNodesData(nodeData);
    }

    @Override
    public List<PropertyData> getChildPropertiesData(NodeData nodeData) throws RepositoryException {
        InternalQPath path = nodeData.getQPath();
        if (this.isSystemDescendant(path) && !this.equals(this.versionDataManager)) {
            return this.versionDataManager.getChildPropertiesData(nodeData);
        }
        return super.getChildPropertiesData(nodeData);
    }

    @Override
    public ItemData getItemData(InternalQPath qpath) throws RepositoryException {
        if (this.isSystemDescendant(qpath) && !this.equals(this.versionDataManager)) {
            return this.versionDataManager.getItemData(qpath);
        }
        return super.getItemData(qpath);
    }

    @Override
    public ItemData getItemData(String uuid) throws RepositoryException {
        ItemData data = super.getItemData(uuid);
        if (data != null) {
            return data;
        }
        if (!this.equals(this.versionDataManager) && (data = this.versionDataManager.getItemData(uuid)) != null && this.isSystemDescendant(data.getQPath())) {
            return data;
        }
        return null;
    }

    @Override
    public synchronized void save(ItemDataChangesLog changesLog) throws RepositoryException, InvalidItemStateException {
        List changes = changesLog.getAllStates();
        ArrayList versionChanges = new ArrayList();
        ArrayList nonVersionChanges = new ArrayList();
        if (log.isDebugEnabled()) {
            log.debug((Object)("save ver: " + changesLog.dump()));
        }
        for (int i = 0; i < changes.size(); ++i) {
            if (this.isSystemDescendant(((ItemState)changes.get(i)).getData().getQPath()) && !this.equals(this.versionDataManager)) {
                versionChanges.add(changes.get(i));
                continue;
            }
            nonVersionChanges.add(changes.get(i));
        }
        if (!versionChanges.isEmpty()) {
            this.versionDataManager.save(new ItemDataChangesLog(versionChanges, changesLog.getSessionId()));
        }
        if (!nonVersionChanges.isEmpty()) {
            super.save(new ItemDataChangesLog(nonVersionChanges, changesLog.getSessionId()));
        }
    }

    private boolean isSystemDescendant(InternalQPath path) {
        return path.equals((Object)Constants.JCR_SYSTEM_PATH) || path.isDescendantOf(Constants.JCR_SYSTEM_PATH, false);
    }
}

