/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.jcr.config.CacheEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.persistent.WorkspaceStorageCache;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceStorageCacheImpl
implements WorkspaceStorageCache {
    public static int MAX_CACHE_SIZE = 200;
    public static long MAX_CACHE_LIVETIME = 600L;
    protected static Log log = ExoLogger.getLogger((String)"jcr.WorkspaceStorageCacheImpl");
    private final ExoCache cache;
    private final WeakHashMap<String, List<NodeData>> nodesCache;
    private final WeakHashMap<String, List<PropertyData>> propertiesCache;
    private final String name;
    private boolean enabled;

    public WorkspaceStorageCacheImpl(CacheService cacheService, WorkspaceEntry wsConfig) throws Exception {
        this.name = "jcr." + wsConfig.getUniqueName();
        this.cache = cacheService.getCacheInstance(this.name);
        CacheEntry cacheConfig = wsConfig.getCache();
        if (cacheConfig != null) {
            this.enabled = cacheConfig.isEnabled();
            int maxSize = Integer.parseInt(cacheConfig.getParameterValue("maxSize"));
            this.cache.setMaxSize(maxSize);
            this.nodesCache = new WeakHashMap(maxSize);
            this.propertiesCache = new WeakHashMap(maxSize);
            long liveTime = Long.parseLong(cacheConfig.getParameterValue("liveTime"));
            this.cache.setLiveTime(liveTime);
        } else {
            this.cache.setMaxSize(MAX_CACHE_SIZE);
            this.cache.setLiveTime(MAX_CACHE_LIVETIME);
            this.nodesCache = new WeakHashMap();
            this.propertiesCache = new WeakHashMap();
            this.enabled = true;
        }
    }

    public ItemData get(String uuid) {
        if (!this.enabled) {
            return null;
        }
        try {
            return this.getItem(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemData get(InternalQPath path) {
        if (!this.enabled) {
            return null;
        }
        try {
            return this.getItem(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(ItemData data) {
        block24: {
            try {
                if (!this.enabled || data == null) break block24;
                this.putItem(data);
                if (data.isNode()) {
                    List<NodeData> cachedParentChilds = this.nodesCache.get(data.getParentUUID());
                    if (cachedParentChilds == null) break block24;
                    NodeData nodeData = (NodeData)data;
                    int orderNumber = nodeData.getOrderNumber();
                    List<NodeData> list = cachedParentChilds;
                    synchronized (list) {
                        int index = cachedParentChilds.indexOf(nodeData);
                        if (index >= 0) {
                            if (orderNumber != cachedParentChilds.get(index).getOrderNumber()) {
                                ArrayList<NodeData> newChilds = new ArrayList<NodeData>(cachedParentChilds.size());
                                for (int ci = 0; ci < cachedParentChilds.size(); ++ci) {
                                    if (index == ci) {
                                        newChilds.add(nodeData);
                                        continue;
                                    }
                                    newChilds.add(cachedParentChilds.get(ci));
                                }
                                this.nodesCache.put(data.getParentUUID(), newChilds);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)(this.name + ", put()    update child node  " + nodeData.getUUID() + "  order #" + orderNumber));
                                }
                            } else {
                                cachedParentChilds.set(index, nodeData);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)(this.name + ", put()    update child node  " + nodeData.getUUID() + "  at index #" + index));
                                }
                            }
                        } else {
                            ArrayList<NodeData> newChilds = new ArrayList<NodeData>(cachedParentChilds.size() + 1);
                            for (int ci = 0; ci < cachedParentChilds.size(); ++ci) {
                                newChilds.add(cachedParentChilds.get(ci));
                            }
                            newChilds.add(nodeData);
                            this.nodesCache.put(data.getParentUUID(), newChilds);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)(this.name + ", put()    add child node  " + nodeData.getUUID()));
                            }
                        }
                        break block24;
                    }
                }
                List<PropertyData> cachedParentChilds = this.propertiesCache.get(data.getParentUUID());
                if (cachedParentChilds == null) break block24;
                List<PropertyData> list = cachedParentChilds;
                synchronized (list) {
                    int index = cachedParentChilds.indexOf(data);
                    if (index >= 0) {
                        cachedParentChilds.set(index, (PropertyData)data);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.name + ", put()    update child property  " + data.getUUID() + "  at index #" + index));
                        }
                    } else {
                        ArrayList<PropertyData> newChilds = new ArrayList<PropertyData>(cachedParentChilds.size() + 1);
                        for (int ci = 0; ci < cachedParentChilds.size(); ++ci) {
                            newChilds.add(cachedParentChilds.get(ci));
                        }
                        newChilds.add((PropertyData)data);
                        this.propertiesCache.put(data.getParentUUID(), newChilds);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.name + ", put()    add child property  " + data.getUUID()));
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)(this.name + ", Error put item data in cache: " + (data != null ? data.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildProperties(NodeData parentData, List<PropertyData> childItems) {
        if (this.enabled && parentData != null && childItems != null) {
            String logInfo = null;
            if (log.isDebugEnabled()) {
                logInfo = "parent:   " + parentData.getQPath().getAsString() + "    " + parentData.getUUID() + " " + childItems.size();
                log.debug((Object)(this.name + ", addChildProperties() >>> " + logInfo));
            }
            String parentUUID = parentData.getUUID();
            String operName = "";
            try {
                List<PropertyData> cp;
                operName = "removing parent";
                this.removeDeep((ItemData)parentData, false);
                operName = "caching parent";
                this.putItem((ItemData)parentData);
                List<PropertyData> list = cp = childItems;
                synchronized (list) {
                    WeakHashMap<String, List<PropertyData>> weakHashMap = this.propertiesCache;
                    synchronized (weakHashMap) {
                        operName = "removing child properties";
                        this.removeChildProperties(parentUUID);
                        operName = "caching child properties list";
                        this.propertiesCache.put(parentUUID, cp);
                    }
                    operName = "caching child properties";
                    this.putItems(cp);
                }
            }
            catch (Exception e) {
                log.error((Object)(this.name + ", Error in addChildProperties() " + operName + ": parent " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.name + ", addChildProperties() <<< " + logInfo));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildNodes(NodeData parentData, List<NodeData> childItems) {
        if (this.enabled && parentData != null && childItems != null) {
            String logInfo = null;
            if (log.isDebugEnabled()) {
                logInfo = "parent:   " + parentData.getQPath().getAsString() + "    " + parentData.getUUID() + " " + childItems.size();
                log.debug((Object)(this.name + ", addChildNodes() >>> " + logInfo));
            }
            String parentUUID = parentData.getUUID();
            String operName = "";
            try {
                List<NodeData> cn;
                operName = "removing parent";
                this.removeDeep((ItemData)parentData, false);
                operName = "caching parent";
                this.putItem((ItemData)parentData);
                List<NodeData> list = cn = childItems;
                synchronized (list) {
                    WeakHashMap<String, List<NodeData>> weakHashMap = this.nodesCache;
                    synchronized (weakHashMap) {
                        operName = "removing child nodes";
                        List<NodeData> removedChildNodes = this.removeChildNodes(parentUUID, false);
                        if (removedChildNodes != null && removedChildNodes.size() > 0) {
                            operName = "search for stale child nodes not contains in the new list of childs";
                            ArrayList<NodeData> forRemove = new ArrayList<NodeData>();
                            for (NodeData removedChildNode : removedChildNodes) {
                                if (cn.contains(removedChildNode)) continue;
                                forRemove.add(removedChildNode);
                            }
                            if (forRemove.size() > 0) {
                                operName = "removing stale child nodes not contains in the new list of childs";
                                WeakHashMap<String, List<PropertyData>> weakHashMap2 = this.propertiesCache;
                                synchronized (weakHashMap2) {
                                    for (NodeData removedChildNode : forRemove) {
                                        this.removeDeep((ItemData)removedChildNode, true);
                                    }
                                }
                            }
                        }
                        operName = "caching child nodes list";
                        this.nodesCache.put(parentUUID, cn);
                    }
                    operName = "caching child nodes";
                    this.putItems(cn);
                }
            }
            catch (Exception e) {
                log.error((Object)(this.name + ", Error in addChildNodes() " + operName + ": parent " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.name + ", addChildNodes() <<< " + logInfo));
            }
        }
    }

    protected void putItem(ItemData data) throws Exception {
        String path = data.getQPath().getAsString();
        String uuid = data.getUUID();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.name + ", putItem()    " + path + "    " + uuid + "  --  " + data));
        }
        this.cache.put((Serializable)((Object)path), (Object)data);
        this.cache.put((Serializable)((Object)uuid), (Object)data);
    }

    protected ItemData getItem(String uuid) throws Exception {
        ItemData c = (ItemData)this.cache.get((Serializable)((Object)uuid));
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.name + ", getItem() " + uuid + " --> " + (c != null ? c.getQPath().getAsString() + " parent:" + c.getParentUUID() : "null")));
        }
        return c;
    }

    protected ItemData getItem(InternalQPath path) throws Exception {
        String spath = path.getAsString();
        ItemData c = (ItemData)this.cache.get((Serializable)((Object)spath));
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.name + ", getItem() " + spath + " --> " + (c != null ? c.getUUID() + " parent:" + c.getParentUUID() : "null")));
        }
        return c;
    }

    protected void putItems(List<? extends ItemData> itemsList) throws Exception {
        for (ItemData itemData : itemsList) {
            this.putItem(itemData);
        }
    }

    public List<NodeData> getChildNodes(NodeData parentData) {
        if (!this.enabled) {
            return null;
        }
        try {
            List<NodeData> cn = this.nodesCache.get(parentData.getUUID());
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.name + ", getChildNodes() " + parentData.getQPath().getAsString() + " " + parentData.getUUID()));
                StringBuffer blog = new StringBuffer();
                if (cn != null) {
                    blog.append("\n");
                    for (NodeData nd : cn) {
                        blog.append("\t\t" + nd.getQPath().getAsString() + " " + nd.getUUID() + "\n");
                    }
                    log.debug((Object)("\t-->" + blog.toString()));
                } else {
                    log.debug((Object)"\t--> null");
                }
            }
            return cn;
        }
        catch (Exception e) {
            log.error((Object)(this.name + ", Error in getChildNodes() parentData: " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            return null;
        }
    }

    public List<PropertyData> getChildProperties(NodeData parentData) {
        if (!this.enabled) {
            return null;
        }
        try {
            List<PropertyData> cp = this.propertiesCache.get(parentData.getUUID());
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.name + ", getChildProperties() " + parentData.getQPath().getAsString() + " " + parentData.getUUID()));
                StringBuffer blog = new StringBuffer();
                if (cp != null) {
                    blog.append("\n");
                    for (PropertyData pd : cp) {
                        blog.append("\t\t" + pd.getQPath().getAsString() + " " + pd.getUUID() + "\n");
                    }
                    log.debug((Object)("\t--> " + blog.toString()));
                } else {
                    log.debug((Object)"\t--> null");
                }
            }
            return cp;
        }
        catch (Exception e) {
            log.error((Object)(this.name + ", Error in getChildNodes() parentData: " + (parentData != null ? parentData.getQPath().getAsString() : "[null]")), (Throwable)e);
            return null;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setMaxSize(int maxSize) {
        this.cache.setMaxSize(maxSize);
    }

    public void setLiveTime(long liveTime) {
        this.cache.setLiveTime(liveTime);
    }

    private void unloadProperty(PropertyData property) throws Exception {
        ItemData parentData = this.get(property.getParentUUID());
        if (parentData != null) {
            this.removeDeep(parentData, false);
        }
        this.remove((ItemData)property);
    }

    private boolean needReload(ItemData data) {
        return data.getQPath().getName().equals((Object)Constants.JCR_MIXINTYPES) || data.getQPath().getName().equals((Object)Constants.EXO_PERMISSIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onSaveItems(ItemDataChangesLog changesLog) {
        if (!this.enabled) {
            return;
        }
        List itemStates = changesLog.getAllStates();
        for (ItemState state : itemStates) {
            ItemData data = state.getData();
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.name + ", onSaveItems() " + ItemState.nameFromValue((int)state.getState()) + " " + data.getQPath().getAsString() + " " + data.getUUID() + " parent:" + data.getParentUUID()));
            }
            try {
                if (state.isAdded()) {
                    if (!data.isNode() && this.needReload(data)) {
                        this.unloadProperty((PropertyData)data);
                    }
                    this.put(data);
                    continue;
                }
                if (state.isUpdated()) {
                    if (data.isNode()) {
                        ItemData parentData;
                        NodeData cached = (NodeData)this.get(data.getUUID());
                        if (cached != null && cached.getQPath().getDepth() == data.getQPath().getDepth() && cached.getQPath().getIndex() != data.getQPath().getIndex() && (parentData = this.get(data.getParentUUID())) != null) {
                            this.removeDeep(parentData, false);
                            WeakHashMap<String, List<PropertyData>> weakHashMap = this.propertiesCache;
                            synchronized (weakHashMap) {
                                this.removeChildProperties(parentData.getUUID());
                            }
                            weakHashMap = this.nodesCache;
                            synchronized (weakHashMap) {
                                if (this.removeChildNodes(parentData.getUUID(), true) == null) {
                                    WeakHashMap<String, List<PropertyData>> weakHashMap2 = this.propertiesCache;
                                    synchronized (weakHashMap2) {
                                        this.removeDeep((ItemData)cached, true);
                                    }
                                }
                            }
                        }
                    } else if (this.needReload(data)) {
                        this.unloadProperty((PropertyData)data);
                    }
                    this.put(data);
                    continue;
                }
                if (!state.isDeleted()) continue;
                if (!data.isNode() && this.needReload(data)) {
                    this.unloadProperty((PropertyData)data);
                    continue;
                }
                this.remove(data);
            }
            catch (Exception e) {
                log.error((Object)(this.name + ", Error process onSaveItems action for item data: " + (data != null ? data.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ItemData data) {
        block14: {
            if (!this.enabled) {
                return;
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.name + ", remove() " + data.getQPath().getAsString() + " " + data.getUUID()));
                }
                if (data.isNode()) {
                    WeakHashMap<String, List<PropertyData>> weakHashMap = this.propertiesCache;
                    synchronized (weakHashMap) {
                        WeakHashMap<String, List<NodeData>> weakHashMap2 = this.nodesCache;
                        synchronized (weakHashMap2) {
                            this.removeDeep(data, true);
                        }
                    }
                    this.removeSuccessors(data.getQPath().getAsString());
                    break block14;
                }
                WeakHashMap<String, List<PropertyData>> weakHashMap = this.propertiesCache;
                synchronized (weakHashMap) {
                    this.removeDeep(data, true);
                }
            }
            catch (Exception e) {
                log.error((Object)(this.name + ", Error remove item data from cache: " + (data != null ? data.getQPath().getAsString() : "[null]")), (Throwable)e);
            }
        }
    }

    protected ItemData removeDeep(ItemData item, boolean forceDeep) throws Exception {
        String myPath = item.getQPath().getAsString();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.name + ", removeDeep(" + forceDeep + ") >>> item " + myPath + " " + item.getUUID()));
        }
        if (forceDeep) {
            this.removeRelations(item);
        }
        this.cache.remove((Serializable)((Object)item.getUUID()));
        ItemData itemData = (ItemData)this.cache.remove((Serializable)((Object)myPath));
        if (itemData != null && !itemData.getUUID().equals(item.getUUID())) {
            this.removeDeep(itemData, forceDeep);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.name + ", removeDeep(" + forceDeep + ") <<< item " + myPath + " " + item.getUUID()));
        }
        return itemData;
    }

    protected void removeRelations(ItemData item) {
        try {
            if (item.isNode()) {
                if (this.removeChildNodes(item.getUUID(), true) != null && log.isDebugEnabled()) {
                    log.debug((Object)(this.name + ", removeRelations() removeChildNodes() " + item.getUUID()));
                }
                if (this.removeChildProperties(item.getUUID()) != null && log.isDebugEnabled()) {
                    log.debug((Object)(this.name + ", removeRelations() removeChildProperties() " + item.getUUID()));
                }
                if (this.removeChildNode(item.getParentUUID(), item.getUUID()) != null && log.isDebugEnabled()) {
                    log.debug((Object)(this.name + ", removeRelations() removeChildNode(parentUUID, childUUID) " + item.getParentUUID() + " " + item.getUUID()));
                }
            } else if (this.removeChildProperty(item.getParentUUID(), item.getUUID()) != null && log.isDebugEnabled()) {
                log.debug((Object)(this.name + ", removeRelations() removeChildProperty(parentUUID, childUUID) " + item.getParentUUID() + " " + item.getUUID()));
            }
        }
        catch (Exception e) {
            log.error((Object)(this.name + ", Error in removeRelations() item: " + (item != null ? item.getQPath().getAsString() : "[null]")), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<NodeData> removeChildNodes(String parentUUID, boolean forceDeep) throws Exception {
        List<NodeData> childNodes = this.nodesCache.remove(parentUUID);
        if (childNodes != null) {
            List<NodeData> list = childNodes;
            synchronized (list) {
                for (NodeData cn : childNodes) {
                    this.removeDeep((ItemData)cn, forceDeep);
                }
            }
        }
        return childNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<PropertyData> removeChildProperties(String parentUUID) throws Exception {
        List<PropertyData> childProperties = this.propertiesCache.remove(parentUUID);
        if (childProperties != null) {
            List<PropertyData> list = childProperties;
            synchronized (list) {
                for (PropertyData cp : childProperties) {
                    this.removeDeep((ItemData)cp, false);
                }
            }
        }
        return childProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyData removeChildProperty(String parentUUID, String childUUID) throws Exception {
        List<PropertyData> childProperties = this.propertiesCache.get(parentUUID);
        if (childProperties != null) {
            List<PropertyData> list = childProperties;
            synchronized (list) {
                Iterator<PropertyData> i = childProperties.iterator();
                while (i.hasNext()) {
                    PropertyData cn = i.next();
                    if (!cn.getUUID().equals(childUUID)) continue;
                    i.remove();
                    break;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeData removeChildNode(String parentUUID, String childUUID) throws Exception {
        List<NodeData> childNodes = this.nodesCache.get(parentUUID);
        if (childNodes != null) {
            List<NodeData> list = childNodes;
            synchronized (list) {
                Iterator<NodeData> i = childNodes.iterator();
                while (i.hasNext()) {
                    NodeData cn = i.next();
                    if (!cn.getUUID().equals(childUUID)) continue;
                    i.remove();
                    break;
                }
            }
        }
        return null;
    }

    protected void removeItem(String itemPath) {
        ItemRemoveSelector remover = new ItemRemoveSelector(itemPath);
        try {
            this.cache.select((CachedObjectSelector)remover);
        }
        catch (Exception e) {
            log.error((Object)(this.name + ", removeSuccessors() " + itemPath), (Throwable)e);
        }
    }

    protected void removeSuccessors(String parentPath) {
        ByPathRemoveSelector remover = new ByPathRemoveSelector(parentPath);
        try {
            this.cache.select((CachedObjectSelector)remover);
        }
        catch (Exception e) {
            log.error((Object)(this.name + ", removeSuccessors() " + parentPath), (Throwable)e);
        }
    }

    protected class ItemRemoveSelector
    implements CachedObjectSelector {
        private final String itemPath;

        protected ItemRemoveSelector(String itemPath) {
            this.itemPath = itemPath;
        }

        public void onSelect(ExoCache exoCache, Serializable key, ObjectCacheInfo value) throws Exception {
            try {
                ItemData removed = (ItemData)exoCache.remove(key);
                if (removed != null) {
                    exoCache.remove((Serializable)((Object)removed.getUUID()));
                }
            }
            catch (Exception e) {
                log.error((Object)(WorkspaceStorageCacheImpl.this.name + ", ItemRemoveSelector.onSelect() " + this.itemPath + " key: " + key), (Throwable)e);
            }
        }

        public boolean select(Serializable key, ObjectCacheInfo value) {
            return ((String)((Object)key)).equals(this.itemPath);
        }
    }

    protected class ByPathRemoveSelector
    implements CachedObjectSelector {
        private final String parentPath;

        protected ByPathRemoveSelector(String parentPath) {
            this.parentPath = parentPath;
        }

        public void onSelect(ExoCache exoCache, Serializable key, ObjectCacheInfo value) throws Exception {
            try {
                ItemData removed = (ItemData)exoCache.remove(key);
                if (removed != null) {
                    exoCache.remove((Serializable)((Object)removed.getUUID()));
                }
            }
            catch (Exception e) {
                log.error((Object)(WorkspaceStorageCacheImpl.this.name + ", ByPathRemoveSelector.onSelect() " + this.parentPath + " key: " + key), (Throwable)e);
            }
        }

        public boolean select(Serializable key, ObjectCacheInfo value) {
            return ((String)((Object)key)).startsWith(this.parentPath);
        }
    }
}

