/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.replication;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.replication.FixupStream;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.util.UUIDGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingChangesLog {
    private ItemDataChangesLog itemDataChangesLog;
    private List<InputStream> listInputStream;
    private List<RandomAccessFile> listRandomAccessFile;
    private int containerType;
    private List<FixupStream> listFixupStream;
    private List<File> listFile;
    private String uuid;
    private FileCleaner fileCleaner;
    private byte[] data;

    public PendingChangesLog(ItemDataChangesLog itemDataChangesLog_, FileCleaner fileCleaner) throws IOException {
        this.itemDataChangesLog = itemDataChangesLog_;
        this.listInputStream = new ArrayList<InputStream>();
        this.listFixupStream = new ArrayList<FixupStream>();
        this.containerType = this.analysisItemDataChangesLog();
        this.listFile = new ArrayList<File>();
        this.uuid = UUIDGenerator.generate();
        this.fileCleaner = fileCleaner;
    }

    public PendingChangesLog(ItemDataChangesLog itemDataChangesLog_, String uuid_, int type, FileCleaner fileCleaner) throws IOException {
        this.itemDataChangesLog = itemDataChangesLog_;
        this.listInputStream = new ArrayList<InputStream>();
        this.listFixupStream = new ArrayList<FixupStream>();
        this.listRandomAccessFile = new ArrayList<RandomAccessFile>();
        this.listFile = new ArrayList<File>();
        this.uuid = uuid_;
        this.containerType = type;
        this.fileCleaner = fileCleaner;
    }

    public PendingChangesLog(String uuid, int dataLength) {
        this.uuid = uuid;
        this.data = new byte[dataLength];
    }

    public void putData(int offset, byte[] tempData) {
        for (int i = 0; i < tempData.length; ++i) {
            this.data[i + offset] = tempData[i];
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public ItemDataChangesLog getItemDataChangesLog() {
        return this.itemDataChangesLog;
    }

    public List<InputStream> getInputStreams() {
        return this.listInputStream;
    }

    public List<RandomAccessFile> getListRandomAccessFiles() {
        return this.listRandomAccessFile;
    }

    public List<File> getListFile() {
        return this.listFile;
    }

    public List<FixupStream> getFixupStreams() {
        return this.listFixupStream;
    }

    private int analysisItemDataChangesLog_TO_DO() throws IOException {
        int itemDataChangesLogType = 1;
        List listItemState = this.itemDataChangesLog.getAllStates();
        for (int i = 0; i < listItemState.size(); ++i) {
            TransientItemData propertyData;
            ItemState itemState = (ItemState)listItemState.get(i);
            ItemData itemData = itemState.getData();
            if (itemData instanceof TransientPropertyData && ((TransientPropertyData)(propertyData = (TransientPropertyData)itemData)).getValues() != null) {
                for (int j = 0; j < ((TransientPropertyData)propertyData).getValues().size(); ++j) {
                    if (((TransientPropertyData)propertyData).getValues().get(j).getAsByteArray().length < 204800) continue;
                    this.listFixupStream.add(new FixupStream(i, j));
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(((TransientPropertyData)propertyData).getValues().get(j).getAsByteArray());
                    this.listInputStream.add(inputStream);
                    itemDataChangesLogType = 2;
                }
            }
            if (!(itemData instanceof TransientNodeData)) continue;
            propertyData = (TransientNodeData)itemData;
        }
        return itemDataChangesLogType;
    }

    private int analysisItemDataChangesLog() throws IOException {
        int itemDataChangesLogType = 1;
        List listItemState = this.itemDataChangesLog.getAllStates();
        for (int i = 0; i < listItemState.size(); ++i) {
            TransientItemData propertyData;
            ItemState itemState = (ItemState)listItemState.get(i);
            ItemData itemData = itemState.getData();
            if (itemData instanceof TransientPropertyData && ((TransientPropertyData)(propertyData = (TransientPropertyData)itemData)).getValues() != null) {
                for (int j = 0; j < ((TransientPropertyData)propertyData).getValues().size(); ++j) {
                    if (((TransientPropertyData)propertyData).getValues().get(j).isByteArray()) continue;
                    this.listFixupStream.add(new FixupStream(i, j));
                    InputStream inputStream = itemState.isDeleted() ? new ByteArrayInputStream("".getBytes()) : ((TransientPropertyData)propertyData).getValues().get(j).getAsStream();
                    this.listInputStream.add(inputStream);
                    itemDataChangesLogType = 2;
                }
            }
            if (!(itemData instanceof TransientNodeData)) continue;
            propertyData = (TransientNodeData)itemData;
        }
        return itemDataChangesLogType;
    }

    public int getConteinerType() {
        return this.containerType;
    }

    public String getUUID() {
        return this.uuid;
    }

    public static byte[] getAsByteArray(ItemDataChangesLog dataChangesLog) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(dataChangesLog);
        byte[] bArray = os.toByteArray();
        return bArray;
    }

    public static ItemDataChangesLog getAsItemDataChangesLog(byte[] byteArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream is = new ByteArrayInputStream(byteArray);
        ObjectInputStream ois = new ObjectInputStream(is);
        ItemDataChangesLog objRead = (ItemDataChangesLog)ois.readObject();
        return objRead;
    }

    public RandomAccessFile getRandomAccessFile(FixupStream fs) {
        for (int i = 0; i < this.listFixupStream.size(); ++i) {
            if (!this.listFixupStream.get(i).compare(fs)) continue;
            return this.listRandomAccessFile.get(i);
        }
        return null;
    }

    public void restore() throws Exception {
        int i;
        for (i = 0; i < this.listFixupStream.size(); ++i) {
            List listItemState = this.itemDataChangesLog.getAllStates();
            ItemState itemState = (ItemState)listItemState.get(this.listFixupStream.get(i).getItemSateId());
            ItemData itemData = itemState.getData();
            TransientPropertyData propertyData = (TransientPropertyData)itemData;
            TransientValueData transientValueData = (TransientValueData)propertyData.getValues().get(this.listFixupStream.get(i).getValueDataId());
            transientValueData.setStream(new FileInputStream(this.listFile.get(i)));
            transientValueData.setFileCleaner(this.fileCleaner);
            transientValueData.isByteArray();
        }
        for (i = 0; i < this.listFile.size(); ++i) {
            this.fileCleaner.addFile(this.listFile.get(i));
        }
    }

    public class Type {
        public static final int ItemDataChangesLog_without_Streams = 1;
        public static final int ItemDataChangesLog_with_Streams = 2;
    }
}

