/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.dataflow.MutableItemDataChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SessionChangesLog
extends MutableItemDataChangesLog {
    public SessionChangesLog(String sessionId) {
        super(sessionId);
    }

    public void remove(InternalQPath rootPath) {
        ArrayList<ItemState> removedList = new ArrayList<ItemState>();
        for (ItemState item : this.items) {
            InternalQPath qPath = item.getData().getQPath();
            if (!qPath.equals((Object)rootPath) && !qPath.isDescendantOf(rootPath, false) && !item.getAncestorToSave().equals((Object)rootPath) && !item.getAncestorToSave().isDescendantOf(rootPath, false)) continue;
            removedList.add(item);
        }
        for (ItemState item : removedList) {
            this.items.remove(item);
        }
    }

    public List<ItemState> getDescendantsChanges(String rootUuid) {
        ArrayList<ItemState> changesList = new ArrayList<ItemState>();
        this.traverseChangesByUUID(rootUuid, changesList);
        return changesList;
    }

    private void traverseChangesByUUID(String uuid, List<ItemState> changesList) {
        for (ItemState item : this.items) {
            if (item.getData().getUUID().equals(uuid)) {
                changesList.add(item);
                continue;
            }
            if (!item.getData().getParentUUID().equals(uuid)) continue;
            this.traverseChangesByUUID(item.getData().getUUID(), changesList);
        }
    }

    public void eraseEventFire(String uuid) {
        for (ItemState item : this.items) {
            if (item.getData().getUUID().equals(uuid)) {
                item.eraseEventFire();
                continue;
            }
            if (!item.getData().getParentUUID().equals(uuid)) continue;
            this.eraseEventFire(item.getData().getUUID());
        }
    }

    public List<ItemState> getDescendantsChanges(InternalQPath rootPath) {
        ArrayList<ItemState> list = new ArrayList<ItemState>();
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemState)this.items.get(i)).isDescendant(rootPath)) continue;
            list.add((ItemState)this.items.get(i));
        }
        return list;
    }

    public List<ItemState> getChildrenChanges(String rootUuid) {
        ArrayList<ItemState> list = new ArrayList<ItemState>();
        for (int i = 0; i < this.items.size(); ++i) {
            TransientItemData item = (TransientItemData)((ItemState)this.items.get(i)).getData();
            if (!item.getParentUUID().equals(rootUuid) && !item.getUUID().equals(rootUuid)) continue;
            list.add((ItemState)this.items.get(i));
        }
        return list;
    }

    public ItemDataChangesLog pushLog(InternalQPath rootPath) {
        SessionChangesLog cLog = new SessionChangesLog(this.sessionId);
        cLog.addAll(this.getDescendantsChanges(rootPath));
        this.remove(rootPath);
        return cLog;
    }

    public Collection<ItemState> getLastChildrenStates(ItemData rootData, boolean forNodes) {
        HashMap<String, ItemState> children = new HashMap<String, ItemState>();
        List<ItemState> changes = this.getChildrenChanges(rootData.getUUID());
        for (ItemState child : changes) {
            ItemData data = child.getData();
            if (data.isNode() != forNodes || data.equals(rootData)) continue;
            children.put(data.getUUID(), child);
        }
        return children.values();
    }

    public Collection<ItemState> getLastModifyStates(NodeData rootData) {
        HashMap changes = new HashMap();
        for (int i = 0; i < this.items.size(); ++i) {
            TransientItemData item = (TransientItemData)((ItemState)this.items.get(i)).getData();
            if (item.getUUID().equals(rootData.getUUID())) {
                if (((ItemState)this.items.get(i)).isAdded()) {
                    return new ArrayList<ItemState>();
                }
                if (((ItemState)this.items.get(i)).isDeleted()) continue;
                changes.put(item.getUUID(), this.items.get(i));
                continue;
            }
            if (!item.getParentUUID().equals(rootData.getUUID())) continue;
            changes.put(item.getUUID(), this.items.get(i));
        }
        return changes.values();
    }
}

