/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.text.SimpleDateFormat;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemDataChangesLog;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.persistent.LocalWorkspaceDataManagerStub;
import org.exoplatform.services.jcr.impl.dataflow.session.LocalWorkspaceStorageDataManagerProxy;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.jcr.impl.dataflow.session.WorkspaceStorageDataManagerProxy;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.transaction.TransactionException;
import org.exoplatform.services.transaction.TransactionResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionableDataManager
implements DataManager,
TransactionResource {
    private WorkspaceStorageDataManagerProxy storageDataManager;
    private SessionImpl session;
    protected static Log log = ExoLogger.getLogger((String)"jcr.TransactionableDataManager");
    private SessionChangesLog transactionLog;
    protected String infoString = null;
    private SimpleDateFormat infoDateFormater = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSSS");

    public TransactionableDataManager(LocalWorkspaceDataManagerStub dataManager, SessionImpl session) {
        this.session = session;
        try {
            this.storageDataManager = new LocalWorkspaceStorageDataManagerProxy(dataManager, session.getValueFactory());
        }
        catch (Exception e1) {
            log.error((Object)("TransactionableDataManager error of read value factory: " + e1.getMessage()));
            this.infoString = "[Error of read value factory: " + e1.getMessage() + "]";
        }
        try {
            this.infoString = session.getSessionInfo() + ", " + this.infoDateFormater.format(this.storageDataManager.getCurrentTime().getTime()) + ", " + session;
        }
        catch (Exception e) {
            log.warn((Object)("TransactionableDataManager error of read session info: " + e.getMessage()));
            this.infoString = "[Error of read session info: " + e.getMessage() + "]";
        }
    }

    public String toString() {
        return super.toString() + " [" + this.infoString + "]";
    }

    public AccessControlList getACL(InternalQPath path) throws RepositoryException {
        ItemData data = this.getItemData(path);
        if (data == null || !data.isNode()) {
            return this.storageDataManager.getACL(path);
        }
        return ((NodeData)data).getACL();
    }

    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException {
        List nodes = this.storageDataManager.getChildNodesData(parent);
        if (this.txStarted()) {
            for (ItemState state : this.transactionLog.getLastChildrenStates((ItemData)parent, true)) {
                nodes.remove(state.getData());
                if (state.getState() == 3) continue;
                nodes.add((NodeData)state.getData());
            }
        }
        return nodes;
    }

    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException {
        List props = this.storageDataManager.getChildPropertiesData(parent);
        if (this.txStarted()) {
            for (ItemState state : this.transactionLog.getLastChildrenStates((ItemData)parent, false)) {
                props.remove(state.getData());
                if (state.getState() == 3) continue;
                props.add((PropertyData)state.getData());
            }
        }
        return props;
    }

    public ItemData getItemData(InternalQPath path) throws RepositoryException {
        ItemState state;
        ItemData data = null;
        if (this.txStarted() && (state = this.transactionLog.getItemState(path)) != null) {
            data = state.getData();
        }
        if (data != null) {
            return data;
        }
        return this.storageDataManager.getItemData(path);
    }

    public ItemData getItemData(String uuid) throws RepositoryException {
        ItemState state;
        ItemData data = null;
        if (this.txStarted() && (state = this.transactionLog.getItemState(uuid)) != null) {
            data = state.getData();
        }
        if (data != null) {
            return data;
        }
        return this.storageDataManager.getItemData(uuid);
    }

    public List<PropertyData> getReferencesData(String uuid) throws RepositoryException {
        return this.storageDataManager.getReferencesData(uuid);
    }

    public void start() {
        log.debug((Object)("tx start() " + this + " txStarted(): " + this.txStarted()));
        if (!this.txStarted()) {
            this.transactionLog = new SessionChangesLog(this.session.getId());
        }
    }

    public void commit() throws TransactionException {
        if (this.txStarted()) {
            log.debug((Object)("tx commit() " + this + "\n" + this.transactionLog.dump()));
            try {
                this.storageDataManager.save(this.transactionLog);
                this.transactionLog = null;
            }
            catch (InvalidItemStateException e) {
                throw new TransactionException((Throwable)e);
            }
            catch (RepositoryException e) {
                throw new TransactionException((Throwable)e);
            }
        }
    }

    public void rollback() {
        log.debug((Object)("tx rollback() " + this + (this.transactionLog != null ? "\n" + this.transactionLog.dump() : "[NULL]")));
        if (this.txStarted()) {
            this.transactionLog = null;
        }
    }

    public void save(ItemDataChangesLog changes) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("save() " + this + " txStarted: " + this.txStarted() + "\n====== Changes ======\n" + (changes != null ? "\n" + changes.dump() : "[NULL]") + "====================="));
        }
        if (this.txStarted()) {
            this.transactionLog.addAll(changes.getAllStates());
        } else {
            this.storageDataManager.save(changes);
        }
    }

    public boolean txStarted() {
        return this.transactionLog != null;
    }

    public boolean txHasPendingChages() {
        return this.txStarted() && this.transactionLog.getSize() > 0;
    }

    public WorkspaceStorageDataManagerProxy getStorageDataManager() {
        return this.storageDataManager;
    }
}

