/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.version;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.util.DateFormatHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionHistoryDataHelper
extends TransientNodeData {
    protected final ItemDataConsumer dataManager;
    protected final NodeTypeManagerImpl ntManager;

    public VersionHistoryDataHelper(NodeData source, ItemDataConsumer dataManager, NodeTypeManagerImpl ntManager) {
        super(source.getQPath(), source.getUUID(), source.getPersistedVersion(), source.getPrimaryTypeName(), source.getMixinTypeNames(), source.getOrderNumber(), source.getParentUUID(), source.getACL());
        this.dataManager = dataManager;
        this.ntManager = ntManager;
    }

    public List<NodeData> getAllVersionsData() throws RepositoryException {
        NodeData vData = (NodeData)this.dataManager.getItemData(this.getQPath());
        NodeData rootVersion = (NodeData)this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)this.getQPath(), (InternalQName)Constants.JCR_ROOTVERSION));
        ArrayList<NodeData> vChilds = new ArrayList<NodeData>();
        vChilds.add(rootVersion);
        for (NodeData cnd : this.dataManager.getChildNodesData(vData)) {
            if (cnd.getQPath().getName().equals((Object)Constants.JCR_ROOTVERSION) || !this.ntManager.isNodeType(Constants.NT_VERSION, cnd.getPrimaryTypeName())) continue;
            vChilds.add(cnd);
        }
        return vChilds;
    }

    public NodeData getLastVersionData() throws RepositoryException {
        List<NodeData> versionsData = this.getAllVersionsData();
        NodeData lastVersionData = null;
        Calendar lastCreated = null;
        for (NodeData vd : versionsData) {
            PropertyData createdData = (PropertyData)this.dataManager.getItemData(InternalQPath.makeChildPath((InternalQPath)vd.getQPath(), (InternalQName)Constants.JCR_CREATED));
            if (createdData == null) {
                throw new VersionException("jcr:created is not found, version: " + vd.getQPath().getAsString());
            }
            Calendar created = null;
            try {
                created = new DateFormatHelper().deserialize(new String(((ValueData)createdData.getValues().get(0)).getAsByteArray()));
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            if (lastVersionData != null && !created.after(lastCreated)) continue;
            lastCreated = created;
            lastVersionData = vd;
        }
        return lastVersionData;
    }

    public NodeData getVersionData(InternalQName versionQName) throws VersionException, RepositoryException {
        InternalQPath versionPath = InternalQPath.makeChildPath((InternalQPath)this.getQPath(), (InternalQName)versionQName);
        return (NodeData)this.dataManager.getItemData(versionPath);
    }

    public NodeData getVersionLabelsData() throws VersionException, RepositoryException {
        InternalQPath labelsPath = InternalQPath.makeChildPath((InternalQPath)this.getQPath(), (InternalQName)Constants.JCR_VERSIONLABELS);
        return (NodeData)this.dataManager.getItemData(labelsPath);
    }

    public List<PropertyData> getVersionLabels() throws VersionException, RepositoryException {
        List labelsList = this.dataManager.getChildPropertiesData(this.getVersionLabelsData());
        return labelsList;
    }

    public NodeData getVersionDataByLabel(InternalQName labelQName) throws VersionException, RepositoryException {
        List<PropertyData> labelsList = this.getVersionLabels();
        for (PropertyData prop : labelsList) {
            if (!prop.getQPath().getName().equals((Object)labelQName)) continue;
            try {
                String versionUuid = new String(((ValueData)prop.getValues().get(0)).getAsByteArray());
                return (NodeData)this.dataManager.getItemData(versionUuid);
            }
            catch (IllegalStateException e) {
                throw new RepositoryException("Version label data error: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new RepositoryException("Version label data reading error: " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

