/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.ext.action;

import javax.jcr.nodetype.NodeType;
import org.exoplatform.services.command.action.ActionMatcher;
import org.exoplatform.services.command.action.Condition;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.InternalQPath;

public class SessionEventMatcher
implements ActionMatcher {
    public static final String EVENTTYPE_KEY = "types";
    public static final String WORKSPACE_KEY = "workspaces";
    public static final String PATH_KEY = "paths";
    public static final String NODETYPE_KEY = "nodeTypes";
    public static final String PARENT_NODETYPES_KEY = "parentNodeTypes";
    private int eventTypes;
    private String[] workspaces;
    private InternalQPath[] paths;
    private boolean isDeep;
    private InternalQName[] parentNodeTypeNames;
    private InternalQName[] nodeTypeNames;

    public SessionEventMatcher(int eventTypes, InternalQPath[] paths, boolean isDeep, InternalQName[] nodeTypeNames, InternalQName[] parentNodeTypeNames, String[] workspaces) {
        this.eventTypes = eventTypes;
        this.paths = paths;
        this.isDeep = isDeep;
        this.nodeTypeNames = nodeTypeNames;
        this.parentNodeTypeNames = parentNodeTypeNames;
        this.workspaces = workspaces;
    }

    public final boolean match(Condition conditions) {
        if (conditions.get((Object)EVENTTYPE_KEY) == null || !this.isEventTypeMatch((Integer)conditions.get((Object)EVENTTYPE_KEY))) {
            return false;
        }
        if (!this.isPathMatch((InternalQPath)conditions.get((Object)PATH_KEY))) {
            return false;
        }
        if (!this.isParentNodeTypesMatch((NodeType[])conditions.get((Object)PARENT_NODETYPES_KEY))) {
            return false;
        }
        if (!this.isNodeTypeMatch((InternalQName)conditions.get((Object)NODETYPE_KEY))) {
            return false;
        }
        if (!this.isWorkspaceMatch((String)conditions.get((Object)WORKSPACE_KEY))) {
            return false;
        }
        return this.internalMatch(conditions);
    }

    public String dump() {
        String str = "SessionEventMatcher: " + this.eventTypes + "\n";
        if (this.paths != null) {
            str = str + "Paths (isDeep=" + this.isDeep + "):\n";
            for (InternalQName internalQName : this.paths) {
                str = str + internalQName.getAsString() + "\n";
            }
        }
        if (this.nodeTypeNames != null) {
            str = str + "Node Types:\n";
            for (InternalQName internalQName : this.nodeTypeNames) {
                str = str + internalQName.getAsString() + "\n";
            }
        }
        if (this.parentNodeTypeNames != null) {
            str = str + "Parent Node Types:\n";
            for (InternalQName internalQName : this.parentNodeTypeNames) {
                str = str + internalQName.getAsString() + "\n";
            }
        }
        return str;
    }

    protected boolean internalMatch(Condition conditions) {
        return true;
    }

    private boolean isEventTypeMatch(int type) {
        return (this.eventTypes & type) > 0;
    }

    private boolean isPathMatch(InternalQPath itemPath) {
        if (this.paths == null || itemPath == null) {
            return true;
        }
        for (InternalQPath p : this.paths) {
            if (!itemPath.equals((Object)p) && !itemPath.isDescendantOf(p, !this.isDeep)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentNodeTypesMatch(NodeType[] nodeType) {
        if (this.parentNodeTypeNames == null || nodeType == null) {
            return true;
        }
        for (InternalQName nt : this.parentNodeTypeNames) {
            for (NodeType searchNt : nodeType) {
                if (!((ExtendedNodeType)searchNt).getQName().equals((Object)nt)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNodeTypeMatch(InternalQName nodeType) {
        if (this.nodeTypeNames == null || nodeType == null) {
            return true;
        }
        for (InternalQName nt : this.nodeTypeNames) {
            if (!nt.equals((Object)nodeType)) continue;
            return true;
        }
        return false;
    }

    private boolean isWorkspaceMatch(String workspace) {
        if (this.workspaces == null || workspace == null) {
            return true;
        }
        for (String ws : this.workspaces) {
            if (!ws.equals(workspace)) continue;
            return true;
        }
        return false;
    }
}

