/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.exoplatform.services.database.jdbc.DBSchemaCreator;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.storage.WorkspaceDataContainerBase;
import org.exoplatform.services.jcr.impl.storage.jdbc.MultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.SingleDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.update.StorageUpdateManager;
import org.exoplatform.services.jcr.impl.storage.value.StandaloneStoragePluginProvider;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;

public class JDBCWorkspaceDataContainer
extends WorkspaceDataContainerBase
implements Startable {
    public static final String CONTAINER_NAME = "containerName";
    public static final String SOURCE_NAME = "sourceName";
    public static final String MULTIDB = "multi-db";
    public static final String MAXBUFFERSIZE = "max-buffer-size";
    public static final String SWAPDIR = "swap-directory";
    public static final int DEF_MAXBUFFERSIZE = 204800;
    public static final String DEF_SWAPDIR = System.getProperty("java.io.tmpdir");
    protected static Log log = ExoLogger.getLogger((String)"jcr.JDBCWorkspaceDataContainer");
    protected String containerName;
    protected String sourceName;
    protected boolean multiDb;
    private DataSource dataSource;
    private String storageVersion;
    private final ValueStoragePluginProvider valueStorageProvider;
    protected int maxBufferSize;
    protected File swapDirectory;
    private FileCleaner swapCleaner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCWorkspaceDataContainer(WorkspaceEntry wsConfig, DBSchemaCreator dbCreator, ValueStoragePluginProvider valueStorageProvider) throws RepositoryConfigurationException, NamingException, RepositoryException, IOException {
        this.containerName = wsConfig.getName();
        this.sourceName = wsConfig.getContainer().getParameterValue(SOURCE_NAME);
        this.multiDb = Boolean.parseBoolean(wsConfig.getContainer().getParameterValue(MULTIDB));
        this.valueStorageProvider = valueStorageProvider;
        try {
            String bsParam = wsConfig.getContainer().getParameterValue(MAXBUFFERSIZE);
            this.maxBufferSize = Integer.parseInt(bsParam);
        }
        catch (RepositoryConfigurationException e) {
            this.maxBufferSize = 204800;
        }
        try {
            String sdParam = wsConfig.getContainer().getParameterValue(SWAPDIR);
            this.swapDirectory = new File(sdParam);
        }
        catch (RepositoryConfigurationException e1) {
            this.swapDirectory = new File(DEF_SWAPDIR);
        }
        if (!this.swapDirectory.exists()) {
            this.swapDirectory.mkdirs();
        }
        InitialContext context = new InitialContext();
        this.dataSource = (DataSource)context.lookup(this.sourceName);
        String suParam = null;
        boolean enableStorageUpdate = false;
        try {
            suParam = wsConfig.getContainer().getParameterValue("update-storage");
            enableStorageUpdate = Boolean.parseBoolean(suParam);
        }
        catch (RepositoryConfigurationException e) {
            log.debug((Object)("update-storage parameter is not set " + this.sourceName));
        }
        this.checkVersion(enableStorageUpdate);
        if (valueStorageProvider instanceof StandaloneStoragePluginProvider) {
            WorkspaceStorageConnection conn = null;
            try {
                conn = this.openConnection();
                ((StandaloneStoragePluginProvider)valueStorageProvider).checkConsistency(conn);
            }
            finally {
                if (conn != null) {
                    conn.rollback();
                }
            }
        }
        log.info((Object)this.getInfo());
    }

    public String checkVersion(boolean enableStorageUpdate) throws RepositoryException {
        this.storageVersion = StorageUpdateManager.checkVersion(this.sourceName, this.dataSource, this.multiDb, enableStorageUpdate);
        return this.storageVersion;
    }

    public WorkspaceStorageConnection openConnection() throws RepositoryException {
        try {
            if (this.multiDb) {
                return new MultiDbJDBCConnection(this.dataSource, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            }
            return new SingleDbJDBCConnection(this.dataSource, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String getName() {
        return this.containerName;
    }

    public String getInfo() {
        String str = "JDBC based JCR Workspace Data container \ncontainer name: " + this.containerName + " \n" + "data source JNDI name: " + this.sourceName + "\n" + "is multi database: " + this.multiDb + "\n" + "storage version: " + this.storageVersion + "\n" + "value storage provider: " + this.valueStorageProvider + "\n" + "max buffer size (bytes): " + this.maxBufferSize + "\n" + "swap directory path: " + this.swapDirectory.getAbsolutePath() + "\n" + "instance: " + this;
        return str;
    }

    public String getStorageVersion() {
        return this.storageVersion;
    }

    public void start() {
        this.swapCleaner = new FileCleaner();
    }

    public void stop() {
        this.swapCleaner.halt();
        this.swapCleaner.interrupt();
    }
}

