/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc;

import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.jcr.util.io.BLOBUtil;

public class MultiDbJDBCConnection
extends JDBCStorageConnection {
    MultiDbJDBCConnection(DataSource dataSource, String containerName, boolean multiDb, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dataSource, containerName, true, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    protected String getUuid(String internalId) {
        return internalId;
    }

    protected String getInternalId(String uuid) {
        return uuid;
    }

    protected final void prepareQueries() throws SQLException {
        this.JCR_FK_NODE_PARENT = "JCR_FK_MNODE_PARENT";
        this.JCR_FK_NODE_ITEM = "JCR_FK_MNODE_ITEM";
        this.JCR_FK_PROPERTY_NODE = "JCR_FK_MPROPERTY_N";
        this.JCR_FK_PROPERTY_ITEM = "JCR_FK_MPROPERTY_I";
        this.JCR_FK_VALUE_PROPERTY = "JCR_FK_MVALUE_PROP";
        this.JCR_PK_ITEM = "JCR_MITEM_PKEY";
        this.FIND_ITEM_BY_ID = "select I.*, N.ID as NID, N.ORDER_NUM as NORDER_NUM, N.PARENT_ID as NPARENT_ID, P.ID as PID, P.TYPE as PTYPE, P.PARENT_ID as PPARENT_ID, P.MULTIVALUED as PMULTIVALUED from JCR_MITEM I LEFT JOIN JCR_MNODE N ON I.ID=N.ID LEFT JOIN JCR_MPROPERTY P ON I.ID=P.ID where I.ID=?";
        this.FIND_ITEM_BY_PATH = "select I.*, N.ID as NID, N.ORDER_NUM as NORDER_NUM, N.PARENT_ID as NPARENT_ID, P.ID as PID, P.TYPE as PTYPE, P.PARENT_ID as PPARENT_ID, P.MULTIVALUED as PMULTIVALUED from JCR_MITEM I LEFT JOIN JCR_MNODE N on I.ID=N.ID LEFT JOIN JCR_MPROPERTY P on I.ID=P.ID where I.PATH=? order by I.VERSION DESC";
        this.FIND_CHILD_PROPERTY_BY_PATH = "select I.*, P.ID as PID, P.TYPE as PTYPE, P.PARENT_ID as PPARENT_ID, P.MULTIVALUED as PMULTIVALUED from JCR_MPROPERTY P, JCR_MITEM I where I.PATH=? and I.ID=P.ID and P.PARENT_ID=? order by I.VERSION DESC";
        this.FIND_DESCENDANT_NODES_LIKE_PATH = "select I.*, N.ID as NID from JCR_MNODE N, JCR_MITEM I where I.ID=N.ID and N.PARENT_ID=? and I.PATH like ? order by I.PATH";
        this.FIND_DESCENDANT_PROPERTIES_LIKE_PATH = "select I.*, P.ID as PID from JCR_MPROPERTY P, JCR_MITEM I where I.ID=P.ID and P.PARENT_ID=? and I.PATH like ? order by I.PATH";
        this.FIND_REFERENCES = "select R.NODE_ID as NID, R.PROPERTY_ID as PID, I.PATH, I.VERSION, P.TYPE as PTYPE, P.PARENT_ID as PPARENT_ID, P.MULTIVALUED as PMULTIVALUED from JCR_MREF R, JCR_MITEM I, JCR_MPROPERTY P where R.PROPERTY_ID=I.ID and R.PROPERTY_ID=P.ID and I.ID=P.ID and R.NODE_ID=?";
        this.FIND_VALUES_BY_PROPERTYID = "select * from JCR_MVALUE where PROPERTY_ID=? order by ORDER_NUM";
        this.FIND_VALUE_BY_PROPERTYID_OREDERNUMB = "select DATA from JCR_MVALUE where PROPERTY_ID=? and ORDER_NUM=?";
        this.FIND_NODES_BY_PARENTID = "select I.*, N.ID as NID, N.ORDER_NUM as NORDER_NUM, N.PARENT_ID as NPARENT_ID from JCR_MNODE N, JCR_MITEM I where I.ID=N.ID and N.PARENT_ID=? order by NORDER_NUM";
        this.FIND_PROPERTIES_BY_PARENTID = "select I.*, P.ID as PID, P.TYPE as PTYPE, P.PARENT_ID as PPARENT_ID, P.MULTIVALUED as PMULTIVALUED from JCR_MPROPERTY P, JCR_MITEM I where I.ID=P.ID and P.PARENT_ID=? order by I.ID";
        this.FIND_NODES_IDS_BY_PARENTID = "select I.ID from JCR_MNODE N, JCR_MITEM I where I.ID=N.ID and N.PARENT_ID=? group by I.ID order by I.ID";
        this.FIND_REFERENCEABLE = "select R.NODE_ID as NID, R.PROPERTY_ID as PID, I.PATH, I.VERSION, P.TYPE as PTYPE, P.PARENT_ID as PPARENT_ID, P.MULTIVALUED as PMULTIVALUED from JCR_MREF R, JCR_MITEM I, JCR_MPROPERTY P where R.PROPERTY_ID=I.ID and R.PROPERTY_ID=P.ID and I.ID=P.ID and R.PROPERTY_ID=?";
        this.FIND_NODESCOUNT_BY_PARENTID = "select count(*) from JCR_MNODE where PARENT_ID=?";
        this.FIND_PROPERTIESCOUNT_BY_PARENTID = "select count(*) from JCR_MPROPERTY where PARENT_ID=?";
        this.INSERT_ITEM = "insert into JCR_MITEM(ID, PATH, VERSION) VALUES(?,?,?)";
        this.INSERT_NODE = "insert into JCR_MNODE(ID, ORDER_NUM, PARENT_ID) VALUES(?,?,?)";
        this.INSERT_PROPERTY = "insert into JCR_MPROPERTY(ID, TYPE, MULTIVALUED, PARENT_ID) VALUES(?,?,?,?)";
        this.INSERT_VALUE = "insert into JCR_MVALUE(DATA, ORDER_NUM, PROPERTY_ID) VALUES(?,?,?)";
        this.INSERT_REF = "insert into JCR_MREF(NODE_ID, PROPERTY_ID, ORDER_NUM) VALUES(?,?,?)";
        this.UPDATE_ITEM = "update JCR_MITEM set VERSION=? where ID=?";
        this.UPDATE_ITEM_PATH = "update JCR_MITEM set PATH=?, VERSION=? where ID=?";
        this.UPDATE_NODE = "update JCR_MNODE set ORDER_NUM=? where ID=?";
        this.UPDATE_PROPERTY = "update JCR_MPROPERTY set TYPE=? where ID=?";
        this.DELETE_ITEM = "delete from JCR_MITEM where ID=?";
        this.DELETE_NODE = "delete from JCR_MNODE where ID=?";
        this.DELETE_PROPERTY = "delete from JCR_MPROPERTY where ID=?";
        this.DELETE_VALUE = "delete from JCR_MVALUE where PROPERTY_ID=?";
        this.DELETE_REF = "delete from JCR_MREF where PROPERTY_ID=?";
    }

    protected void addNodeRecord(NodeData data) throws SQLException {
        if (this.insertItem == null) {
            this.insertItem = this.dbConnection.prepareStatement(this.INSERT_ITEM);
        }
        if (this.insertNode == null) {
            this.insertNode = this.dbConnection.prepareStatement(this.INSERT_NODE);
        }
        this.insertItem.setString(1, data.getUUID());
        this.insertItem.setString(2, data.getQPath().getAsString());
        this.insertItem.setInt(3, data.getPersistedVersion());
        this.insertItem.executeUpdate();
        this.insertNode.setString(1, data.getUUID());
        this.insertNode.setInt(2, data.getOrderNumber());
        this.insertNode.setString(3, data.getParentUUID());
        this.insertNode.executeUpdate();
    }

    protected void addPropertyRecord(PropertyData data) throws SQLException {
        if (this.insertItem == null) {
            this.insertItem = this.dbConnection.prepareStatement(this.INSERT_ITEM);
        }
        if (this.insertProperty == null) {
            this.insertProperty = this.dbConnection.prepareStatement(this.INSERT_PROPERTY);
        }
        this.insertItem.setString(1, data.getUUID());
        this.insertItem.setString(2, data.getQPath().getAsString());
        this.insertItem.setInt(3, data.getPersistedVersion());
        this.insertItem.executeUpdate();
        this.insertProperty.setString(1, data.getUUID());
        this.insertProperty.setInt(2, data.getType());
        this.insertProperty.setBoolean(3, data.isMultiValued());
        this.insertProperty.setString(4, data.getParentUUID());
        this.insertProperty.executeUpdate();
    }

    protected void addReference(PropertyData data) throws SQLException, IOException {
        if (this.insertReference == null) {
            this.insertReference = this.dbConnection.prepareStatement(this.INSERT_REF);
        }
        List values = data.getValues();
        for (int i = 0; i < values.size(); ++i) {
            ValueData vdata = (ValueData)values.get(i);
            String refNodeUuid = new String(BLOBUtil.readValue((ValueData)vdata));
            this.insertReference.setString(1, refNodeUuid);
            this.insertReference.setString(2, data.getUUID());
            this.insertReference.setInt(3, i);
            this.insertReference.executeUpdate();
        }
    }

    protected void deleteReference(String propertyUuid) throws SQLException {
        if (this.deleteReference == null) {
            this.deleteReference = this.dbConnection.prepareStatement(this.DELETE_REF);
        }
        this.deleteReference.setString(1, propertyUuid);
        this.deleteReference.executeUpdate();
    }

    protected int deleteItemByUUID(String uuid) throws SQLException {
        if (this.deleteItem == null) {
            this.deleteItem = this.dbConnection.prepareStatement(this.DELETE_ITEM);
        }
        this.deleteItem.setString(1, uuid);
        return this.deleteItem.executeUpdate();
    }

    protected int deleteNodeByUUID(String uuid) throws SQLException {
        if (this.deleteNode == null) {
            this.deleteNode = this.dbConnection.prepareStatement(this.DELETE_NODE);
        }
        this.deleteNode.setString(1, uuid);
        return this.deleteNode.executeUpdate();
    }

    protected int deletePropertyByUUID(String uuid) throws SQLException {
        if (this.deleteProperty == null) {
            this.deleteProperty = this.dbConnection.prepareStatement(this.DELETE_PROPERTY);
        }
        this.deleteProperty.setString(1, uuid);
        return this.deleteProperty.executeUpdate();
    }

    protected int updateItemPathByUUID(String qpath, int version, String uuid) throws SQLException {
        if (this.updateItemPath == null) {
            this.updateItemPath = this.dbConnection.prepareStatement(this.UPDATE_ITEM_PATH);
        }
        this.updateItemPath.setString(1, qpath);
        this.updateItemPath.setInt(2, version);
        this.updateItemPath.setString(3, uuid);
        return this.updateItemPath.executeUpdate();
    }

    protected int updateItemVersionByUUID(int versionValue, String uuid) throws SQLException {
        if (this.updateItem == null) {
            this.updateItem = this.dbConnection.prepareStatement(this.UPDATE_ITEM);
        }
        this.updateItem.setInt(1, versionValue);
        this.updateItem.setString(2, uuid);
        return this.updateItem.executeUpdate();
    }

    protected int updateNodeOrderNumbByUUID(int orderNumb, String uuid) throws SQLException {
        if (this.updateNode == null) {
            this.updateNode = this.dbConnection.prepareStatement(this.UPDATE_NODE);
        }
        this.updateNode.setInt(1, orderNumb);
        this.updateNode.setString(2, uuid);
        return this.updateNode.executeUpdate();
    }

    protected int updatePropertyTypeByUUID(int type, String uuid) throws SQLException {
        if (this.updateProperty == null) {
            this.updateProperty = this.dbConnection.prepareStatement(this.UPDATE_PROPERTY);
        }
        this.updateProperty.setInt(1, type);
        this.updateProperty.setString(2, uuid);
        return this.updateProperty.executeUpdate();
    }

    protected ResultSet findItemByPath(String path) throws SQLException {
        if (this.findItemByPath == null) {
            this.findItemByPath = this.dbConnection.prepareStatement(this.FIND_ITEM_BY_PATH);
        }
        this.findItemByPath.setString(1, path);
        return this.findItemByPath.executeQuery();
    }

    protected ResultSet findPropertyByPath(String parentId, String path) throws SQLException {
        if (this.findChildPropertyByPath == null) {
            this.findChildPropertyByPath = this.dbConnection.prepareStatement(this.FIND_CHILD_PROPERTY_BY_PATH);
        }
        this.findChildPropertyByPath.setString(1, path);
        this.findChildPropertyByPath.setString(2, parentId);
        return this.findChildPropertyByPath.executeQuery();
    }

    protected ResultSet findItemByUUID(String uuid) throws SQLException {
        if (this.findItemById == null) {
            this.findItemById = this.dbConnection.prepareStatement(this.FIND_ITEM_BY_ID);
        }
        this.findItemById.setString(1, uuid);
        return this.findItemById.executeQuery();
    }

    protected ResultSet findDescendantNodes(String parentId, String parentPath) throws SQLException {
        if (this.findDescendantNodes == null) {
            this.findDescendantNodes = this.dbConnection.prepareStatement(this.FIND_DESCENDANT_NODES_LIKE_PATH);
        }
        this.findDescendantNodes.setString(1, parentId);
        this.findDescendantNodes.setString(2, parentPath + "%");
        return this.findDescendantNodes.executeQuery();
    }

    protected ResultSet findDescendantProperties(String parentId, String parentPath) throws SQLException {
        if (this.findDescendantProperties == null) {
            this.findDescendantProperties = this.dbConnection.prepareStatement(this.FIND_DESCENDANT_PROPERTIES_LIKE_PATH);
        }
        this.findDescendantProperties.setString(1, parentId);
        this.findDescendantProperties.setString(2, parentPath + "%");
        return this.findDescendantProperties.executeQuery();
    }

    protected ResultSet findReferences(String nodeUuid) throws SQLException {
        if (this.findReferences == null) {
            this.findReferences = this.dbConnection.prepareStatement(this.FIND_REFERENCES);
        }
        this.findReferences.setString(1, nodeUuid);
        return this.findReferences.executeQuery();
    }

    protected ResultSet findChildNodesByParentUUID(String parentUUID) throws SQLException {
        if (this.findNodesByParentId == null) {
            this.findNodesByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID);
        }
        this.findNodesByParentId.setString(1, parentUUID);
        return this.findNodesByParentId.executeQuery();
    }

    protected ResultSet findChildPropertiesByParentUUID(String parentUUID) throws SQLException {
        if (this.findPropertiesByParentId == null) {
            this.findPropertiesByParentId = this.dbConnection.prepareStatement(this.FIND_PROPERTIES_BY_PARENTID);
        }
        this.findPropertiesByParentId.setString(1, parentUUID);
        return this.findPropertiesByParentId.executeQuery();
    }
}

