/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.update;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.util.io.BLOBUtil;
import org.exoplatform.services.log.ExoLogger;

public class StorageUpdateManager {
    protected static Log log = ExoLogger.getLogger((String)"jcr.StorageUpdateManager");
    public static final String STORAGE_VERSION_1_0_0 = "1.0";
    public static final String STORAGE_VERSION_1_0_1 = "1.0.1";
    public static final String STORAGE_VERSION_1_1_0 = "1.1";
    public static final String STORAGE_VERSION_1_5_0 = "1.5";
    public static final String FIRST_STORAGE_VERSION = "1.0";
    public static final String PREV_STORAGE_VERSION = "1.1";
    public static final String REQUIRED_STORAGE_VERSION = "1.5";
    protected static final String SQL_INSERT_VERSION = "insert into JCR_CONTAINER(VERSION) values(?)";
    protected static final String SQL_UPDATE_VERSION = "update JCR_CONTAINER set VERSION=?";
    protected static final String SQL_SELECT_VERSION = "select VERSION from JCR_CONTAINER";
    protected static final String SQL_UPDATE_JCRUUID_MULTIDB = "update JCR_MVALUE set DATA=? where ID=?";
    protected static final String SQL_UPDATE_JCRUUID_SINGLEDB = "update JCR_SVALUE set DATA=? where ID=?";
    protected static final String SQL_SELECT_JCRUUID_MULTIDB = "select I.PATH, N.ID as NID, V.ID as VID, V.DATA from JCR_MITEM I, JCR_MNODE N, JCR_MPROPERTY P, JCR_MVALUE V WHERE I.ID = P.ID and N.ID = P.PARENT_ID and P.ID = V.PROPERTY_ID and I.PATH like '%" + Constants.JCR_UUID.getAsString() + "%' " + "order by V.ID";
    protected static final String SQL_SELECT_JCRUUID_SINGLEDB = "select I.PATH, N.ID as NID, V.ID as VID, V.DATA from JCR_SITEM I, JCR_SNODE N, JCR_SPROPERTY P, JCR_SVALUE V WHERE I.ID = P.ID and N.ID = P.PARENT_ID and P.ID = V.PROPERTY_ID and I.PATH like '%" + Constants.JCR_UUID.getAsString() + "%' " + "order by V.ID";
    protected static final String FROZENJCRUUID = "$FROZENJCRUUID$";
    protected static final String SQL_SELECT_FROZENJCRUUID_MULTIDB = "select I.PATH, N.ID as NID, V.ID as VID, V.DATA from JCR_MITEM I, JCR_MNODE N, JCR_MPROPERTY P, JCR_MVALUE V WHERE I.ID = P.ID and N.ID = P.PARENT_ID and P.ID = V.PROPERTY_ID and I.PATH like '$FROZENJCRUUID$' order by V.ID";
    protected static final String SQL_SELECT_FROZENJCRUUID_SINGLEDB = "select I.PATH, N.ID as NID, V.ID as VID, V.DATA from JCR_SITEM I, JCR_SNODE N, JCR_SPROPERTY P, JCR_SVALUE V WHERE I.ID = P.ID and N.ID = P.PARENT_ID and P.ID = V.PROPERTY_ID and I.PATH like '$FROZENJCRUUID$' order by V.ID";
    protected static final String SQL_SELECT_REFERENCES_MULTIDB = "select I.PATH, V.PROPERTY_ID, V.ORDER_NUM, V.DATA from JCR_MITEM I, JCR_MPROPERTY P, JCR_MVALUE V where I.ID=P.ID and P.ID=V.PROPERTY_ID and P.TYPE=9 order by I.ID, V.ORDER_NUM";
    protected static final String SQL_SELECT_REFERENCES_SINGLEDB = "select I.PATH, V.PROPERTY_ID, V.ORDER_NUM, V.DATA from JCR_SITEM I, JCR_SPROPERTY P, JCR_SVALUE V where I.ID=P.ID and P.ID=V.PROPERTY_ID and P.TYPE=9 order by I.ID, V.ORDER_NUM";
    protected static final String SQL_INSERT_REFERENCES_MULTIDB = "insert into JCR_MREF (NODE_ID, PROPERTY_ID, ORDER_NUM) values(?,?,?)";
    protected static final String SQL_INSERT_REFERENCES_SINGLEDB = "insert into JCR_SREF (NODE_ID, PROPERTY_ID, ORDER_NUM) values(?,?,?)";
    protected final String SQL_SELECT_JCRUUID;
    protected final String SQL_SELECT_FROZENJCRUUID;
    protected final String SQL_UPDATE_JCRUUID;
    protected final String SQL_SELECT_REFERENCES;
    protected final String SQL_INSERT_REFERENCES;
    private final DataSource dataSource;
    private final String sourceName;
    private final boolean multiDB;

    private StorageUpdateManager(String sourceName, DataSource dataSource, boolean multiDB) {
        this.dataSource = dataSource;
        this.sourceName = sourceName;
        this.multiDB = multiDB;
        this.SQL_SELECT_JCRUUID = multiDB ? SQL_SELECT_JCRUUID_MULTIDB : SQL_SELECT_JCRUUID_SINGLEDB;
        this.SQL_SELECT_FROZENJCRUUID = multiDB ? SQL_SELECT_FROZENJCRUUID_MULTIDB : SQL_SELECT_FROZENJCRUUID_SINGLEDB;
        this.SQL_UPDATE_JCRUUID = multiDB ? SQL_UPDATE_JCRUUID_MULTIDB : SQL_UPDATE_JCRUUID_SINGLEDB;
        this.SQL_SELECT_REFERENCES = multiDB ? SQL_SELECT_REFERENCES_MULTIDB : SQL_SELECT_REFERENCES_SINGLEDB;
        this.SQL_INSERT_REFERENCES = multiDB ? SQL_INSERT_REFERENCES_MULTIDB : SQL_INSERT_REFERENCES_SINGLEDB;
    }

    public static synchronized String checkVersion(String sourceName, DataSource ds, boolean multiDB, boolean updateNow) throws RepositoryException {
        StorageUpdateManager manager = new StorageUpdateManager(sourceName, ds, multiDB);
        try {
            return manager.applyUpdate(updateNow);
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private String applyUpdate(boolean updateNow) throws Exception {
        String curVersion = this.currentVersion();
        Updater updater = null;
        if ("1.0".equals(curVersion)) {
            updater = new Updater100();
        } else if (STORAGE_VERSION_1_0_1.equals(curVersion)) {
            updater = new Updater101();
        }
        if (updater != null) {
            if (!updateNow) {
                log.warn((Object)("STORAGE VERSION OF " + this.sourceName + " IS " + curVersion + " IT IS HIGHLY RECOMMENDED TO UPDATE IT TO " + "1.5" + " ENABLE UPDATING in the CONFIGURATION:\n <container class='...'>\n" + "  <properties> \n   <property name='update-storage' value='true'/> \n ...\n"));
            } else {
                updater.update();
                curVersion = "1.5";
            }
        }
        return curVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String currentVersion() throws SQLException {
        Connection conn = this.dataSource.getConnection();
        conn.setAutoCommit(false);
        ResultSet version = null;
        try {
            version = conn.createStatement().executeQuery(SQL_SELECT_VERSION);
            if (version.next()) {
                String string = version.getString("VERSION");
                return string;
            }
        }
        catch (SQLException e) {
            String string = "1.0";
            return string;
        }
        finally {
            if (version != null) {
                version.close();
            }
        }
        PreparedStatement insertVersion = conn.prepareStatement(SQL_INSERT_VERSION);
        insertVersion.setString(1, "1.5");
        insertVersion.executeUpdate();
        conn.commit();
        conn.close();
        return "1.5";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixCopyUuidBug(Connection conn) throws SQLException {
        ResultSet refs = null;
        Statement update = null;
        try {
            refs = conn.createStatement().executeQuery(this.SQL_SELECT_JCRUUID);
            update = conn.prepareStatement(this.SQL_UPDATE_JCRUUID);
            while (refs.next()) {
                try {
                    JcrUuid jcrUuid = new JcrUuid(refs.getString("PATH"), refs.getString("NID"), refs.getString("VID"), refs.getBinaryStream("DATA"));
                    if (jcrUuid.getNodeUuid().equals(jcrUuid.getJcrUuid())) continue;
                    log.info((Object)("STORAGE UPDATE >>>: Property jcr:uuid have to be updated with actual value. Property: " + jcrUuid.getPath() + ", actual:" + jcrUuid.getNodeUuid() + ", existed: " + jcrUuid.getJcrUuid()));
                    update.clearParameters();
                    update.setBinaryStream(1, new ByteArrayInputStream(jcrUuid.getNodeUuid().getBytes()), jcrUuid.getNodeUuid().length());
                    update.setString(2, jcrUuid.getValueId());
                    if (update.executeUpdate() != 1) {
                        log.warn((Object)("STORAGE UPDATE !!!: More than one jcr:uuid property values were updated. Updated value id: " + jcrUuid.getValueId()));
                        continue;
                    }
                    log.info((Object)("STORAGE UPDATE <<<: Property jcr:uuid update successful. Property: " + jcrUuid.getPath()));
                }
                catch (IOException e) {
                    log.error((Object)("Can't read property value data: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (refs != null) {
                refs.close();
            }
            if (update != null) {
                update.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixCopyFrozenUuidBug(JcrUuid jcrUuid, Connection conn) throws SQLException {
        String searchCriteria = "'" + Constants.JCR_VERSION_STORAGE_PATH.getAsString() + ":1[]" + jcrUuid.getNodeUuid() + "%" + Constants.JCR_FROZENUUID.getAsString() + "%' ";
        ResultSet refs = null;
        Statement update = null;
        try {
            String sql = this.SQL_SELECT_FROZENJCRUUID.replaceAll(FROZENJCRUUID, searchCriteria);
            refs = conn.createStatement().executeQuery(this.SQL_SELECT_FROZENJCRUUID);
            while (refs.next()) {
                try {
                    JcrUuid frozenUuid = new JcrUuid(refs.getString("PATH"), refs.getString("NID"), refs.getString("VID"), refs.getBinaryStream("DATA"));
                    if (frozenUuid.getNodeUuid().equals(frozenUuid.getJcrUuid())) continue;
                    log.info((Object)("VERSION STORAGE UPDATE >>>: Property jcr:frozenUuid have to be updated with actual value. Property: " + frozenUuid.getPath() + ", actual:" + jcrUuid.getNodeUuid() + ", existed: " + frozenUuid.getJcrUuid()));
                }
                catch (IOException e) {
                    log.error((Object)("Can't read property value data: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)("Fix of copy uuid bug. Storage update error: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (refs != null) {
                refs.close();
            }
            if (update != null) {
                update.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillReferences(Connection conn) throws SQLException {
        ResultSet refs = null;
        Statement update = null;
        try {
            refs = conn.createStatement().executeQuery(this.SQL_SELECT_REFERENCES);
            update = conn.prepareStatement(this.SQL_INSERT_REFERENCES);
            while (refs.next()) {
                try {
                    String refNodeUuid = new String(BLOBUtil.readStream((InputStream)refs.getBinaryStream("DATA")));
                    String refPropertyUuid = refs.getString("PROPERTY_ID");
                    int refOrderNum = refs.getInt("ORDER_NUM");
                    String refPropertyPath = refs.getString("PATH");
                    log.info((Object)("INSERT REFERENCE >>> Property: " + refPropertyPath + ", " + refPropertyUuid + ", " + refOrderNum + "; Node UUID: " + refNodeUuid));
                    update.clearParameters();
                    update.setString(1, refNodeUuid);
                    update.setString(2, refPropertyUuid);
                    update.setInt(3, refOrderNum);
                    if (update.executeUpdate() != 1) {
                        log.warn((Object)"INSERT REFERENCE !!!: More than one REFERENCE property was copied");
                        continue;
                    }
                    log.info((Object)("INSERT REFERENCE <<<: Done. Property: " + refPropertyPath));
                }
                catch (IOException e) {
                    log.error((Object)("Can't read property value data: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)("Fill references. Storage update error: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (refs != null) {
                refs.close();
            }
            if (update != null) {
                update.close();
            }
        }
    }

    private class Updater101
    extends Updater {
        private Updater101() {
        }

        public void updateBody(Connection conn) throws SQLException {
            StorageUpdateManager.this.fillReferences(conn);
        }
    }

    private class Updater100
    extends Updater {
        private Updater100() {
        }

        public void updateBody(Connection conn) throws SQLException {
            StorageUpdateManager.this.fixCopyUuidBug(conn);
            StorageUpdateManager.this.fillReferences(conn);
        }
    }

    private abstract class Updater {
        private Updater() {
        }

        protected abstract void updateBody(Connection var1) throws SQLException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update() throws SQLException {
            Connection conn = null;
            try {
                conn = StorageUpdateManager.this.dataSource.getConnection();
                conn.setAutoCommit(false);
                conn.setTransactionIsolation(8);
                this.updateBody(conn);
                PreparedStatement insertVersion = conn.prepareStatement(StorageUpdateManager.SQL_UPDATE_VERSION);
                insertVersion.setString(1, "1.5");
                insertVersion.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                if (conn != null) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException sqle) {
                        log.warn((Object)("Error of update rollback: " + sqle.getMessage()), (Throwable)sqle);
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    private class JcrUuid {
        private final String path;
        private final String nodeUuid;
        private final String jcrUuid;
        private final String valueId;

        public JcrUuid(String path, String nodeUuid, String valueId, InputStream valueData) throws IOException {
            this.path = path;
            this.nodeUuid = nodeUuid;
            this.valueId = valueId;
            this.jcrUuid = new String(BLOBUtil.readStream((InputStream)valueData));
        }

        public String getNodeUuid() {
            return this.nodeUuid;
        }

        public String getJcrUuid() {
            return this.jcrUuid;
        }

        public String getPath() {
            return this.path;
        }

        public String getValueId() {
            return this.valueId;
        }
    }
}

